/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.feature;

import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.ForcedShoulderState;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class ShoulderHamsterState {
    private ShoulderAnimationState currentState;
    private int timer;
    private final class_5819 random = class_5819.method_43047();
    private int sprintTransitionDelay = 0;
    private int idleSoundCooldown = 0;

    public ShoulderHamsterState() {
        this.currentState = ShoulderAnimationState.values()[this.random.method_43048(ShoulderAnimationState.values().length)];
        this.timer = this.getNewRandomDuration();
    }

    public void tick(boolean isPlayerSprinting, boolean isPlayerWalking) {
        boolean shouldForceLayDown;
        boolean bl = shouldForceLayDown = Configs.AHP.forceLayDownOnSprint && isPlayerSprinting || Configs.AHP.forceLayDownOnWalk && isPlayerWalking;
        if (shouldForceLayDown) {
            if (this.currentState != ShoulderAnimationState.LAYING_DOWN && this.sprintTransitionDelay == 0) {
                this.sprintTransitionDelay = this.random.method_39332(1, 7);
            }
            if (this.sprintTransitionDelay > 0) {
                --this.sprintTransitionDelay;
                if (this.sprintTransitionDelay == 0) {
                    this.currentState = ShoulderAnimationState.LAYING_DOWN;
                    this.timer = this.random.method_39332(5, 40);
                }
            }
        } else {
            this.sprintTransitionDelay = 0;
            if (this.timer > 0) {
                --this.timer;
            }
            if (this.timer <= 0) {
                if (((Boolean)Configs.AHP.enableDynamicShoulderAnimations.get()).booleanValue()) {
                    ShoulderAnimationState nextState;
                    while ((nextState = ShoulderAnimationState.values()[this.random.method_43048(ShoulderAnimationState.values().length)]) == this.currentState) {
                    }
                    this.currentState = nextState;
                    this.timer = this.getNewRandomDuration();
                } else {
                    switch ((ForcedShoulderState)((Object)Configs.AHP.forcedShoulderState.get())) {
                        case ALWAYS_SIT: {
                            ShoulderAnimationState shoulderAnimationState = ShoulderAnimationState.SITTING;
                            break;
                        }
                        case ALWAYS_LAY_DOWN: {
                            ShoulderAnimationState shoulderAnimationState = ShoulderAnimationState.LAYING_DOWN;
                            break;
                        }
                        default: {
                            ShoulderAnimationState shoulderAnimationState = this.currentState = ShoulderAnimationState.STANDING;
                        }
                    }
                }
            }
        }
        if (!Configs.AHP.silenceShoulderIdleSounds) {
            if (this.idleSoundCooldown > 0) {
                --this.idleSoundCooldown;
            } else if (this.random.method_43048(250) == 0) {
                class_3414 idleSound;
                class_310 client = class_310.method_1551();
                if (client.field_1724 != null && (idleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.random)) != null) {
                    client.method_1483().method_4873((class_1113)new class_1109(idleSound, class_3419.field_15248, 0.25f, 1.2f + (this.random.method_43057() - 0.5f) * 0.4f, this.random, client.field_1724.method_23317(), client.field_1724.method_23318(), client.field_1724.method_23321()));
                    this.idleSoundCooldown = 100;
                }
            }
        }
    }

    public ShoulderAnimationState getCurrentState() {
        return this.currentState;
    }

    private void updateHamsterEntityState(HamsterEntity hamster, ShoulderAnimationState stateToApply) {
        hamster.method_5841().method_12778(HamsterEntity.SHOULDER_ANIMATION_STATE, (Object)stateToApply.ordinal());
        hamster.setSitting(stateToApply == ShoulderAnimationState.SITTING, true);
    }

    private int getNewRandomDuration() {
        int max;
        int min = (Integer)Configs.AHP.shoulderMinStateSeconds.get() * 20;
        if (min >= (max = (Integer)Configs.AHP.shoulderMaxStateSeconds.get() * 20)) {
            return min;
        }
        return this.random.method_39332(min, max);
    }
}

