/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.PlayerEvent;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.SlotAccessor;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;

public class AHPCommonEvents {
    public static void init() {
        PlayerEvent.OPEN_MENU.register(AHPCommonEvents::onOpenMenu);
        EntityEvent.LIVING_HURT.register(AHPCommonEvents::onLivingHurt);
    }

    private static void onOpenMenu(class_1657 player, class_1703 menu) {
        if (player.method_37908().method_8608()) {
            return;
        }
        HashSet<class_1263> inventories = new HashSet<class_1263>();
        for (class_1735 slot : menu.field_7761) {
            class_1263 inv = ((SlotAccessor)slot).adorablehamsterpets$getInventory();
            if (inv == null) continue;
            inventories.add(inv);
        }
        for (class_1263 inv : inventories) {
            AdorableHamsterPets.replaceOldBooksInInventory(inv);
        }
    }

    private static EventResult onLivingHurt(class_1309 victim, class_1282 source, float amount) {
        HamsterEntity victimHamster;
        HamsterEntity h;
        HamsterEntity h2;
        if (victim.method_37908().method_8608()) {
            return EventResult.pass();
        }
        class_1297 direct = source.method_5526();
        class_1297 attacker = source.method_5529();
        AdorableHamsterPets.LOGGER.trace("onLivingHurt: victim={} srcType={} attacker={}({}) direct={}({}) amount={}", new Object[]{victim.method_5864().toString(), source.method_5525(), attacker, attacker == null ? "null" : attacker.getClass().getSimpleName(), direct, direct == null ? "null" : direct.getClass().getSimpleName(), Float.valueOf(amount)});
        HamsterEntity hamster = null;
        if (direct instanceof HamsterEntity && (h2 = (HamsterEntity)direct).method_6181()) {
            hamster = h2;
        } else if (attacker instanceof HamsterEntity && (h = (HamsterEntity)attacker).method_6181()) {
            hamster = h;
        }
        if (hamster != null) {
            boolean victimIsTameable = victim instanceof class_1321;
            AdorableHamsterPets.LOGGER.trace("hamster\u2192pet branch entered: hamsterTamed={} victim instanceof TameableEntity={}", (Object)hamster.method_6181(), (Object)victimIsTameable);
            class_1309 hamsterOwner = hamster.method_35057();
            class_1309 victimOwner = AHPCommonEvents.getPetOwner(victim);
            AdorableHamsterPets.LOGGER.trace("hamster\u2192pet owners: hamsterOwnerUuid={} victimOwnerUuid={}", hamsterOwner == null ? "null" : hamsterOwner.method_5667(), victimOwner == null ? "null" : victimOwner.method_5667());
            if (hamsterOwner != null && victimOwner != null && AHPCommonEvents.sameOwner(hamsterOwner, victimOwner)) {
                AdorableHamsterPets.LOGGER.trace("hamster\u2192pet: SAME OWNER detected, cancelling damage.");
                return EventResult.interruptFalse();
            }
        }
        if (victim instanceof HamsterEntity && (victimHamster = (HamsterEntity)victim).method_6181()) {
            class_1309 class_13092;
            class_1309 victimOwner = victimHamster.method_35057();
            if (attacker instanceof class_1309) {
                class_1309 leAttacker = (class_1309)attacker;
                class_13092 = AHPCommonEvents.getPetOwner(leAttacker);
            } else {
                class_13092 = null;
            }
            class_1309 attackerOwner = class_13092;
            AdorableHamsterPets.LOGGER.trace("onLivingHurt: symm hamsterOwnerUuid={} attackerOwnerUuid={}", victimOwner == null ? "null" : victimOwner.method_5667(), attackerOwner == null ? "null" : attackerOwner.method_5667());
            if (victimOwner != null && attackerOwner != null && AHPCommonEvents.sameOwner(victimOwner, attackerOwner)) {
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    @Nullable
    private static class_1309 getPetOwner(class_1309 entity) {
        class_1496 horse;
        UUID ownerId;
        if (entity instanceof class_1321) {
            class_1321 tame = (class_1321)entity;
            return tame.method_35057();
        }
        if (entity instanceof class_1496 && (ownerId = (horse = (class_1496)entity).method_6139()) != null) {
            return AHPCommonEvents.lookupLivingByUuid(entity.method_37908(), ownerId);
        }
        if (entity instanceof class_8046) {
            class_1309 le;
            class_8046 ownable = (class_8046)entity;
            class_1297 e = ownable.method_24921();
            return e instanceof class_1309 ? (le = (class_1309)e) : null;
        }
        try {
            Method m = entity.getClass().getMethod("getOwner", new Class[0]);
            Object ret = m.invoke((Object)entity, new Object[0]);
            if (ret instanceof class_1309) {
                class_1309 le = (class_1309)ret;
                return le;
            }
            if (ret instanceof class_1297) {
                class_1309 le;
                class_1297 e = (class_1297)ret;
                return e instanceof class_1309 ? (le = (class_1309)e) : null;
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        UUID id = AHPCommonEvents.tryGetUuid(entity, "getOwnerUuid");
        if (id == null) {
            id = AHPCommonEvents.tryGetUuid(entity, "getOwnerUUID");
        }
        if (id != null) {
            return AHPCommonEvents.lookupLivingByUuid(entity.method_37908(), id);
        }
        return null;
    }

    @Nullable
    private static UUID tryGetUuid(Object target, String methodName) {
        try {
            UUID u;
            Method m = target.getClass().getMethod(methodName, new Class[0]);
            Object ret = m.invoke(target, new Object[0]);
            return ret instanceof UUID ? (u = (UUID)ret) : null;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    @Nullable
    private static class_1309 lookupLivingByUuid(class_1937 world, UUID id) {
        class_1309 le;
        if (!(world instanceof class_3218)) {
            return null;
        }
        class_3218 server = (class_3218)world;
        class_1657 player = server.method_18470(id);
        if (player instanceof class_1309) {
            class_1309 le2 = (class_1309)player;
            return le2;
        }
        class_1297 any = server.method_14190(id);
        return any instanceof class_1309 ? (le = (class_1309)any) : null;
    }

    private static boolean sameOwner(class_1309 a, class_1309 b) {
        return a == b || a.method_5667().equals(b.method_5667());
    }
}

