/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class HamsterRenderTracker {
    private static final Map<Integer, Set<UUID>> RENDER_TRACKING_MAP = new ConcurrentHashMap<Integer, Set<UUID>>();

    public static void addPlayer(int hamsterId, UUID playerId) {
        RENDER_TRACKING_MAP.computeIfAbsent(hamsterId, k -> Collections.newSetFromMap(new ConcurrentHashMap())).add(playerId);
    }

    public static void removePlayer(int hamsterId, UUID playerId) {
        Set<UUID> players = RENDER_TRACKING_MAP.get(hamsterId);
        if (players != null) {
            players.remove(playerId);
            if (players.isEmpty()) {
                RENDER_TRACKING_MAP.remove(hamsterId);
            }
        }
    }

    public static void onPlayerDisconnect(UUID playerId) {
        RENDER_TRACKING_MAP.forEach((hamsterId, playerSet) -> playerSet.remove(playerId));
        RENDER_TRACKING_MAP.entrySet().removeIf(entry -> ((Set)entry.getValue()).isEmpty());
    }

    public static void onEntityUnload(int hamsterId) {
        RENDER_TRACKING_MAP.remove(hamsterId);
    }

    public static boolean isBeingRendered(int hamsterId) {
        Set<UUID> players = RENDER_TRACKING_MAP.get(hamsterId);
        return players != null && !players.isEmpty();
    }
}

