/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.world;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.world.fabric.ModWorldGenerationImpl;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public class ModWorldGeneration {
    private static final Set<class_2960> SUNFLOWER_IDS = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> SUNFLOWER_TAGS = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> GREEN_BEAN_BUSH_IDS = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> GREEN_BEAN_BUSH_TAGS = new HashSet<class_6862<class_1959>>();
    private static final Set<class_6862<class_1959>> GREEN_BEAN_BUSH_CONVENTION_TAGS = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> GREEN_BEAN_BUSH_EXCLUSIONS = new HashSet<class_2960>();
    private static final Set<class_2960> CUCUMBER_BUSH_IDS = new HashSet<class_2960>();
    private static final Set<class_6862<class_1959>> CUCUMBER_BUSH_TAGS = new HashSet<class_6862<class_1959>>();
    private static final Set<class_6862<class_1959>> CUCUMBER_BUSH_CONVENTION_TAGS = new HashSet<class_6862<class_1959>>();
    private static final Set<class_2960> CUCUMBER_BUSH_EXCLUSIONS = new HashSet<class_2960>();

    public static void generateModWorldGen() {
        AdorableHamsterPets.LOGGER.info("Registering Biome Modifications for adorablehamsterpets");
        ModWorldGeneration.registerBiomeModifications();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBiomeModifications() {
        ModWorldGenerationImpl.registerBiomeModifications();
    }

    public static void parseConfig() {
        SUNFLOWER_IDS.clear();
        SUNFLOWER_TAGS.clear();
        GREEN_BEAN_BUSH_IDS.clear();
        GREEN_BEAN_BUSH_TAGS.clear();
        GREEN_BEAN_BUSH_CONVENTION_TAGS.clear();
        GREEN_BEAN_BUSH_EXCLUSIONS.clear();
        CUCUMBER_BUSH_IDS.clear();
        CUCUMBER_BUSH_TAGS.clear();
        CUCUMBER_BUSH_CONVENTION_TAGS.clear();
        CUCUMBER_BUSH_EXCLUSIONS.clear();
        Configs.AHP.sunflowerBiomes.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, SUNFLOWER_IDS, "sunflowerBiomes"));
        Configs.AHP.sunflowerBiomeTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, SUNFLOWER_TAGS, "sunflowerBiomeTags"));
        Configs.AHP.greenBeanBushBiomes.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, GREEN_BEAN_BUSH_IDS, "greenBeanBushBiomes"));
        Configs.AHP.greenBeanBushTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, GREEN_BEAN_BUSH_TAGS, "greenBeanBushTags"));
        Configs.AHP.greenBeanBushConventionTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, GREEN_BEAN_BUSH_CONVENTION_TAGS, "greenBeanBushConventionTags"));
        Configs.AHP.greenBeanBushExclusions.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, GREEN_BEAN_BUSH_EXCLUSIONS, "greenBeanBushExclusions"));
        Configs.AHP.cucumberBushBiomes.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, CUCUMBER_BUSH_IDS, "cucumberBushBiomes"));
        Configs.AHP.cucumberBushTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, CUCUMBER_BUSH_TAGS, "cucumberBushTags"));
        Configs.AHP.cucumberBushConventionTags.forEach(tagStr -> ModWorldGeneration.parseTag(tagStr, CUCUMBER_BUSH_CONVENTION_TAGS, "cucumberBushConventionTags"));
        Configs.AHP.cucumberBushExclusions.forEach(idStr -> ModWorldGeneration.parseIdentifier(idStr, CUCUMBER_BUSH_EXCLUSIONS, "cucumberBushExclusions"));
        AdorableHamsterPets.LOGGER.info("[FeatureConfig] Parsed feature generation settings from config.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldFeatureSpawnInBiome(class_6880<class_6796> feature, class_6880<class_1959> biome) {
        boolean bl;
        String featurePath;
        class_2960 featureId = feature.method_40230().map(class_5321::method_29177).orElse(null);
        class_2960 biomeId = biome.method_40230().map(class_5321::method_29177).orElse(null);
        if (featureId == null) return false;
        if (biomeId == null) {
            return false;
        }
        switch (featurePath = featureId.method_12832()) {
            case "custom_sunflower_placed": 
            case "patch_sunflower": {
                class_6880 entry;
                if (!SUNFLOWER_IDS.contains(biomeId)) {
                    if (!SUNFLOWER_TAGS.stream().anyMatch(arg_0 -> biome.method_40220(arg_0))) return false;
                }
                boolean bl2 = true;
                boolean isAllowedByConfig = bl2;
                if (!isAllowedByConfig) {
                    return false;
                }
                List allFeaturesByStep = ((class_1959)biome.comp_349()).method_30970().method_30983();
                int vegetalStep = class_2893.class_2895.field_13178.ordinal();
                if (vegetalStep >= allFeaturesByStep.size()) {
                    return false;
                }
                class_6885 vegetalFeatures = (class_6885)allFeaturesByStep.get(vegetalStep);
                Iterator iterator = vegetalFeatures.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                } while (!(entry = (class_6880)iterator.next()).method_40225(class_6819.field_36163));
                bl = true;
                break;
            }
            case "wild_green_bean_bush_placed": {
                if (!GREEN_BEAN_BUSH_IDS.contains(biomeId)) {
                    if (!GREEN_BEAN_BUSH_TAGS.stream().anyMatch(arg_0 -> biome.method_40220(arg_0))) {
                        if (!GREEN_BEAN_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> biome.method_40220(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            case "wild_cucumber_bush_placed": {
                if (!CUCUMBER_BUSH_IDS.contains(biomeId)) {
                    if (!CUCUMBER_BUSH_TAGS.stream().anyMatch(arg_0 -> biome.method_40220(arg_0))) {
                        if (!CUCUMBER_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> biome.method_40220(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        boolean isCandidate = bl;
        if (!isCandidate) {
            return false;
        }
        switch (featurePath) {
            case "wild_green_bean_bush_placed": {
                if (GREEN_BEAN_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            case "wild_cucumber_bush_placed": {
                if (CUCUMBER_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            default: {
                return true;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean shouldFeatureSpawnInBiome(class_5321<class_6796> featureKey, BiomeModifications.BiomeContext context) {
        boolean bl;
        String featurePath;
        class_2960 biomeId = context.getKey().orElse(null);
        if (biomeId == null) {
            return false;
        }
        switch (featurePath = featureKey.method_29177().method_12832()) {
            case "custom_sunflower_placed": 
            case "patch_sunflower": {
                if (!SUNFLOWER_IDS.contains(biomeId)) {
                    if (!SUNFLOWER_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) return false;
                }
                bl = true;
                break;
            }
            case "wild_green_bean_bush_placed": {
                if (!GREEN_BEAN_BUSH_IDS.contains(biomeId)) {
                    if (!GREEN_BEAN_BUSH_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) {
                        if (!GREEN_BEAN_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            case "wild_cucumber_bush_placed": {
                if (!CUCUMBER_BUSH_IDS.contains(biomeId)) {
                    if (!CUCUMBER_BUSH_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) {
                        if (!CUCUMBER_BUSH_CONVENTION_TAGS.stream().anyMatch(arg_0 -> ((BiomeModifications.BiomeContext)context).hasTag(arg_0))) return false;
                    }
                }
                bl = true;
                break;
            }
            default: {
                return false;
            }
        }
        boolean isCandidate = bl;
        if (!isCandidate) {
            return false;
        }
        switch (featurePath) {
            case "wild_green_bean_bush_placed": {
                if (GREEN_BEAN_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            case "wild_cucumber_bush_placed": {
                if (CUCUMBER_BUSH_EXCLUSIONS.contains(biomeId)) return false;
                return true;
            }
            default: {
                return true;
            }
        }
    }

    private static void parseIdentifier(String idStr, Set<class_2960> set, String configListName) {
        try {
            set.add(new class_2960(idStr));
        }
        catch (Exception e) {
            AdorableHamsterPets.LOGGER.info("[FeatureConfig] Invalid identifier in '{}' config list: '{}'", (Object)configListName, (Object)idStr);
        }
    }

    private static void parseTag(String tagStr, Set<class_6862<class_1959>> set, String configListName) {
        try {
            set.add((class_6862<class_1959>)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)new class_2960(tagStr)));
        }
        catch (Exception e) {
            AdorableHamsterPets.LOGGER.info("[FeatureConfig] Invalid biome tag identifier in '{}' config list: '{}'", (Object)configListName, (Object)tagStr);
        }
    }
}

