/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets;

import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.utils.Env;
import net.dawson.adorablehamsterpets.ModRegistries;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.FirstJoinCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.command.ModCommands;
import net.dawson.adorablehamsterpets.component.ModDataComponentTypes;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.event.AHPCommonEvents;
import net.dawson.adorablehamsterpets.item.ModItemGroups;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.dawson.adorablehamsterpets.world.ModSpawnPlacements;
import net.dawson.adorablehamsterpets.world.ModWorldGeneration;
import net.dawson.adorablehamsterpets.world.gen.ModEntitySpawns;
import net.minecraft.class_1263;
import net.minecraft.class_1299;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8779;
import net.minecraft.class_9169;
import net.minecraft.class_9331;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdorableHamsterPets {
    public static final String MOD_ID = "adorablehamsterpets";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"adorablehamsterpets");
    public static AhpConfig CONFIG;

    public static void initRegistries() {
        CONFIG = Configs.AHP;
        ModEntities.register();
        ModDataComponentTypes.registerDataComponentTypes();
        ModSounds.register();
        ModBlocks.register();
        ModItems.register();
        ModItemGroups.register();
        ModScreenHandlers.register();
        ModCriteria.register();
    }

    public static void initCommonSetup() {
        if (System.getProperty("fabric-api.datagen") == null) {
            ModRegistries.registerCompostables();
            ModEntitySpawns.parseConfig();
            ModWorldGeneration.parseConfig();
            ModItemTags.parseConfig();
            if (Platform.getEnvironment() == Env.SERVER) {
                ModPackets.registerPayloads();
            }
            ModPackets.registerC2SPackets();
            ModWorldGeneration.registerBiomeModifications();
            AHPCommonEvents.init();
            PlayerEvent.PLAYER_JOIN.register(AdorableHamsterPets::onPlayerJoin);
            PlayerEvent.PLAYER_CLONE.register(AdorableHamsterPets::onPlayerClone);
            CommandRegistrationEvent.EVENT.register(ModCommands::register);
            LifecycleEvent.SETUP.register(AdorableHamsterPets::onSetup);
        }
    }

    public static void initAttributes() {
        EntityAttributeRegistry.register(ModEntities.HAMSTER, HamsterEntity::createHamsterAttributes);
    }

    private static void onSetup() {
        ModSpawnPlacements.register((class_1299)ModEntities.HAMSTER.get(), class_9169.field_48745, class_2902.class_2903.field_13203, (type, world, reason, pos, random) -> class_1429.method_20663((class_1299)type, (class_1936)world, (class_3730)reason, (class_2338)pos, (class_5819)random) || ModEntitySpawns.VALID_SPAWN_BLOCKS.contains(world.method_8320(pos.method_10074()).method_26204()));
    }

    private static void onPlayerJoin(class_3222 player) {
        if (Configs.AHP.enableAutoGuidebookDelivery) {
            class_2985 advancementTracker = player.method_14236();
            class_2960 flagAdvId = class_2960.method_60655((String)MOD_ID, (String)"technical/has_received_initial_guidebook");
            class_8779 flagAdvancementEntry = player.field_13995.method_3851().method_12896(flagAdvId);
            if (flagAdvancementEntry != null) {
                class_167 flagProgress = advancementTracker.method_12882(flagAdvancementEntry);
                if (!flagProgress.method_740()) {
                    ((FirstJoinCriterion)((Object)ModCriteria.FIRST_JOIN_GUIDEBOOK_CHECK.get())).trigger(player);
                    for (String criterion : flagAdvancementEntry.comp_1920().comp_1915().keySet()) {
                        advancementTracker.method_12878(flagAdvancementEntry, criterion);
                    }
                }
            } else {
                LOGGER.warn("Could not find flag advancement: {}", (Object)flagAdvId);
            }
        }
        AdorableHamsterPets.replaceOldBooksInInventory((class_1263)player.method_31548());
    }

    private static void onPlayerClone(class_3222 oldPlayer, class_3222 newPlayer, boolean wasDeath) {
        PlayerEntityAccessor oldPlayerAccessor = (PlayerEntityAccessor)oldPlayer;
        PlayerEntityAccessor newPlayerAccessor = (PlayerEntityAccessor)newPlayer;
        for (ShoulderLocation location : ShoulderLocation.values()) {
            class_2487 shoulderNbt = oldPlayerAccessor.getShoulderHamster(location);
            if (shoulderNbt.method_33133()) continue;
            if (wasDeath) {
                class_3218 world = oldPlayer.method_51469();
                HamsterEntity.spawnFromNbt(world, (class_1657)oldPlayer, shoulderNbt, false, null);
                LOGGER.debug("Player {} died. Spawning {} hamster at death location.", (Object)oldPlayer.method_5477().getString(), (Object)location);
                continue;
            }
            newPlayerAccessor.setShoulderHamster(location, shoulderNbt);
            LOGGER.debug("Player {} was cloned. Transferring {} hamster to new entity.", (Object)newPlayer.method_5477().getString(), (Object)location);
        }
    }

    public static void replaceOldBooksInInventory(class_1263 inventory) {
        class_9331 bookComponent = (class_9331)class_7923.field_49658.method_10223(class_2960.method_60655((String)"patchouli", (String)"book"));
        if (bookComponent == null) {
            return;
        }
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_31574((class_1792)ModItems.HAMSTER_GUIDE_BOOK.get()) || stack.method_57826(bookComponent)) continue;
            class_1799 newBookStack = new class_1799((class_1935)ModItems.HAMSTER_GUIDE_BOOK.get(), stack.method_7947());
            newBookStack.method_57379(bookComponent, (Object)class_2960.method_60655((String)MOD_ID, (String)"hamster_tips_guide_book"));
            inventory.method_5447(i, newBookStack);
            LOGGER.info("Upgraded an old Hamster Tips Guide Book to the new Patchouli version.");
        }
    }
}

