/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.announcements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;

public record Announcement(String id, String kind, String semver, String title, String markdown, ZonedDateTime published) {
    private static final Codec<ZonedDateTime> ZONED_DATE_TIME_CODEC = Codec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)ZonedDateTime.parse(s));
        }
        catch (DateTimeParseException e) {
            return DataResult.error(() -> "Not a valid ZonedDateTime: " + e.getMessage());
        }
    }, ZonedDateTime::toString);
    public static final Codec<Announcement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Announcement::id), (App)Codec.STRING.fieldOf("kind").forGetter(Announcement::kind), (App)Codec.STRING.fieldOf("semver").forGetter(Announcement::semver), (App)Codec.STRING.fieldOf("title").forGetter(Announcement::title), (App)Codec.STRING.fieldOf("markdown").forGetter(Announcement::markdown), (App)ZONED_DATE_TIME_CODEC.fieldOf("published").forGetter(Announcement::published)).apply((Applicative)instance, Announcement::new));
}

