/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.AppliedPinkPetalCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.CheekPouchUnlockedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.FedHamsterSteamedBeansCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterAutoFedCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterOnShoulderCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.HamsterPouchFilledCriterion;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.client.option.ModKeyBindings;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFleeGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFollowOwnerGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAroundGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAtEntityGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMateGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMeleeAttackGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSeekDiamondGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSitGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterStealDiamondGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterTemptGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.ImplementedInventory;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.control.HamsterBodyControl;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.mixin.accessor.LandPathNodeMakerInvoker;
import net.dawson.adorablehamsterpets.screen.HamsterScreenHandlerFactory;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModBiomeTags;
import net.dawson.adorablehamsterpets.tag.ModItemTags;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.class_124;
import net.minecraft.class_1262;
import net.minecraft.class_1264;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1330;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1531;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8046;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterEntity
extends class_1321
implements GeoEntity,
ImplementedInventory {
    private static final double WALK_TO_RUN_THRESHOLD_SQUARED = 0.002;
    private static final double RUN_TO_SPRINT_THRESHOLD_SQUARED = 0.008;
    public static final float FAST_YAW_CHANGE = 25.0f;
    public static final float FAST_PITCH_CHANGE = 25.0f;
    private static final int INVENTORY_SIZE = 6;
    private static final int REFUSE_FOOD_TIMER_TICKS = 40;
    private static final int CUSTOM_LOVE_TICKS = 600;
    private static final float THROW_DAMAGE = 20.0f;
    private static final double THROWN_GRAVITY = -0.05;
    private static final double HAMSTER_ATTACK_BOX_EXPANSION = 0.7;
    public static final int CELEBRATION_PARTICLE_DURATION_TICKS = 600;
    private static final float DEFAULT_FOOTSTEP_VOLUME = 0.1f;
    private static final float GRAVEL_VOLUME_MODIFIER = 0.6f;
    private static final Set<class_7> HAZARDOUS_FLOOR_TYPES = EnumSet.of(class_7.field_14, new class_7[]{class_7.field_3, class_7.field_9, class_7.field_33534, class_7.field_17, class_7.field_5, class_7.field_43351, class_7.field_18});
    private static final List<HamsterVariant> ORANGE_VARIANTS = List.of(HamsterVariant.ORANGE, HamsterVariant.ORANGE_OVERLAY1, HamsterVariant.ORANGE_OVERLAY2, HamsterVariant.ORANGE_OVERLAY3, HamsterVariant.ORANGE_OVERLAY4, HamsterVariant.ORANGE_OVERLAY5, HamsterVariant.ORANGE_OVERLAY6, HamsterVariant.ORANGE_OVERLAY7, HamsterVariant.ORANGE_OVERLAY8);
    private static final List<HamsterVariant> BLACK_VARIANTS = List.of(HamsterVariant.BLACK, HamsterVariant.BLACK_OVERLAY1, HamsterVariant.BLACK_OVERLAY2, HamsterVariant.BLACK_OVERLAY3, HamsterVariant.BLACK_OVERLAY4, HamsterVariant.BLACK_OVERLAY5, HamsterVariant.BLACK_OVERLAY6, HamsterVariant.BLACK_OVERLAY7, HamsterVariant.BLACK_OVERLAY8);
    private static final List<HamsterVariant> BLUE_VARIANTS = List.of(HamsterVariant.BLUE, HamsterVariant.BLUE_OVERLAY1, HamsterVariant.BLUE_OVERLAY2, HamsterVariant.BLUE_OVERLAY3, HamsterVariant.BLUE_OVERLAY4, HamsterVariant.BLUE_OVERLAY5, HamsterVariant.BLUE_OVERLAY6, HamsterVariant.BLUE_OVERLAY7, HamsterVariant.BLUE_OVERLAY8);
    private static final List<HamsterVariant> CHOCOLATE_VARIANTS = List.of(HamsterVariant.CHOCOLATE, HamsterVariant.CHOCOLATE_OVERLAY1, HamsterVariant.CHOCOLATE_OVERLAY2, HamsterVariant.CHOCOLATE_OVERLAY3, HamsterVariant.CHOCOLATE_OVERLAY4, HamsterVariant.CHOCOLATE_OVERLAY5, HamsterVariant.CHOCOLATE_OVERLAY6, HamsterVariant.CHOCOLATE_OVERLAY7, HamsterVariant.CHOCOLATE_OVERLAY8);
    private static final List<HamsterVariant> CREAM_VARIANTS = List.of(HamsterVariant.CREAM, HamsterVariant.CREAM_OVERLAY1, HamsterVariant.CREAM_OVERLAY2, HamsterVariant.CREAM_OVERLAY3, HamsterVariant.CREAM_OVERLAY4, HamsterVariant.CREAM_OVERLAY5, HamsterVariant.CREAM_OVERLAY6, HamsterVariant.CREAM_OVERLAY7, HamsterVariant.CREAM_OVERLAY8);
    private static final List<HamsterVariant> DARK_GRAY_VARIANTS = List.of(HamsterVariant.DARK_GRAY, HamsterVariant.DARK_GRAY_OVERLAY1, HamsterVariant.DARK_GRAY_OVERLAY2, HamsterVariant.DARK_GRAY_OVERLAY3, HamsterVariant.DARK_GRAY_OVERLAY4, HamsterVariant.DARK_GRAY_OVERLAY5, HamsterVariant.DARK_GRAY_OVERLAY6, HamsterVariant.DARK_GRAY_OVERLAY7, HamsterVariant.DARK_GRAY_OVERLAY8);
    private static final List<HamsterVariant> LAVENDER_VARIANTS = List.of(HamsterVariant.LAVENDER, HamsterVariant.LAVENDER_OVERLAY1, HamsterVariant.LAVENDER_OVERLAY2, HamsterVariant.LAVENDER_OVERLAY3, HamsterVariant.LAVENDER_OVERLAY4, HamsterVariant.LAVENDER_OVERLAY5, HamsterVariant.LAVENDER_OVERLAY6, HamsterVariant.LAVENDER_OVERLAY7, HamsterVariant.LAVENDER_OVERLAY8);
    private static final List<HamsterVariant> LIGHT_GRAY_VARIANTS = List.of(HamsterVariant.LIGHT_GRAY, HamsterVariant.LIGHT_GRAY_OVERLAY1, HamsterVariant.LIGHT_GRAY_OVERLAY2, HamsterVariant.LIGHT_GRAY_OVERLAY3, HamsterVariant.LIGHT_GRAY_OVERLAY4, HamsterVariant.LIGHT_GRAY_OVERLAY5, HamsterVariant.LIGHT_GRAY_OVERLAY6, HamsterVariant.LIGHT_GRAY_OVERLAY7, HamsterVariant.LIGHT_GRAY_OVERLAY8);
    private static final List<HamsterVariant> WHITE_VARIANTS = List.of(HamsterVariant.WHITE);
    public static final int SLEEPING_FLAG = 1;
    public static final int SITTING_FLAG = 2;
    public static final int BEGGING_FLAG = 4;
    public static final int IN_LOVE_FLAG = 8;
    public static final int REFUSING_FOOD_FLAG = 16;
    public static final int THROWN_FLAG = 32;
    public static final int LEFT_CHEEK_FULL_FLAG = 64;
    public static final int RIGHT_CHEEK_FULL_FLAG = 128;
    public static final int KNOCKED_OUT_FLAG = 256;
    public static final int CHEEK_POUCH_UNLOCKED_FLAG = 512;
    public static final int CONSIDERING_AUTO_EAT_FLAG = 1024;
    public static final int SULKING_FLAG = 2048;
    public static final int CELEBRATING_DIAMOND_FLAG = 4096;
    public static final int CLEANING_FLAG = 8192;
    public static final int STEALING_DIAMOND_FLAG = 16384;
    public static final int TAUNTING_FLAG = 32768;
    public static final int CELEBRATING_CHASE_FLAG = 65536;
    public static final int IS_SHOULDER_PET_FLAG = 131072;
    private static final class_2940<Integer> HAMSTER_FLAGS = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> ANIMATION_PERSONALITY_ID = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> PINK_PETAL_TYPE = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> DOZING_PHASE = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<String> CURRENT_DEEP_SLEEP_ANIM_ID = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> ACTIVE_CUSTOM_GOAL_NAME_DEBUG = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13326);
    public static final class_2940<Integer> STEAL_DURATION_TIMER = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<class_1799> STOLEN_ITEM_STACK = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13322);
    public static final class_2940<Long> GREEN_BEAN_BUFF_DURATION = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_39965);
    public static final class_2940<Integer> CURRENT_LOOK_UP_ANIM_ID = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> SHOULDER_ANIMATION_STATE = class_2945.method_12791(HamsterEntity.class, (class_2941)class_2943.field_13327);
    private static final RawAnimation CRASH_ANIM = RawAnimation.begin().thenPlay("anim_hamster_crash");
    private static final RawAnimation KNOCKED_OUT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_ko");
    private static final RawAnimation WAKE_UP_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup");
    private static final RawAnimation FLYING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_flying");
    private static final RawAnimation STATIONARY_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stationary_headshake");
    private static final RawAnimation MOVING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_moving_headshake");
    private static final RawAnimation SLEEP_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose1");
    private static final RawAnimation SLEEP_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose2");
    private static final RawAnimation SLEEP_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose3");
    private static final RawAnimation SIT_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep1");
    private static final RawAnimation SIT_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep2");
    private static final RawAnimation SIT_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep3");
    private static final RawAnimation STAND_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep1");
    private static final RawAnimation STAND_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep2");
    private static final RawAnimation STAND_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep3");
    private static final RawAnimation SITTING_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose1");
    private static final RawAnimation SITTING_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose2");
    private static final RawAnimation SITTING_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose3");
    private static final RawAnimation DRIFTING_OFF_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose1");
    private static final RawAnimation DRIFTING_OFF_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose2");
    private static final RawAnimation DRIFTING_OFF_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose3");
    private static final RawAnimation CLEANING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_cleaning");
    private static final RawAnimation RUNNING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_running");
    private static final RawAnimation WALKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_walking");
    private static final RawAnimation SPRINTING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sprinting");
    private static final RawAnimation BEGGING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_begging");
    private static final RawAnimation IDLE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle1");
    private static final RawAnimation IDLE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle2");
    private static final RawAnimation IDLE_LOOKING_UP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up1");
    private static final RawAnimation IDLE_LOOKING_UP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up2");
    private static final RawAnimation IDLE_LOOKING_UP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up3");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_attack");
    private static final RawAnimation SULK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulk");
    private static final RawAnimation SULKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulking");
    private static final RawAnimation SEEKING_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_seeking_diamond");
    private static final RawAnimation WANTS_TO_SEEK_DIAMOND_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wants_to_seek_diamond");
    private static final RawAnimation DIAMOND_POUNCE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_diamond_pounce");
    private static final RawAnimation DIAMOND_TAUNT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_diamond_taunt");
    private static final RawAnimation CELEBRATE_CHASE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_celebrate_chase");
    private static final RawAnimation LAYING_DOWN_HEAD_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_head");
    private static final RawAnimation LAYING_DOWN_RIGHT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_right_shoulder");
    private static final RawAnimation LAYING_DOWN_LEFT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_left_shoulder");
    @Unique
    public int interactionCooldown = 0;
    @Unique
    public int throwTicks = 0;
    @Unique
    public int wakingUpTicks = 0;
    @Unique
    private int ejectionCheckCooldown = 20;
    @Unique
    private int preAutoEatDelayTicks = 0;
    @Unique
    private int quiescentSitDurationTimer = 0;
    @Unique
    private int driftingOffTimer = 0;
    @Unique
    private int settleSleepAnimationCooldown = 0;
    @Unique
    private String activeCustomGoalDebugName = "None";
    @Unique
    public boolean isPrimedToSeekDiamonds = false;
    @Unique
    public long foundOreCooldownEndTick = 0L;
    @Unique
    public class_2338 currentOreTarget = null;
    @Unique
    private int celebrationParticleTicks = 0;
    @Unique
    private int diamondCelebrationSoundTicks = 0;
    @Unique
    private int sulkOrchestraHitDelayTicks = 0;
    @Unique
    private int sulkFailParticleTicks = 0;
    @Unique
    private int sulkEntityEffectTicks = 0;
    @Unique
    private int sulkShockedSoundDelayTicks = 0;
    @Unique
    private int diamondSparkleSoundDelayTicks = 0;
    @Unique
    public transient String particleEffectId = null;
    @Unique
    public transient String soundEffectId = null;
    @Unique
    public long stealCooldownEndTick = 0L;
    @Unique
    private int celebrationChaseTicks = 0;
    @Unique
    private boolean zoomiesIsClockwise = false;
    @Unique
    private double lastZoomiesAngle = 0.0;
    @Unique
    private int zoomiesRadiusModifier = 0;
    @Unique
    public transient float renderedSnowYOffset = 0.0f;
    @Unique
    public transient ShoulderLocation shoulderLocation = ShoulderLocation.RIGHT_SHOULDER;
    @Unique
    public int suffocationGracePeriod = 0;
    @Unique
    public transient float dynamicScaleY = 1.0f;
    private final class_2371<class_1799> items = ImplementedInventory.create(6);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int refuseTimer = 0;
    private class_1799 lastFoodItem = class_1799.field_8037;
    public int customLoveTimer;
    private int tamingCooldown = 0;
    public long throwCooldownEndTick = 0L;
    private long greenBeanBuffEndTick = 0L;
    private boolean isAutoEating = false;
    private int autoEatProgressTicks = 0;
    private int autoEatCooldownTicks = 0;
    public int cleaningTimer = 0;
    private int cleaningCooldownTimer = 0;

    private static HamsterVariant determineVariantForBiome(class_6880<class_1959> biomeEntry, class_5819 random) {
        String biomeName = biomeEntry.method_40230().map(k -> k.method_29177().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] determineVariantForBiome called for biome: {}", (Object)biomeName);
        HamsterVariant result = HamsterEntity.canSpawnBlue(biomeEntry) ? (random.method_43048(10) < 7 ? HamsterEntity.getRandomVariant(BLUE_VARIANTS, random) : HamsterVariant.WHITE) : (HamsterEntity.canSpawnLavender(biomeEntry) ? HamsterEntity.getRandomVariant(LAVENDER_VARIANTS, random) : (HamsterEntity.canSpawnWhite(biomeEntry) ? HamsterVariant.WHITE : (HamsterEntity.canSpawnGray(biomeEntry) ? (random.method_43056() ? HamsterEntity.getRandomVariant(LIGHT_GRAY_VARIANTS, random) : HamsterEntity.getRandomVariant(DARK_GRAY_VARIANTS, random)) : (HamsterEntity.canSpawnBlack(biomeEntry) ? HamsterVariant.BLACK : (HamsterEntity.canSpawnCream(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : (HamsterEntity.canSpawnChocolate(biomeEntry) ? HamsterEntity.getRandomVariant(CHOCOLATE_VARIANTS, random) : HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random)))))));
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Determined variant for {} is {}", (Object)biomeName, (Object)result.name());
        return result;
    }

    private static boolean canSpawnBlue(class_6880<class_1959> biomeEntry) {
        return biomeEntry.method_40220(ModBiomeTags.IS_ICY) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"glacial_chasm"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"mirage_isles"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"moonlight_valley"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"biomesoplenty", (String)"enchanted_garden")));
    }

    private static boolean canSpawnLavender(class_6880<class_1959> biomeEntry) {
        boolean isLavenderTheme = biomeEntry.method_40220(ModBiomeTags.IS_MUSHROOM) || biomeEntry.method_40220(ModBiomeTags.IS_MAGICAL) || biomeEntry.method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"mystical"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"biomesoplenty", (String)"fungi_forest"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"biomesoplenty", (String)"mystic_grove"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"sakura_valley"))) || biomeEntry.method_40225(class_1972.field_42720);
        return isLavenderTheme && !HamsterEntity.canSpawnBlue(biomeEntry);
    }

    private static boolean canSpawnWhite(class_6880<class_1959> biomeEntry) {
        boolean isWhiteTheme;
        boolean bl = isWhiteTheme = biomeEntry.method_40220(ModBiomeTags.IS_COLD) || biomeEntry.method_40220(ModBiomeTags.IS_SNOWY) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"snowy_maple_forest"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"wintry_forest"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"alpine_grove"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"siberian_grove")));
        if (!isWhiteTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !biomeEntry.method_40225(class_1972.field_9418) && !biomeEntry.method_40225(class_1972.field_9435) && !biomeEntry.method_40225(class_1972.field_9419) && !biomeEntry.method_40225(class_1972.field_35120) && !biomeEntry.method_40225(class_1972.field_35111) && !biomeEntry.method_40225(class_1972.field_35116) && !biomeEntry.method_40225(class_1972.field_9420) && !biomeEntry.method_40225(class_1972.field_35119) && !biomeEntry.method_40225(class_1972.field_35113);
    }

    private static boolean canSpawnGray(class_6880<class_1959> biomeEntry) {
        boolean isGrayTheme;
        boolean bl = isGrayTheme = biomeEntry.method_40220(ModBiomeTags.IS_MOUNTAIN) || biomeEntry.method_40220(ModBiomeTags.IS_SPARSE_VEGETATION) || biomeEntry.method_40220(class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"cliffs"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"stony_spires")));
        if (!isGrayTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !biomeEntry.method_40220(class_6908.field_36513) && !biomeEntry.method_40220(class_6908.field_36516) && !biomeEntry.method_40220(class_6908.field_37392);
    }

    private static boolean canSpawnBlack(class_6880<class_1959> biomeEntry) {
        boolean isBlackTheme;
        boolean bl = isBlackTheme = biomeEntry.method_40220(ModBiomeTags.IS_WET) || biomeEntry.method_40220(ModBiomeTags.IS_CAVE) || biomeEntry.method_40225(class_1972.field_37543);
        if (!isBlackTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !HamsterEntity.canSpawnGray(biomeEntry) && !biomeEntry.method_40220(class_6908.field_36516) && !biomeEntry.method_40220(class_6908.field_36510) && !biomeEntry.method_40225(class_1972.field_28107) && !biomeEntry.method_40225(class_1972.field_29218);
    }

    private static boolean canSpawnCream(class_6880<class_1959> biomeEntry) {
        boolean isCreamTheme;
        boolean bl = isCreamTheme = biomeEntry.method_40220(ModBiomeTags.IS_SANDY) || biomeEntry.method_40225(class_1972.field_35112) || biomeEntry.method_40225(class_1972.field_9412) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"ancient_sands"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"sandstone_valley"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"biomesoplenty", (String)"wasteland")));
        if (!isCreamTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !HamsterEntity.canSpawnGray(biomeEntry) && !HamsterEntity.canSpawnBlack(biomeEntry) && !biomeEntry.method_40220(class_6908.field_36513) && !biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"gravel_beach")));
    }

    private static boolean canSpawnChocolate(class_6880<class_1959> biomeEntry) {
        boolean isChocolateTheme;
        boolean bl = isChocolateTheme = biomeEntry.method_40220(ModBiomeTags.IS_FOREST) || biomeEntry.method_40220(ModBiomeTags.IS_DENSE_VEGETATION) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"terralith", (String)"cloud_forest"))) || biomeEntry.method_40225(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60655((String)"biomesoplenty", (String)"redwood_forest")));
        if (!isChocolateTheme) {
            return false;
        }
        return !HamsterEntity.canSpawnBlue(biomeEntry) && !HamsterEntity.canSpawnLavender(biomeEntry) && !HamsterEntity.canSpawnWhite(biomeEntry) && !HamsterEntity.canSpawnGray(biomeEntry) && !HamsterEntity.canSpawnBlack(biomeEntry) && !HamsterEntity.canSpawnCream(biomeEntry);
    }

    private static HamsterVariant getRandomVariant(List<HamsterVariant> variantPool, class_5819 random) {
        if (variantPool == null || variantPool.isEmpty()) {
            return HamsterVariant.ORANGE;
        }
        return variantPool.get(random.method_43048(variantPool.size()));
    }

    public static class_5132.class_5133 createHamsterAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)Configs.AHP.wildMaxHealth.get()).doubleValue()).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23721, ((Double)Configs.AHP.meleeDamage.get()).doubleValue()).method_26868(class_5134.field_23717, 40.0);
    }

    @Nullable
    public static HamsterEntity createFromNbt(class_3218 world, class_1657 player, class_2487 nbt) {
        Optional<HamsterShoulderData> dataOpt = HamsterShoulderData.fromNbt(nbt);
        if (dataOpt.isEmpty()) {
            AdorableHamsterPets.LOGGER.error("Failed to deserialize HamsterShoulderData from NBT: {}", (Object)nbt);
            return null;
        }
        HamsterShoulderData data = dataOpt.get();
        AdorableHamsterPets.LOGGER.debug("[HamsterEntity] createFromNbt called for player {} with data: {}", (Object)player.method_5477().getString(), (Object)data);
        HamsterEntity hamster = (HamsterEntity)((class_1299)ModEntities.HAMSTER.get()).method_5883((class_1937)world);
        if (hamster != null) {
            class_2487 effectsNbt;
            hamster.setVariant(data.variantId());
            hamster.method_6033(data.health());
            hamster.method_6174(player.method_5667());
            hamster.method_6173(true, true);
            hamster.method_5614(data.breedingAge());
            hamster.throwCooldownEndTick = data.throwCooldownEndTick();
            hamster.greenBeanBuffEndTick = data.greenBeanBuffEndTick();
            hamster.method_5841().method_12778(GREEN_BEAN_BUFF_DURATION, (Object)data.greenBeanBuffDuration());
            hamster.autoEatCooldownTicks = data.autoEatCooldownTicks();
            hamster.method_5841().method_12778(PINK_PETAL_TYPE, (Object)data.pinkPetalType());
            hamster.method_5841().method_12778(ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
            hamster.method_5841().method_12778(HAMSTER_FLAGS, (Object)data.hamsterFlags());
            hamster.setHamsterFlag(2, false);
            data.customName().ifPresent(name -> {
                if (!name.isEmpty()) {
                    hamster.method_5665((class_2561)class_2561.method_43470((String)name));
                }
            });
            class_5455 registries = world.method_30349();
            if (!data.inventoryNbt().method_33133()) {
                class_1262.method_5429((class_2487)data.inventoryNbt(), hamster.items, (class_7225.class_7874)registries);
                hamster.updateCheekTrackers();
            }
            if ((effectsNbt = data.activeEffectsNbt()).method_10573("active_effects", 9)) {
                class_2499 effectsList = effectsNbt.method_10554("active_effects", 10);
                for (class_2520 effectElement : effectsList) {
                    class_2487 effectInstanceNbt;
                    class_1293 effectInstance;
                    if (!(effectElement instanceof class_2487) || (effectInstance = class_1293.method_5583((class_2487)(effectInstanceNbt = (class_2487)effectElement))) == null) continue;
                    hamster.method_6092(effectInstance);
                }
            }
            HamsterShoulderData.SeekingBehaviorData seekingData = data.seekingBehaviorData();
            hamster.isPrimedToSeekDiamonds = seekingData.isPrimedToSeekDiamonds();
            hamster.foundOreCooldownEndTick = seekingData.foundOreCooldownEndTick();
            hamster.currentOreTarget = seekingData.currentOreTarget().orElse(null);
            hamster.isAutoEating = false;
            hamster.autoEatProgressTicks = 0;
            hamster.setHamsterFlag(8192, false);
            hamster.setDozingPhase(DozingPhase.NONE);
        }
        return hamster;
    }

    public static void spawnFromNbt(class_3218 world, class_1657 player, class_2487 nbt, boolean wasDiamondAlertActive, @Nullable HamsterEntity preconfiguredHamster) {
        HamsterEntity hamster;
        HamsterEntity hamsterEntity = hamster = preconfiguredHamster != null ? preconfiguredHamster : HamsterEntity.createFromNbt(world, player, nbt);
        if (hamster == null) {
            return;
        }
        hamster.suffocationGracePeriod = 200;
        if (wasDiamondAlertActive && Configs.AHP.enableIndependentDiamondSeeking) {
            hamster.isPrimedToSeekDiamonds = true;
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity {}] Primed for diamond seeking upon dismount.", (Object)hamster.method_5628());
        }
        if (hamster.isThrown()) {
            world.method_8649((class_1297)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned THROWN Hamster ID {} from NBT data near Player {}.", (Object)hamster.method_5628(), (Object)player.method_5477().getString());
        } else {
            class_2338 ultimateFallbackPos = player.method_24515();
            class_239 hitResult = player.method_5745(4.5, 0.0f, false);
            class_2338 initialSearchPos = hitResult.method_17783() == class_239.class_240.field_1332 ? ((class_3965)hitResult).method_17777() : ultimateFallbackPos;
            Optional<class_2338> safePosOpt = hamster.findSafeSpawnPosition(initialSearchPos, (class_1937)world, 5);
            safePosOpt.ifPresentOrElse(safePos -> {
                hamster.method_5808((double)safePos.method_10263() + 0.5, safePos.method_10264(), (double)safePos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                AdorableHamsterPets.LOGGER.debug("[HamsterDismount] Found safe spawn at {} for player {}.", safePos, (Object)player.method_5477().getString());
            }, () -> {
                AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Could not find a safe spawn position for player {}. Spawning at player's feet as a fallback.", (Object)player.method_5477().getString());
                hamster.method_5808((double)ultimateFallbackPos.method_10263() + 0.5, ultimateFallbackPos.method_10264(), (double)ultimateFallbackPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
            });
            world.method_30771((class_1297)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned Hamster ID {} from NBT data near Player {}.", (Object)hamster.method_5628(), (Object)player.method_5477().getString());
        }
    }

    public static void tryThrowFromShoulder(class_3222 player) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (!config.enableHamsterThrowing) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.throwing_disabled"), true);
            return;
        }
        if (!playerAccessor.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Player {} tried to throw, but has no shoulder hamster.", (Object)player.method_5477().getString());
            return;
        }
        playerAccessor.adorablehamsterpets$dismountShoulderHamster(true);
    }

    public HamsterEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 3;
        this.method_5941(class_7.field_18, 16.0f);
        this.method_5941(class_7.field_14, 16.0f);
        this.method_5941(class_7.field_3, 16.0f);
        this.method_5941(class_7.field_9, 16.0f);
    }

    public int getVariant() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(int variantId) {
        this.field_6011.method_12778(VARIANT, (Object)variantId);
    }

    public boolean method_6113() {
        return this.getHamsterFlag(1);
    }

    public void setSleeping(boolean sleeping) {
        this.setHamsterFlag(1, sleeping);
    }

    public boolean method_24345() {
        return this.getHamsterFlag(2) || this.getHamsterFlag(1) || this.getHamsterFlag(256) || this.getHamsterFlag(2048);
    }

    public boolean isCleaning() {
        return this.getHamsterFlag(8192);
    }

    public boolean isBegging() {
        return this.getHamsterFlag(4);
    }

    public void setBegging(boolean value) {
        this.setHamsterFlag(4, value);
    }

    public boolean method_6479() {
        return this.getHamsterFlag(8);
    }

    public void setInLove(boolean value) {
        this.setHamsterFlag(8, value);
    }

    public boolean isRefusingFood() {
        return this.getHamsterFlag(16);
    }

    public void setRefusingFood(boolean value) {
        this.setHamsterFlag(16, value);
    }

    public boolean isThrown() {
        return this.getHamsterFlag(32);
    }

    public void setThrown(boolean thrown) {
        this.setHamsterFlag(32, thrown);
    }

    public boolean isLeftCheekFull() {
        return this.getHamsterFlag(64);
    }

    public void setLeftCheekFull(boolean full) {
        this.setHamsterFlag(64, full);
    }

    public boolean isRightCheekFull() {
        return this.getHamsterFlag(128);
    }

    public void setRightCheekFull(boolean full) {
        this.setHamsterFlag(128, full);
    }

    public boolean isKnockedOut() {
        return this.getHamsterFlag(256);
    }

    public void setKnockedOut(boolean knocked_out) {
        this.setHamsterFlag(256, knocked_out);
    }

    public String getCurrentDeepSleepAnimationIdFromTracker() {
        return (String)this.field_6011.method_12789(CURRENT_DEEP_SLEEP_ANIM_ID);
    }

    public boolean isAutoEating() {
        return this.isAutoEating;
    }

    public boolean isConsideringAutoEat() {
        return this.getHamsterFlag(1024);
    }

    public DozingPhase getDozingPhase() {
        return DozingPhase.values()[(Integer)this.field_6011.method_12789(DOZING_PHASE)];
    }

    public void setDozingPhase(DozingPhase phase) {
        this.field_6011.method_12778(DOZING_PHASE, (Object)phase.ordinal());
    }

    public void setActiveCustomGoalDebugName(String name) {
        this.field_6011.method_12778(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)name);
    }

    public String getActiveCustomGoalDebugName() {
        String goalName = (String)this.field_6011.method_12789(ACTIVE_CUSTOM_GOAL_NAME_DEBUG);
        return goalName;
    }

    public boolean isSulking() {
        return this.getHamsterFlag(2048);
    }

    public boolean isCelebratingDiamond() {
        return this.getHamsterFlag(4096);
    }

    public void setCelebratingDiamond(boolean celebrating) {
        this.setHamsterFlag(4096, celebrating);
        if (celebrating) {
            this.setBegging(false);
            if (!this.method_37908().method_8608()) {
                this.celebrationParticleTicks = 600;
                this.diamondSparkleSoundDelayTicks = 10;
            }
        } else {
            this.celebrationParticleTicks = 0;
            this.diamondSparkleSoundDelayTicks = 0;
            this.diamondCelebrationSoundTicks = 0;
        }
    }

    public void setSulking(boolean sulking) {
        this.setHamsterFlag(2048, sulking);
        if (sulking) {
            if (!this.method_37908().method_8608()) {
                this.sulkOrchestraHitDelayTicks = 10;
                this.sulkShockedSoundDelayTicks = 44;
                this.sulkFailParticleTicks = 600;
                this.sulkEntityEffectTicks = 600;
            }
        } else {
            this.sulkOrchestraHitDelayTicks = 0;
            this.sulkFailParticleTicks = 0;
            this.sulkEntityEffectTicks = 0;
        }
    }

    public boolean isStealingDiamond() {
        return this.getHamsterFlag(16384);
    }

    public void setStealingDiamond(boolean stealing) {
        this.setHamsterFlag(16384, stealing);
    }

    public int getStealDurationTimer() {
        return (Integer)this.field_6011.method_12789(STEAL_DURATION_TIMER);
    }

    public void setStealDurationTimer(int ticks) {
        this.field_6011.method_12778(STEAL_DURATION_TIMER, (Object)ticks);
    }

    public boolean isTaunting() {
        return this.getHamsterFlag(32768);
    }

    public void setTaunting(boolean taunting) {
        this.setHamsterFlag(32768, taunting);
    }

    public class_1799 getStolenItemStack() {
        return (class_1799)this.field_6011.method_12789(STOLEN_ITEM_STACK);
    }

    public void setStolenItemStack(class_1799 stack) {
        this.field_6011.method_12778(STOLEN_ITEM_STACK, (Object)stack);
    }

    public boolean isCelebratingChase() {
        return this.getHamsterFlag(65536);
    }

    public void setCelebratingChase(boolean celebrating) {
        this.setHamsterFlag(65536, celebrating);
    }

    public boolean hasGreenBeanBuff() {
        return (Long)this.method_5841().method_12789(GREEN_BEAN_BUFF_DURATION) > this.method_37908().method_8510();
    }

    public boolean getZoomiesIsClockwise() {
        return this.zoomiesIsClockwise;
    }

    public double getLastZoomiesAngle() {
        return this.lastZoomiesAngle;
    }

    public void setLastZoomiesAngle(double angle) {
        this.lastZoomiesAngle = angle;
    }

    public int getZoomiesRadiusModifier() {
        return this.zoomiesRadiusModifier;
    }

    public boolean isShoulderPet() {
        return this.getHamsterFlag(131072);
    }

    public void setShoulderPet(boolean isShoulderPet) {
        this.setHamsterFlag(131072, isShoulderPet);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @Override
    public void method_5431() {
        if (!this.method_37908().method_8608()) {
            this.updateCheekTrackers();
        }
    }

    public class_2561 method_5476() {
        if (this.method_16914()) {
            return super.method_5476();
        }
        if (Configs.AHP.useHampterName) {
            return class_2561.method_43471((String)"entity.adorablehamsterpets.hampter");
        }
        return super.method_5476();
    }

    @Override
    public boolean method_5437(int slot, class_1799 stack) {
        if (slot < 0 || slot >= 6) {
            return false;
        }
        return !this.isItemDisallowed(stack);
    }

    public void updateCheekTrackers() {
        class_1309 class_13092;
        boolean leftFull = false;
        for (int i = 0; i < 3; ++i) {
            if (((class_1799)this.items.get(i)).method_7960()) continue;
            leftFull = true;
            break;
        }
        boolean rightFull = false;
        for (int i = 3; i < 6; ++i) {
            if (((class_1799)this.items.get(i)).method_7960()) continue;
            rightFull = true;
            break;
        }
        if (this.isLeftCheekFull() != leftFull) {
            this.setLeftCheekFull(leftFull);
        }
        if (this.isRightCheekFull() != rightFull) {
            this.setRightCheekFull(rightFull);
        }
        if (!this.method_37908().method_8608() && (class_13092 = this.method_35057()) instanceof class_3222) {
            class_3222 serverPlayerOwner = (class_3222)class_13092;
            boolean allSlotsFilled = true;
            for (int i = 0; i < 6; ++i) {
                if (!((class_1799)this.items.get(i)).method_7960()) continue;
                allSlotsFilled = false;
                break;
            }
            if (allSlotsFilled) {
                ((HamsterPouchFilledCriterion)((Object)ModCriteria.HAMSTER_POUCH_FILLED.get())).trigger(serverPlayerOwner, this);
            }
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("HamsterVariant", this.getVariant());
        if (this.method_6181()) {
            nbt.method_10556("Sitting", this.getHamsterFlag(2));
        }
        nbt.method_10556("KnockedOut", this.getHamsterFlag(256));
        nbt.method_10556("CheekPouchUnlocked", this.getHamsterFlag(512));
        nbt.method_10544("ThrowCooldownEnd", this.throwCooldownEndTick);
        nbt.method_10544("GreenBeanBuffDuration", ((Long)this.method_5841().method_12789(GREEN_BEAN_BUFF_DURATION)).longValue());
        nbt.method_10569("AutoEatCooldown", this.autoEatCooldownTicks);
        nbt.method_10569("EjectionCheckCooldown", this.ejectionCheckCooldown);
        nbt.method_10569("PinkPetalType", ((Integer)this.field_6011.method_12789(PINK_PETAL_TYPE)).intValue());
        nbt.method_10569("AnimationPersonalityId", ((Integer)this.field_6011.method_12789(ANIMATION_PERSONALITY_ID)).intValue());
        nbt.method_10569("DozingPhase", this.getDozingPhase().ordinal());
        nbt.method_10582("CurrentDeepSleepAnimId", (String)this.field_6011.method_12789(CURRENT_DEEP_SLEEP_ANIM_ID));
        nbt.method_10569("QuiescentSitTimer", this.quiescentSitDurationTimer);
        nbt.method_10569("DriftingOffTimer", this.driftingOffTimer);
        nbt.method_10569("SettleSleepCooldown", this.settleSleepAnimationCooldown);
        class_7225.class_7874 registries = this.getRegistryLookup();
        class_2487 inventoryWrapperNbt = new class_2487();
        class_1262.method_5426((class_2487)inventoryWrapperNbt, this.items, (class_7225.class_7874)registries);
        nbt.method_10566("Inventory", (class_2520)inventoryWrapperNbt);
        nbt.method_10556("IsPrimedToSeekDiamonds", this.isPrimedToSeekDiamonds);
        nbt.method_10544("FoundOreCooldownEndTick", this.foundOreCooldownEndTick);
        if (this.currentOreTarget != null) {
            nbt.method_10569("OreTargetX", this.currentOreTarget.method_10263());
            nbt.method_10569("OreTargetY", this.currentOreTarget.method_10264());
            nbt.method_10569("OreTargetZ", this.currentOreTarget.method_10260());
        }
        nbt.method_10556("IsSulking", this.getHamsterFlag(2048));
        nbt.method_10556("IsCelebratingDiamond", this.getHamsterFlag(4096));
        if (this.isStealingDiamond()) {
            nbt.method_10556("IsStealingDiamond", true);
            nbt.method_10569("StealDurationTimer", this.getStealDurationTimer());
            if (!this.getStolenItemStack().method_7960()) {
                nbt.method_10566("StolenItemStack", this.getStolenItemStack().method_57358(registries));
            }
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setVariant(nbt.method_10550("HamsterVariant"));
        boolean wasSittingNbt = this.method_6181() && nbt.method_10577("Sitting");
        this.setSitting(wasSittingNbt, true);
        this.setHamsterFlag(256, nbt.method_10577("KnockedOut"));
        this.setHamsterFlag(512, nbt.method_10577("CheekPouchUnlocked"));
        this.setHamsterFlag(2048, nbt.method_10577("IsSulking"));
        this.setHamsterFlag(4096, nbt.method_10577("IsCelebratingDiamond"));
        this.throwCooldownEndTick = nbt.method_10537("ThrowCooldownEnd");
        this.method_5841().method_12778(GREEN_BEAN_BUFF_DURATION, (Object)nbt.method_10537("GreenBeanBuffDuration"));
        this.autoEatCooldownTicks = nbt.method_10550("AutoEatCooldown");
        this.ejectionCheckCooldown = nbt.method_10573("EjectionCheckCooldown", 3) ? nbt.method_10550("EjectionCheckCooldown") : 20;
        this.field_6011.method_12778(PINK_PETAL_TYPE, (Object)nbt.method_10550("PinkPetalType"));
        this.field_6011.method_12778(ANIMATION_PERSONALITY_ID, (Object)nbt.method_10550("AnimationPersonalityId"));
        if (nbt.method_10573("DozingPhase", 3)) {
            int phaseOrdinal = nbt.method_10550("DozingPhase");
            if (phaseOrdinal >= 0 && phaseOrdinal < DozingPhase.values().length) {
                this.setDozingPhase(DozingPhase.values()[phaseOrdinal]);
            } else {
                this.setDozingPhase(DozingPhase.NONE);
            }
        } else {
            this.setDozingPhase(DozingPhase.NONE);
        }
        this.field_6011.method_12778(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)nbt.method_10558("CurrentDeepSleepAnimId"));
        this.quiescentSitDurationTimer = nbt.method_10550("QuiescentSitTimer");
        this.driftingOffTimer = nbt.method_10550("DriftingOffTimer");
        this.settleSleepAnimationCooldown = nbt.method_10550("SettleSleepCooldown");
        this.items.clear();
        class_7225.class_7874 registries = this.getRegistryLookup();
        if (nbt.method_10573("Inventory", 10)) {
            class_1262.method_5429((class_2487)nbt.method_10562("Inventory"), this.items, (class_7225.class_7874)registries);
        }
        this.updateCheekTrackers();
        this.isPrimedToSeekDiamonds = nbt.method_10577("IsPrimedToSeekDiamonds");
        this.foundOreCooldownEndTick = nbt.method_10537("FoundOreCooldownEndTick");
        this.currentOreTarget = nbt.method_10545("OreTargetX") && nbt.method_10545("OreTargetY") && nbt.method_10545("OreTargetZ") ? new class_2338(nbt.method_10550("OreTargetX"), nbt.method_10550("OreTargetY"), nbt.method_10550("OreTargetZ")) : null;
        this.setStealingDiamond(nbt.method_10577("IsStealingDiamond"));
        if (this.isStealingDiamond()) {
            this.setStealDurationTimer(nbt.method_10550("StealDurationTimer"));
            if (nbt.method_10573("StolenItemStack", 10)) {
                class_1799.method_57360((class_7225.class_7874)registries, (class_2520)nbt.method_10580("StolenItemStack")).ifPresent(this::setStolenItemStack);
            }
        } else {
            this.setStealDurationTimer(0);
            this.setStolenItemStack(class_1799.field_8037);
        }
    }

    public HamsterShoulderData saveToShoulderData() {
        this.updateCheekTrackers();
        class_2487 inventoryNbt = new class_2487();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_1262.method_5426((class_2487)inventoryNbt, this.items, (class_7225.class_7874)serverWorld.method_30349());
        }
        class_2487 effectsNbt = new class_2487();
        if (!this.method_6026().isEmpty()) {
            class_2499 effectsList = new class_2499();
            for (class_1293 effectInstance : this.method_6026()) {
                effectsList.add((Object)effectInstance.method_5582());
            }
            effectsNbt.method_10566("active_effects", (class_2520)effectsList);
        }
        Optional<String> nameOptional = Optional.ofNullable(this.method_5797()).map(class_2561::getString);
        HamsterShoulderData.SeekingBehaviorData seekingData = new HamsterShoulderData.SeekingBehaviorData(this.isPrimedToSeekDiamonds, this.foundOreCooldownEndTick, Optional.ofNullable(this.currentOreTarget));
        return new HamsterShoulderData(this.getVariant(), this.method_6032(), inventoryNbt, this.method_5618(), this.throwCooldownEndTick, this.greenBeanBuffEndTick, (Long)this.method_5841().method_12789(GREEN_BEAN_BUFF_DURATION), effectsNbt, this.autoEatCooldownTicks, nameOptional, (Integer)this.field_6011.method_12789(PINK_PETAL_TYPE), (Integer)this.field_6011.method_12789(ANIMATION_PERSONALITY_ID), seekingData, (Integer)this.field_6011.method_12789(HAMSTER_FLAGS));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public void method_5872(double cursorX, double cursorY) {
        if (this.method_6113()) {
            return;
        }
        super.method_5872(cursorX, cursorY);
    }

    public Optional<class_2338> findSafeSpawnPosition(class_2338 initialTarget, class_1937 world, int searchRadius) {
        if (this.isSafeSpawnLocation(initialTarget, world)) {
            return Optional.of(initialTarget);
        }
        for (int i = 1; i <= 3; ++i) {
            class_2338 abovePos = initialTarget.method_10086(i);
            if (!this.isSafeSpawnLocation(abovePos, world)) continue;
            return Optional.of(abovePos);
        }
        for (int r = 1; r <= searchRadius; ++r) {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    class_2338 checkPos;
                    if (Math.abs(i) != r && Math.abs(j) != r || !this.isSafeSpawnLocation(checkPos = initialTarget.method_10069(i, 0, j), world)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    public void method_24346(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean suppressSound) {
        if (!sitting && this.method_6181() && this.getDozingPhase() != DozingPhase.NONE) {
            this.resetSleepSequence("Player commanded hamster to stand up.");
        }
        this.setHamsterFlag(2, sitting);
        this.method_6179(sitting);
        if (sitting) {
            this.cleaningTimer = 0;
        } else {
            this.quiescentSitDurationTimer = 0;
            this.cleaningTimer = 0;
            if (this.getHamsterFlag(8192)) {
                this.setHamsterFlag(8192, false);
            }
        }
    }

    public boolean method_42150(class_1309 entity) {
        class_238 hamsterBox = this.method_5829();
        class_238 attackBox = hamsterBox.method_1009(0.7, 0.0, 0.7);
        boolean intersects = attackBox.method_994(entity.method_5829());
        return intersects;
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        class_8046 ownableFallback;
        class_1297 fallbackOwnerEntity;
        UUID ownerUuid = owner.method_5667();
        AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Hamster: {}, Target: {}, Owner: {}", new Object[]{this.method_5477().getString(), target.method_5477().getString(), owner.method_5477().getString()});
        if (target == this || target == owner) {
            return false;
        }
        if (target instanceof class_1657 && target.method_5667().equals(ownerUuid)) {
            return false;
        }
        if (target instanceof class_1548 || target instanceof class_1531) {
            return false;
        }
        if (target instanceof class_1321) {
            class_1321 tameablePet = (class_1321)target;
            UUID petOwnerUuid = tameablePet.method_6139();
            if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is a TameableEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof class_1496) {
            class_1496 horsePet = (class_1496)target;
            class_1309 horseOwnerEntity = horsePet.method_35057();
            if (horseOwnerEntity != null && horseOwnerEntity.method_5667().equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an AbstractHorseEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof class_8046 && (fallbackOwnerEntity = (ownableFallback = (class_8046)target).method_24921()) != null && fallbackOwnerEntity.method_5667().equals(ownerUuid)) {
            AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an Ownable (fallback) owned by the same player. Preventing attack.");
            return false;
        }
        return true;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1937 world = this.method_37908();
        AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction start. Player: {}, Hand: {}, Item: {}", new Object[]{this.method_5628(), world.method_8510(), player.method_5477().getString(), hand, stack.method_7909()});
        if (this.interactionCooldown > 0) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction cooldown active ({} ticks left). Passing.", new Object[]{this.method_5628(), world.method_8510(), this.interactionCooldown});
            return class_1269.field_5811;
        }
        if (player.method_5715() && stack.method_31574((class_1792)ModItems.HAMSTER_GUIDE_BOOK.get())) {
            if (!world.field_9236) {
                boolean newSetting;
                AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
                boolean currentSetting = currentConfig.enableJadeHamsterDebugInfo;
                currentConfig.enableJadeHamsterDebugInfo = newSetting = !currentSetting;
                currentConfig.save();
                class_5250 message = class_2561.method_43471((String)(newSetting ? "message.adorablehamsterpets.debug_overlay_enabled" : "message.adorablehamsterpets.debug_overlay_disabled")).method_27692(newSetting ? class_124.field_1060 : class_124.field_1061);
                player.method_7353((class_2561)message, true);
                AdorableHamsterPets.LOGGER.info("Player {} toggled Jade Hamster Debug Info via Guide Book to: {} for hamster {}", new Object[]{player.method_5477().getString(), newSetting, this.method_5628()});
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        if (!this.method_6181()) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster not tamed. Checking for taming attempt.", (Object)this.method_5628(), (Object)world.method_8510());
            if (player.method_5715() && ModItemTags.isTamingFood(stack)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Taming attempt detected.", (Object)this.method_5628(), (Object)world.method_8510());
                if (!world.field_9236) {
                    this.tryTame(player, stack);
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not a taming attempt. Calling super.interactMob for untamed.", (Object)this.method_5628(), (Object)world.method_8510());
            return super.method_5992(player, hand);
        }
        if (this.method_6171((class_1309)player)) {
            boolean isPotentialFood;
            boolean isUsingKeybind;
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Player is owner. Processing owner interactions.", (Object)this.method_5628(), (Object)world.method_8510());
            boolean isSneaking = player.method_5715();
            PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
            if (this.getDozingPhase() != DozingPhase.NONE) {
                this.resetSleepSequence("Player attempted to feed hamster.");
            }
            if (this.isStealingDiamond() && this.method_6171((class_1309)player)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Passed 'isStealingDiamond' check.", (Object)this.method_5628());
                if (!world.field_9236) {
                    class_1799 retrievedStack = this.getStolenItemStack().method_7972();
                    player.method_31548().method_7398(this.getStolenItemStack().method_7972());
                    this.setStolenItemStack(class_1799.field_8037);
                    this.setStealDurationTimer(0);
                    this.setStealingDiamond(false);
                    this.setCelebratingChase(true);
                    this.celebrationChaseTicks = 30;
                    this.triggerAnimOnServer("mainController", "anim_hamster_celebrate_chase");
                    world.method_8396(null, this.method_24515(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.field_5974), class_3419.field_15254, 1.0f, this.method_6017());
                    if (!retrievedStack.method_7960()) {
                        class_3414 pounceSound = ModSounds.getDynamicItemSound(retrievedStack);
                        float volume = pounceSound == class_3417.field_20614 ? 0.35f : 1.0f;
                        world.method_8396(null, this.method_24515(), pounceSound, class_3419.field_15254, volume, 1.7f);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Diamond returned to player and goal stopped.", (Object)this.method_5628());
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            if (this.isKnockedOut()) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster is knocked out. Waking up.", (Object)this.method_5628(), (Object)world.method_8510());
                if (!world.method_8608()) {
                    class_3414 wakeUpSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_WAKE_UP_SOUNDS, this.field_5974);
                    if (wakeUpSound != null) {
                        world.method_8396(null, this.method_24515(), wakeUpSound, class_3419.field_15254, 1.0f, 1.0f);
                    }
                    this.setKnockedOut(false);
                    this.setSitting(false, true);
                    this.triggerAnimOnServer("mainController", "wakeup");
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            if (this.isCelebratingDiamond()) {
                if (!world.method_8608()) {
                    this.setCelebratingDiamond(false);
                    this.setSitting(false, true);
                    class_3414 affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.field_5974);
                    if (affectionSound != null) {
                        world.method_8396(null, this.method_24515(), affectionSound, class_3419.field_15254, 1.0f, this.method_6017());
                    } else {
                        world.method_8396(null, this.method_24515(), class_3417.field_15197, class_3419.field_15254, 0.5f, 1.5f);
                    }
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            if (this.isSulking()) {
                if (!world.method_8608()) {
                    this.setSulking(false);
                    this.setSitting(false, true);
                    class_3414 affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.field_5974);
                    if (affectionSound != null) {
                        world.method_8396(null, this.method_24515(), affectionSound, class_3419.field_15254, 1.0f, this.method_6017());
                    } else {
                        world.method_8396(null, this.method_24515(), class_3417.field_14685, class_3419.field_15254, 0.5f, 1.5f);
                    }
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            if (stack.method_31574(class_1802.field_42696) && !player.method_5715()) {
                if (!world.field_9236) {
                    int currentPetalType = (Integer)this.field_6011.method_12789(PINK_PETAL_TYPE);
                    int nextPetalType = currentPetalType % 3 + 1;
                    this.field_6011.method_12778(PINK_PETAL_TYPE, (Object)nextPetalType);
                    world.method_8396(null, this.method_24515(), class_3417.field_42591, class_3419.field_15248, 0.7f, 1.0f + this.field_5974.method_43057() * 0.2f);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        serverWorld.method_14199((class_2394)class_2398.field_28802, this.method_23317(), this.method_23318() + (double)this.method_17682() * 0.75, this.method_23321(), 7, (double)(this.method_17681() / 2.0f), (double)(this.method_17682() / 2.0f), (double)(this.method_17681() / 2.0f), 0.0);
                    }
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Cycled/Applied pink petal to type {}.", (Object)this.method_5628(), (Object)nextPetalType);
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        ((AppliedPinkPetalCriterion)((Object)ModCriteria.APPLIED_PINK_PETAL.get())).trigger(serverPlayer, this);
                    }
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            if (stack.method_31574(class_1802.field_8868) && !player.method_5715() && (Integer)this.field_6011.method_12789(PINK_PETAL_TYPE) > 0) {
                if (!world.field_9236) {
                    this.field_6011.method_12778(PINK_PETAL_TYPE, (Object)0);
                    world.method_8396(null, this.method_24515(), class_3417.field_14975, class_3419.field_15248, 0.9f, 1.0f + this.field_5974.method_43057() * 0.1f);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        serverWorld.method_14199((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_1802.field_42696)), this.method_23317(), this.method_23318() + (double)this.method_17682() * 0.5, this.method_23321(), 5, (double)(this.method_17681() / 2.0f), (double)(this.method_17682() / 2.0f), (double)(this.method_17681() / 2.0f), 0.05);
                    }
                    class_1264.method_5449((class_1937)world, (double)this.method_23317(), (double)(this.method_23318() + 0.5), (double)this.method_23321(), (class_1799)new class_1799((class_1935)class_1802.field_42696, 1));
                    if (!player.method_31549().field_7477) {
                        stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Removed pink petals with shears.", (Object)this.method_5628());
                }
                return class_1269.method_29236((boolean)world.method_8608());
            }
            boolean isUsingItem = ModItemTags.isShoulderMountFood(stack);
            boolean bl = isUsingKeybind = !world.method_8608() && Configs.AHP.enableShoulderMountKeybind && ModKeyBindings.FORCE_MOUNT_HAMSTER_KEY.method_1434();
            if (isUsingItem || isUsingKeybind) {
                if (!world.field_9236) {
                    ShoulderLocation availableSlot = null;
                    if (playerAccessor.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).method_33133()) {
                        availableSlot = ShoulderLocation.RIGHT_SHOULDER;
                    } else if (playerAccessor.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).method_33133()) {
                        availableSlot = ShoulderLocation.LEFT_SHOULDER;
                    } else if (playerAccessor.getShoulderHamster(ShoulderLocation.HEAD).method_33133()) {
                        availableSlot = ShoulderLocation.HEAD;
                    }
                    if (availableSlot != null) {
                        AdorableHamsterPets.LOGGER.debug("[AHP DEBUG] MOUNTING: Found available slot '{}' for Hamster ID {}.", (Object)availableSlot, (Object)this.method_5628());
                        HamsterShoulderData data = this.saveToShoulderData();
                        playerAccessor.setShoulderHamster(availableSlot, data.toNbt());
                        playerAccessor.adorablehamsterpets$getMountOrderQueue().addLast(availableSlot);
                        class_2338 hamsterPosForMountSound = this.method_24515();
                        this.method_31472();
                        if (player instanceof class_3222) {
                            class_3222 serverPlayer = (class_3222)player;
                            ((HamsterOnShoulderCriterion)((Object)ModCriteria.HAMSTER_ON_SHOULDER.get())).trigger(serverPlayer);
                        }
                        player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.shoulder_mount_success"), true);
                        class_3414 mountSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SHOULDER_MOUNT_SOUNDS, this.field_5974);
                        if (mountSound != null) {
                            world.method_8396(null, player.method_24515(), mountSound, class_3419.field_15248, 1.0f, this.method_6017());
                        }
                        if (isUsingItem) {
                            class_3414 mountLureSound = ModSounds.getDynamicItemSound(stack);
                            world.method_8396(null, hamsterPosForMountSound, mountLureSound, class_3419.field_15248, 1.0f, 1.0f);
                            ((class_3218)world).method_14199((class_2394)new class_2392(class_2398.field_11218, stack), (double)hamsterPosForMountSound.method_10263() + 0.5, (double)hamsterPosForMountSound.method_10264() + 0.5, (double)hamsterPosForMountSound.method_10260() + 0.5, 8, 0.25, 0.25, 0.25, 0.05);
                            if (!player.method_31549().field_7477 && Configs.AHP.consumeShoulderMountItem) {
                                stack.method_7934(1);
                            }
                        }
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.shoulder_occupied"), true);
                    }
                } else {
                    player.method_6104(hand);
                }
                return class_1269.field_21466;
            }
            if (!world.method_8608() && isSneaking) {
                if (this.getHamsterFlag(512) || !AdorableHamsterPets.CONFIG.requireFoodMixToUnlockCheeks) {
                    MenuRegistry.openExtendedMenu((class_3222)((class_3222)player), (ExtendedMenuProvider)new HamsterScreenHandlerFactory(this));
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.cheek_pouch_locked").method_27692(class_124.field_1068), true);
                }
                return class_1269.field_21466;
            }
            boolean bl2 = isPotentialFood = ModItemTags.isStandardFood(stack) || ModItemTags.isBuffFood(stack) || ModItemTags.isPouchUnlockFood(stack);
            if (!world.method_8608() && !isSneaking && isPotentialFood) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Owner not sneaking, holding potential food. Checking refusal.", (Object)this.method_5628(), (Object)world.method_8510());
                if (this.checkRepeatFoodRefusal(stack, player)) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Food refused. Consuming interaction.", (Object)this.method_5628(), (Object)world.method_8510());
                    return class_1269.field_21466;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Attempting feeding via tryFeedingAsTamed.", (Object)this.method_5628(), (Object)world.method_8510());
                boolean feedingOccurred = this.tryFeedingAsTamed(player, stack);
                if (feedingOccurred) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned true. Setting last food, decrementing stack.", (Object)this.method_5628(), (Object)world.method_8510());
                    this.lastFoodItem = stack.method_7972();
                    if (!player.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    return class_1269.field_21466;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned false. Passing to vanilla/sitting.", (Object)this.method_5628(), (Object)world.method_8510());
            }
            if (!(isSneaking || isPotentialFood || ModItemTags.isShoulderMountFood(stack) || stack.method_31574(class_1802.field_42696))) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not sneaking or holding handled food/petals. Calling super.interactMob.", (Object)this.method_5628(), (Object)world.method_8510());
                class_1269 vanillaResult = super.method_5992(player, hand);
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] super.interactMob returned: {}", new Object[]{this.method_5628(), world.method_8510(), vanillaResult});
                if (vanillaResult.method_23665()) {
                    return vanillaResult;
                }
            }
            if (!world.method_8608() && !isSneaking) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Fallback: Toggling sitting state.", (Object)this.method_5628(), (Object)world.method_8510());
                this.method_24346(!this.method_24345());
                this.field_6282 = false;
                this.field_6189.method_6340();
                this.method_5980(null);
                return class_1269.field_33562;
            }
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Reached end of owner logic. Returning client-side success/pass.", (Object)this.method_5628(), (Object)world.method_8510());
            return class_1269.method_29236((boolean)world.method_8608());
        }
        AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Player is not owner. Calling super.interactMob.", (Object)this.method_5628(), (Object)world.method_8510());
        return super.method_5992(player, hand);
    }

    public void method_6173(boolean tamed, boolean updateAttributes) {
        super.method_6173(tamed, updateAttributes);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(((Double)Configs.AHP.tamedMaxHealth.get()).doubleValue());
            this.method_6033(this.method_6063());
            this.method_5996(class_5134.field_23721).method_6192(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
        } else {
            this.method_5996(class_5134.field_23716).method_6192(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.method_5996(class_5134.field_23721).method_6192(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
        }
    }

    public boolean isInCustomLove() {
        return this.customLoveTimer > 0;
    }

    public void setCustomInLove(class_1657 player) {
        this.customLoveTimer = 600;
        if (!this.method_37908().field_9236) {
            this.method_37908().method_8421((class_1297)this, (byte)18);
        }
    }

    public void method_7217(boolean baby) {
        this.method_5614(baby ? -24000 : 0);
    }

    public void method_6179(boolean inSittingPose) {
        super.method_6179(inSittingPose);
        if (this.getHamsterFlag(2) != inSittingPose) {
            this.setHamsterFlag(2, inSittingPose);
        }
        if (!inSittingPose) {
            if (this.method_6113()) {
                this.setSleeping(false);
            }
            if (this.isKnockedOut()) {
                this.setKnockedOut(false);
            }
        }
    }

    public HamsterVariant getVariantEnum() {
        return HamsterVariant.byId(this.getVariant());
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 mate) {
        HamsterVariant babyFinalVariant;
        boolean motherHasOverlay;
        HamsterEntity baby = (HamsterEntity)((class_1299)ModEntities.HAMSTER.get()).method_5883((class_1937)world);
        if (baby == null) {
            return null;
        }
        if (!(mate instanceof HamsterEntity)) {
            int randomVariantId = this.field_5974.method_43048(HamsterVariant.values().length);
            baby.setVariant(randomVariantId);
            baby.method_7217(true);
            AdorableHamsterPets.LOGGER.warn("Hamster breeding attempted with non-hamster mate. Assigning random variant to baby.");
            return baby;
        }
        HamsterEntity mother = (HamsterEntity)mate;
        HamsterEntity father = this;
        HamsterVariant parentProvidingBaseColor = this.field_5974.method_43056() ? father.getVariantEnum() : mother.getVariantEnum();
        HamsterVariant babyBaseColorEnum = parentProvidingBaseColor.getBaseVariant();
        @Nullable String fatherOverlayName = father.getVariantEnum().getOverlayTextureName();
        @Nullable String motherOverlayName = mother.getVariantEnum().getOverlayTextureName();
        List<HamsterVariant> allVariantsForBabyBase = HamsterVariant.getVariantsForBase(babyBaseColorEnum);
        ArrayList<@Nullable String> eligibleOverlayNames = new ArrayList<String>();
        for (HamsterVariant variant : allVariantsForBabyBase) {
            boolean matchesMother;
            @Nullable String candidateOverlay = variant.getOverlayTextureName();
            boolean matchesFather = fatherOverlayName != null && fatherOverlayName.equals(candidateOverlay);
            boolean bl = matchesMother = motherOverlayName != null && motherOverlayName.equals(candidateOverlay);
            if (matchesFather || matchesMother) continue;
            eligibleOverlayNames.add(candidateOverlay);
        }
        ArrayList<@Nullable String> finalSelectableOverlayNames = new ArrayList<String>();
        boolean fatherHasOverlay = fatherOverlayName != null;
        boolean bl = motherHasOverlay = motherOverlayName != null;
        if (fatherHasOverlay && motherHasOverlay) {
            for (String overlayName : eligibleOverlayNames) {
                if (overlayName == null) continue;
                finalSelectableOverlayNames.add(overlayName);
            }
            if (finalSelectableOverlayNames.isEmpty() && babyBaseColorEnum != HamsterVariant.WHITE) {
                for (HamsterVariant variant : allVariantsForBabyBase) {
                    if (variant.getOverlayTextureName() == null) continue;
                    finalSelectableOverlayNames.add(variant.getOverlayTextureName());
                }
            }
        } else {
            finalSelectableOverlayNames.addAll(eligibleOverlayNames);
        }
        if (!finalSelectableOverlayNames.isEmpty()) {
            @Nullable String chosenOverlayName = (String)finalSelectableOverlayNames.get(this.field_5974.method_43048(finalSelectableOverlayNames.size()));
            babyFinalVariant = HamsterVariant.getVariantByBaseAndOverlay(babyBaseColorEnum, chosenOverlayName);
        } else {
            babyFinalVariant = babyBaseColorEnum;
        }
        baby.setVariant(babyFinalVariant.getId());
        UUID ownerUUID = father.method_6139();
        if (ownerUUID != null) {
            baby.method_6174(ownerUUID);
            baby.method_6173(true, true);
        }
        baby.method_7217(true);
        return baby;
    }

    public boolean method_6481(class_1799 stack) {
        return ModItemTags.isStandardFood(stack);
    }

    public void method_5773() {
        class_1937 world;
        int chanceDenominator;
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        if (this.suffocationGracePeriod > 0) {
            --this.suffocationGracePeriod;
        }
        if (this.cleaningCooldownTimer > 0) {
            --this.cleaningCooldownTimer;
        }
        if (this.cleaningTimer > 0) {
            --this.cleaningTimer;
            if (this.cleaningTimer == 0) {
                if (!this.method_37908().field_9236) {
                    this.setHamsterFlag(8192, false);
                }
                this.cleaningCooldownTimer = 200;
            }
        }
        if (this.wakingUpTicks > 0) {
            --this.wakingUpTicks;
        }
        if (this.autoEatCooldownTicks > 0) {
            --this.autoEatCooldownTicks;
        }
        if (this.autoEatProgressTicks > 0) {
            --this.autoEatProgressTicks;
        }
        if (this.ejectionCheckCooldown > 0) {
            --this.ejectionCheckCooldown;
        }
        if (this.preAutoEatDelayTicks > 0) {
            --this.preAutoEatDelayTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.diamondCelebrationSoundTicks > 0) {
            --this.diamondCelebrationSoundTicks;
        }
        if (this.sulkOrchestraHitDelayTicks > 0) {
            --this.sulkOrchestraHitDelayTicks;
        }
        if (this.sulkFailParticleTicks > 0) {
            --this.sulkFailParticleTicks;
        }
        if (this.sulkEntityEffectTicks > 0) {
            --this.sulkEntityEffectTicks;
        }
        if (this.sulkShockedSoundDelayTicks > 0) {
            --this.sulkShockedSoundDelayTicks;
        }
        if (this.diamondSparkleSoundDelayTicks > 0) {
            --this.diamondSparkleSoundDelayTicks;
        }
        if (this.isKnockedOut() && this.getHamsterFlag(8192)) {
            this.setHamsterFlag(8192, false);
            this.cleaningTimer = 0;
        }
        DozingPhase currentPhase = this.getDozingPhase();
        if (!this.method_37908().method_8608() && this.method_6181() && this.method_24345() && !this.getHamsterFlag(8192) && this.cleaningCooldownTimer <= 0 && (currentPhase == DozingPhase.NONE || currentPhase == DozingPhase.QUIESCENT_SITTING) && (chanceDenominator = ((Integer)Configs.AHP.cleaningChanceDenominator.get()).intValue()) > 0 && this.field_5974.method_43048(chanceDenominator) == 0) {
            this.cleaningTimer = this.field_5974.method_39332(30, 60);
            this.setHamsterFlag(8192, true);
        }
        if (this.isCelebratingChase()) {
            if (this.celebrationChaseTicks > 0) {
                if (this.method_35057() != null) {
                    this.method_5988().method_6226((class_1297)this.method_35057(), 25.0f, 25.0f);
                }
                --this.celebrationChaseTicks;
            } else {
                this.setCelebratingChase(false);
            }
        }
        if (this.isThrown()) {
            ++this.throwTicks;
            class_243 currentPos = this.method_19538();
            class_243 currentVel = this.method_18798();
            class_243 nextPos = currentPos.method_1019(currentVel);
            class_1937 world2 = this.method_37908();
            class_3965 blockHit = world2.method_17742(new class_3959(currentPos, nextPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            boolean stopped = false;
            if (blockHit.method_17783() == class_239.class_240.field_1332) {
                class_3965 blockHitResult = blockHit;
                class_2338 adjacentPos = blockHitResult.method_17777().method_10093(blockHitResult.method_17780());
                this.method_5814((double)adjacentPos.method_10263() + 0.5, adjacentPos.method_10264(), (double)adjacentPos.method_10260() + 0.5);
                this.method_18799(currentVel.method_18805(0.6, 0.0, 0.6));
                this.setThrown(false);
                this.method_5783(class_3417.field_15018, 1.0f, 1.2f);
                this.setKnockedOut(true);
                this.method_6179(true);
                if (!world2.method_8608()) {
                    this.triggerAnimOnServer("mainController", "crash");
                }
                stopped = true;
            } else {
                class_3966 entityHit = class_1675.method_18077((class_1937)world2, (class_1297)this, (class_243)currentPos, (class_243)nextPos, (class_238)this.method_5829().method_18804(currentVel).method_1014(1.0), this::canHitEntity);
                if (entityHit != null && entityHit.method_17782() != null) {
                    class_1297 hitEntity = entityHit.method_17782();
                    class_2338 impactPos = hitEntity.method_24515();
                    boolean playEffects = false;
                    if (hitEntity instanceof class_1531) {
                        playEffects = true;
                    } else if (hitEntity instanceof class_1309) {
                        float damageAmount;
                        class_1309 livingHit = (class_1309)hitEntity;
                        class_1282 damageSource = this.method_48923().method_48812((class_1309)this);
                        boolean damaged = livingHit.method_5643(damageSource, damageAmount = ((Double)Configs.AHP.hamsterThrowDamage.get()).floatValue());
                        if (damaged) {
                            livingHit.method_6092(new class_1293(class_1294.field_5916, 20, 0, false, false, false));
                            playEffects = true;
                        }
                    } else {
                        playEffects = true;
                    }
                    if (playEffects) {
                        world2.method_60511(null, this.method_23317(), this.method_23318(), this.method_23321(), ModSounds.HAMSTER_IMPACT, class_3419.field_15254, 1.0f, 1.0f);
                        if (!world2.method_8608()) {
                            ((class_3218)world2).method_14199((class_2394)class_2398.field_11203, this.method_23317(), this.method_23318() + (double)this.method_17682() / 2.0, this.method_23321(), 50, 0.4, 0.4, 0.4, 0.1);
                        }
                    }
                    Optional<class_2338> safePosOpt = this.findSafeSpawnPosition(impactPos, world2, 2);
                    safePosOpt.ifPresentOrElse(safePos -> this.method_5814((double)safePos.method_10263() + 0.5, safePos.method_10264(), (double)safePos.method_10260() + 0.5), () -> {
                        AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Could not find safe landing spot after hitting entity. Using entity's position {} as fallback.", (Object)impactPos);
                        this.method_5814((double)impactPos.method_10263() + 0.5, impactPos.method_10264(), (double)impactPos.method_10260() + 0.5);
                    });
                    this.method_18799(currentVel.method_18805(0.1, 0.1, 0.1));
                    this.setThrown(false);
                    this.setKnockedOut(true);
                    this.method_6179(true);
                    if (!world2.method_8608()) {
                        this.triggerAnimOnServer("mainController", "crash");
                    }
                    stopped = true;
                }
            }
            if (this.isThrown() && !stopped) {
                if (!this.method_5740()) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.05, 0.0));
                }
                class_243 currentVelocity = this.method_18798();
                if (Double.isNaN(currentVelocity.field_1352) || Double.isNaN(currentVelocity.field_1351) || Double.isNaN(currentVelocity.field_1350)) {
                    this.method_18799(class_243.field_1353);
                    this.setThrown(false);
                    AdorableHamsterPets.LOGGER.warn("Hamster velocity became NaN, resetting and stopping throw.");
                } else {
                    int particleDelay;
                    this.method_5814(this.method_23317() + currentVelocity.field_1352, this.method_23318() + currentVelocity.field_1351, this.method_23321() + currentVelocity.field_1350);
                    this.field_6007 = true;
                    int n = particleDelay = this.hasGreenBeanBuff() ? 3 : 5;
                    if (!world2.method_8608() && this.throwTicks > particleDelay) {
                        double offsetMultiplier = 1.5;
                        double spawnX = this.field_6014 - currentVelocity.field_1352 * offsetMultiplier;
                        double spawnY = this.field_6036 + (double)this.method_17682() / 2.0 - currentVelocity.field_1351 * offsetMultiplier;
                        double spawnZ = this.field_5969 - currentVelocity.field_1350 * offsetMultiplier;
                        ((class_3218)world2).method_14199((class_2394)class_2398.field_47494, spawnX, spawnY, spawnZ, 1, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            } else if (this.throwTicks != 0) {
                this.throwTicks = 0;
            }
        }
        if (!this.method_37908().method_8608() && this.method_6181() && !this.isKnockedOut()) {
            boolean canInitiateDrowsiness = this.checkConditionsForInitiatingDrowsiness();
            boolean canSustainSlumber = this.checkConditionsForSustainingSlumber();
            switch (currentPhase.ordinal()) {
                case 0: {
                    int durationTicks;
                    if (!this.method_24345() || !canInitiateDrowsiness || this.quiescentSitDurationTimer != 0) break;
                    this.setDozingPhase(DozingPhase.QUIESCENT_SITTING);
                    int minSeconds = (Integer)Configs.AHP.tamedQuiescentSitMinSeconds.get();
                    int maxSeconds = (Integer)Configs.AHP.tamedQuiescentSitMaxSeconds.get();
                    if (minSeconds > maxSeconds) {
                        AdorableHamsterPets.LOGGER.info("Config issue: tamedQuiescentSitMinSeconds ({}) > tamedQuiescentSitMaxSeconds ({}). Swapping.", (Object)minSeconds, (Object)maxSeconds);
                        int temp = minSeconds;
                        minSeconds = maxSeconds;
                        maxSeconds = temp;
                    }
                    if (maxSeconds < minSeconds) {
                        maxSeconds = minSeconds;
                    }
                    this.quiescentSitDurationTimer = durationTicks = this.field_5974.method_39332(minSeconds * 20, maxSeconds * 20 + 1);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering QUIESCENT_SITTING for {} ticks.", (Object)this.method_5628(), (Object)durationTicks);
                    break;
                }
                case 1: {
                    if (!this.method_24345() || !canInitiateDrowsiness) {
                        this.resetSleepSequence("Quiescent sitting interrupted: no longer sitting or conditions unfavorable.");
                        break;
                    }
                    if (this.quiescentSitDurationTimer > 0) {
                        --this.quiescentSitDurationTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DRIFTING_OFF);
                    this.driftingOffTimer = 1800;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DRIFTING_OFF for {} ticks.", (Object)this.method_5628(), (Object)this.driftingOffTimer);
                    break;
                }
                case 2: {
                    String settleAnimId;
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Drifting off interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.driftingOffTimer > 0) {
                        --this.driftingOffTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.SETTLING_INTO_SLUMBER);
                    int choice = this.field_5974.method_43048(3);
                    String deepSleepAnimIdForTracker = switch (choice) {
                        case 0 -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep1";
                            yield "anim_hamster_sleep_pose1";
                        }
                        case 1 -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep2";
                            yield "anim_hamster_sleep_pose2";
                        }
                        default -> {
                            settleAnimId = "anim_hamster_sit_settle_sleep3";
                            yield "anim_hamster_sleep_pose3";
                        }
                    };
                    this.field_6011.method_12778(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)deepSleepAnimIdForTracker);
                    this.triggerAnimOnServer("mainController", settleAnimId);
                    this.settleSleepAnimationCooldown = 20;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering SETTLING_INTO_SLUMBER, triggering {}, target deep sleep anim ID: {}.", new Object[]{this.method_5628(), settleAnimId, deepSleepAnimIdForTracker});
                    break;
                }
                case 3: {
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Settling into slumber interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.settleSleepAnimationCooldown > 0) {
                        --this.settleSleepAnimationCooldown;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DEEP_SLEEP);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DEEP_SLEEP, playing {}.", (Object)this.method_5628(), this.field_6011.method_12789(CURRENT_DEEP_SLEEP_ANIM_ID));
                    break;
                }
                case 4: {
                    if (canSustainSlumber) break;
                    this.resetSleepSequence("Deep sleep interrupted: conditions for slumber no longer met.");
                }
            }
        }
        super.method_5773();
        if (!this.method_37908().method_8608() && this.isSulking() && !this.method_24828() && this.method_18798().field_1351 < 0.0) {
            this.method_18799(this.method_18798().method_1031(0.0, -1.0, 0.0));
            this.field_6007 = true;
        }
        if (!(world = this.method_37908()).method_8608()) {
            class_2338 particlePos;
            if (this.suffocationGracePeriod > 0 && this.method_5757()) {
                for (int i = 1; i <= 5; ++i) {
                    class_2338 checkPos = this.method_24515().method_10086(i);
                    if (!this.isSafeSpawnLocation(checkPos, world)) continue;
                    this.method_6082((double)checkPos.method_10263() + 0.5, checkPos.method_10264(), (double)checkPos.method_10260() + 0.5, false);
                    AdorableHamsterPets.LOGGER.debug("[HamsterSelfRescue] Hamster {} teleported from {} to safe location {}.", new Object[]{this.method_5628(), this.method_24515().method_10087(i), checkPos});
                    this.suffocationGracePeriod = 0;
                    break;
                }
            }
            if (this.ejectionCheckCooldown <= 0) {
                this.ejectionCheckCooldown = 100;
                boolean ejectedItem = false;
                for (int i = 0; i < this.items.size(); ++i) {
                    class_1799 stack = (class_1799)this.items.get(i);
                    if (stack.method_7960() || !this.isItemDisallowed(stack)) continue;
                    AdorableHamsterPets.LOGGER.warn("[HamsterTick {}] Ejecting disallowed item {} from slot {}.", new Object[]{this.method_5628(), stack.method_7909(), i});
                    class_1264.method_5449((class_1937)world, (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)stack.method_7972());
                    this.items.set(i, (Object)class_1799.field_8037);
                    this.method_5431();
                    ejectedItem = true;
                    break;
                }
            }
            if (this.method_6181() && this.method_6032() < this.method_6063() && !this.isAutoEating() && !this.isConsideringAutoEat() && this.autoEatCooldownTicks == 0 && !this.isThrown() && !this.isKnockedOut()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    class_1799 stack = (class_1799)this.items.get(i);
                    if (stack.method_7960() || !ModItemTags.isAutoHealFood(stack)) continue;
                    this.setHamsterFlag(1024, true);
                    this.preAutoEatDelayTicks = 40;
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Eligible to auto-eat. Starting 2s pre-eat delay.", (Object)this.method_5628());
                    break;
                }
            }
            if (this.isConsideringAutoEat() && this.preAutoEatDelayTicks == 0) {
                this.setHamsterFlag(1024, false);
                boolean foodStillAvailable = false;
                class_1799 foodToEat = class_1799.field_8037;
                int foodSlot = -1;
                for (int i = 0; i < this.items.size(); ++i) {
                    class_1799 stack = (class_1799)this.items.get(i);
                    if (stack.method_7960() || !ModItemTags.isAutoHealFood(stack)) continue;
                    foodStillAvailable = true;
                    foodToEat = stack;
                    foodSlot = i;
                    break;
                }
                if (foodStillAvailable) {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished. Starting auto-eat on {} from slot {}", new Object[]{this.method_5628(), foodToEat.method_7909(), foodSlot});
                    this.isAutoEating = true;
                    this.autoEatProgressTicks = 60;
                    this.method_5783(class_3417.field_20614, 0.7f, 1.3f);
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        serverWorld.method_14199((class_2394)new class_2392(class_2398.field_11218, foodToEat.method_7971(1)), this.method_23317() + this.field_5974.method_43059() * 0.1, this.method_23318() + (double)this.method_17682() / 2.0 + this.field_5974.method_43059() * 0.1, this.method_23321() + this.field_5974.method_43059() * 0.1, 5, 0.1, 0.1, 0.1, 0.02);
                    }
                    if (foodToEat.method_7960()) {
                        this.items.set(foodSlot, (Object)class_1799.field_8037);
                    }
                    this.updateCheekTrackers();
                } else {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished, but food no longer available.", (Object)this.method_5628());
                }
            }
            if (this.isAutoEating() && this.autoEatProgressTicks == 0) {
                this.method_6025(((Float)Configs.AHP.hamsterFoodMixHealing.get()).floatValue());
                this.autoEatCooldownTicks = 60;
                this.isAutoEating = false;
                AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Auto-eat finished. Healed. Cooldown set to 60.", (Object)this.method_5628());
                class_1309 class_13092 = this.method_35057();
                if (class_13092 instanceof class_3222) {
                    class_3222 serverPlayerOwner = (class_3222)class_13092;
                    ((HamsterAutoFedCriterion)((Object)ModCriteria.HAMSTER_AUTO_FED.get())).trigger(serverPlayerOwner, this);
                }
            }
            if (!this.method_37908().method_8608() && this.isCelebratingDiamond()) {
                class_3414 sparkleSound;
                if (this.diamondSparkleSoundDelayTicks == 1 && (sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.field_5974)) != null) {
                    if (this.currentOreTarget != null) {
                        this.method_37908().method_8396(null, this.currentOreTarget, sparkleSound, class_3419.field_15254, 1.0f, 1.0f);
                    } else {
                        this.method_37908().method_8396(null, this.method_24515(), sparkleSound, class_3419.field_15254, 1.0f, 1.0f);
                    }
                }
                if (this.celebrationParticleTicks > 0) {
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_50247, this.method_23317(), this.method_23318() + 1.5, this.method_23321(), 4, 0.08, 0.15, 0.08, 0.01);
                    if (this.currentOreTarget != null && this.field_5974.method_43048(4) == 0) {
                        particlePos = this.currentOreTarget.method_10084();
                        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11248, (double)particlePos.method_10263() + 0.5, (double)particlePos.method_10264() + 0.5, (double)particlePos.method_10260() + 0.5, 1, 0.2, 0.35, 0.2, 0.003);
                    }
                }
                if (this.diamondCelebrationSoundTicks <= 0) {
                    class_3414 celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.field_5974);
                    if (celebrationSound != null) {
                        this.method_37908().method_8396(null, this.method_24515(), celebrationSound, class_3419.field_15254, 0.8f, this.method_6017());
                    }
                    this.diamondCelebrationSoundTicks = 30;
                }
            }
            if (this.isSulking()) {
                if (this.sulkOrchestraHitDelayTicks == 1) {
                    this.method_37908().method_8396(null, this.method_24515(), (class_3414)ModSounds.ALARM_ORCHESTRA_HIT.get(), class_3419.field_15254, 1.0f, 1.0f);
                }
                if (this.sulkShockedSoundDelayTicks == 1) {
                    this.method_37908().method_8396(null, this.method_24515(), (class_3414)ModSounds.HAMSTER_SHOCKED.get(), class_3419.field_15254, 1.0f, 1.0f);
                }
                if (this.sulkFailParticleTicks > 0 && this.currentOreTarget != null && this.field_5974.method_43048(3) == 0) {
                    particlePos = this.currentOreTarget.method_10084();
                    ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11251, (double)particlePos.method_10263() + 0.5, (double)particlePos.method_10264() + 0.5, (double)particlePos.method_10260() + 0.5, 2, 0.3, 0.3, 0.3, 0.005);
                }
                if (this.sulkEntityEffectTicks > 0 && this.field_5974.method_43048(5) == 0) {
                    class_9381 darkGrayEffect = class_9381.method_58255((class_2396)class_2398.field_11226, (float)0.3f, (float)0.3f, (float)0.3f);
                    ((class_3218)this.method_37908()).method_14199((class_2394)darkGrayEffect, this.method_23322(0.3), this.method_23319(), this.method_23325(0.3), 1, 0.01, 0.05, 0.01, 0.005);
                }
            }
        }
        if (world.field_9236 && this.hasGreenBeanBuff() && this.method_18798().method_37268() > 1.0E-6) {
            double backwardsSpeed = 1.7;
            double scatterStrength = 0.025;
            double downwardVelocity = 0.17;
            double positionOffsetMultiplier = 1.4;
            if (this.field_5974.method_43048(2) == 0) {
                for (int i = 0; i < 3; ++i) {
                    class_243 currentVelocity = this.method_18798();
                    double baseX = this.field_6014 - currentVelocity.field_1352 * 1.4;
                    double baseY = this.field_6036 + (double)this.method_17682() / 2.0 - currentVelocity.field_1351 * 1.4;
                    double baseZ = this.field_5969 - currentVelocity.field_1350 * 1.4;
                    double spawnX = baseX + (this.field_5974.method_43058() - 0.5) * ((double)this.method_17681() * 0.8);
                    double spawnY = baseY + (this.field_5974.method_43058() - 0.5) * ((double)this.method_17682() * 0.05);
                    double spawnZ = baseZ + (this.field_5974.method_43058() - 0.5) * ((double)this.method_17681() * 0.8);
                    class_243 hamsterMovementVec = this.method_18798();
                    class_243 backwardsBaseVel = hamsterMovementVec.method_1021(-1.7);
                    double finalVelX = backwardsBaseVel.field_1352 + this.field_5974.method_43059() * 0.025;
                    double finalVelY = backwardsBaseVel.field_1351 + this.field_5974.method_43059() * 0.025 - 0.17;
                    double finalVelZ = backwardsBaseVel.field_1350 + this.field_5974.method_43059() * 0.025;
                    world.method_8406((class_2394)class_2398.field_46911, spawnX, spawnY, spawnZ, finalVelX, finalVelY, finalVelZ);
                }
            }
        }
        if (this.isTaunting() && this.field_5974.method_43048(7) == 0) {
            for (int i = 0; i < 2; ++i) {
                world.method_8406((class_2394)class_2398.field_11213, this.method_23322(0.6), this.method_23319(), this.method_23325(0.6), (this.field_5974.method_43058() - 0.5) * 0.5, (this.field_5974.method_43058() - 0.5) * 0.5, (this.field_5974.method_43058() - 0.5) * 0.5);
            }
        }
        if (this.isRefusingFood() && this.refuseTimer > 0 && --this.refuseTimer <= 0) {
            this.setRefusingFood(false);
        }
        if (this.tamingCooldown > 0) {
            --this.tamingCooldown;
        }
        if (this.customLoveTimer > 0) {
            --this.customLoveTimer;
        }
        if (this.customLoveTimer <= 0 && this.method_6479()) {
            this.setInLove(false);
        }
    }

    public boolean method_6034() {
        return super.method_6034() && !this.isThrown();
    }

    public boolean method_5810() {
        return super.method_5810() && !this.isThrown();
    }

    public void method_6078(class_1282 source) {
        class_1937 world = this.method_37908();
        if (!world.method_8608()) {
            for (class_1799 stack : this.items) {
                if (stack.method_7960()) continue;
                class_1264.method_5449((class_1937)world, (double)this.method_23317(), (double)this.method_23318(), (double)this.method_23321(), (class_1799)stack);
            }
            this.items.clear();
            this.updateCheekTrackers();
        }
        super.method_6078(source);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "mainController", 2, event -> {
            DozingPhase currentDozingPhase = this.getDozingPhase();
            int personality = (Integer)this.field_6011.method_12789(ANIMATION_PERSONALITY_ID);
            if (this.isShoulderPet()) {
                ShoulderAnimationState shoulderState = ShoulderAnimationState.values()[(Integer)this.field_6011.method_12789(SHOULDER_ANIMATION_STATE)];
                return switch (shoulderState) {
                    case ShoulderAnimationState.SITTING -> {
                        if (this.getHamsterFlag(8192)) {
                            yield event.setAndContinue(CLEANING_ANIM);
                        }
                        RawAnimation v1 = switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        };
                        yield event.setAndContinue(v1);
                    }
                    case ShoulderAnimationState.LAYING_DOWN -> {
                        switch (this.shoulderLocation) {
                            case LEFT_SHOULDER: {
                                yield event.setAndContinue(LAYING_DOWN_LEFT_SHOULDER_ANIM);
                            }
                            case HEAD: {
                                yield event.setAndContinue(LAYING_DOWN_HEAD_ANIM);
                            }
                        }
                        yield event.setAndContinue(LAYING_DOWN_RIGHT_SHOULDER_ANIM);
                    }
                    default -> {
                        RawAnimation current = event.getController().getCurrentRawAnimation();
                        if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                            yield event.setAndContinue(current);
                        }
                        yield event.setAndContinue(this.field_5974.method_43056() ? IDLE1_ANIM : IDLE2_ANIM);
                    }
                };
            }
            if (this.isKnockedOut()) {
                return event.setAndContinue(KNOCKED_OUT_ANIM);
            }
            if (this.isSulking()) {
                return event.setAndContinue(SULKING_ANIM);
            }
            if (this.isThrown()) {
                return event.setAndContinue(FLYING_ANIM);
            }
            if (this.isTaunting()) {
                return event.setAndContinue(DIAMOND_TAUNT_ANIM);
            }
            boolean isSeekingGoalActive = false;
            String activeGoalName = this.getActiveCustomGoalDebugName();
            if (activeGoalName.startsWith(HamsterSeekDiamondGoal.class.getSimpleName())) {
                isSeekingGoalActive = true;
            }
            if (isSeekingGoalActive) {
                double horizontalSpeedSquared = this.method_18798().method_37268();
                if (horizontalSpeedSquared > 1.0E-6) {
                    return event.setAndContinue(SEEKING_DIAMOND_ANIM);
                }
                return event.setAndContinue(WANTS_TO_SEEK_DIAMOND_ANIM);
            }
            if (this.isCelebratingDiamond()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (this.method_6181()) {
                switch (currentDozingPhase.ordinal()) {
                    case 2: {
                        return event.setAndContinue(switch (personality) {
                            case 2 -> DRIFTING_OFF_POSE2_ANIM;
                            case 3 -> DRIFTING_OFF_POSE3_ANIM;
                            default -> DRIFTING_OFF_POSE1_ANIM;
                        });
                    }
                    case 3: {
                        String targetDeepSleepId = (String)this.field_6011.method_12789(CURRENT_DEEP_SLEEP_ANIM_ID);
                        if (!targetDeepSleepId.isEmpty()) {
                            RawAnimation targetDeepSleepAnim = switch (targetDeepSleepId) {
                                case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                                case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                                case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                                default -> SITTING_POSE1_ANIM;
                            };
                            return event.setAndContinue(targetDeepSleepAnim);
                        }
                        if (!this.method_24345()) break;
                        return event.setAndContinue(switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        });
                    }
                    case 4: {
                        String deepSleepId;
                        RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.field_6011.method_12789(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                            case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                            case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                            case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                            default -> {
                                switch (personality) {
                                    case 2: {
                                        yield SITTING_POSE2_ANIM;
                                    }
                                    case 3: {
                                        yield SITTING_POSE3_ANIM;
                                    }
                                }
                                yield SITTING_POSE1_ANIM;
                            }
                        };
                        return event.setAndContinue(deepSleepAnimToPlay);
                    }
                }
            }
            if (!this.method_6181() && this.method_6113()) {
                String deepSleepId;
                RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.field_6011.method_12789(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                    case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                    case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                    default -> SLEEP_POSE1_ANIM;
                };
                return event.setAndContinue(deepSleepAnimToPlay);
            }
            if (this.method_24345() && !this.isKnockedOut()) {
                if (this.getHamsterFlag(8192)) {
                    return event.setAndContinue(CLEANING_ANIM);
                }
                return event.setAndContinue(switch (personality) {
                    case 2 -> SITTING_POSE2_ANIM;
                    case 3 -> SITTING_POSE3_ANIM;
                    default -> SITTING_POSE1_ANIM;
                });
            }
            double horizontalSpeedSquared = this.method_18798().method_37268();
            if (horizontalSpeedSquared > 1.0E-6) {
                if (horizontalSpeedSquared > 0.008) {
                    return event.setAndContinue(SPRINTING_ANIM);
                }
                if (horizontalSpeedSquared > 0.002) {
                    return event.setAndContinue(RUNNING_ANIM);
                }
                return event.setAndContinue(WALKING_ANIM);
            }
            if (this.isBegging()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (activeGoalName.equals(HamsterLookAtEntityGoal.class.getSimpleName())) {
                return switch ((Integer)this.field_6011.method_12789(CURRENT_LOOK_UP_ANIM_ID)) {
                    case 2 -> event.setAndContinue(IDLE_LOOKING_UP2_ANIM);
                    case 3 -> event.setAndContinue(IDLE_LOOKING_UP3_ANIM);
                    default -> event.setAndContinue(IDLE_LOOKING_UP1_ANIM);
                };
            }
            RawAnimation current = event.getController().getCurrentRawAnimation();
            if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                return event.setAndContinue(current);
            }
            return event.setAndContinue(this.field_5974.method_43056() ? IDLE1_ANIM : IDLE2_ANIM);
        }).triggerableAnim("crash", CRASH_ANIM).triggerableAnim("wakeup", WAKE_UP_ANIM).triggerableAnim("stationary_headshake", STATIONARY_HEADSHAKE_ANIM).triggerableAnim("moving_headshake", MOVING_HEADSHAKE_ANIM).triggerableAnim("attack", ATTACK_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep1", SIT_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep2", SIT_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep3", SIT_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep1", STAND_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep2", STAND_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep3", STAND_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_sulk", SULK_ANIM).triggerableAnim("anim_hamster_diamond_pounce", DIAMOND_POUNCE_ANIM).triggerableAnim("anim_hamster_celebrate_chase", CELEBRATE_CHASE_ANIM).setParticleKeyframeHandler(event -> {
            this.particleEffectId = event.getKeyframeData().getEffect();
        }).setSoundKeyframeHandler(event -> {
            this.soundEffectId = event.getKeyframeData().getSound();
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerAnimOnServer(String controllerName, String animName) {
        if (!this.method_37908().method_8608()) {
            class_3218 serverWorld = (class_3218)this.method_37908();
            this.triggerAnim(controllerName, animName);
            AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Triggered server-side animation: Controller='{}', Anim='{}'", new Object[]{this.method_5628(), controllerName, animName});
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HAMSTER_FLAGS, (Object)0);
        builder.method_56912(VARIANT, (Object)0);
        builder.method_56912(PINK_PETAL_TYPE, (Object)0);
        builder.method_56912(DOZING_PHASE, (Object)DozingPhase.NONE.ordinal());
        builder.method_56912(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)"");
        builder.method_56912(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)"None");
        builder.method_56912(ANIMATION_PERSONALITY_ID, (Object)1);
        builder.method_56912(STEAL_DURATION_TIMER, (Object)0);
        builder.method_56912(STOLEN_ITEM_STACK, (Object)class_1799.field_8037);
        builder.method_56912(GREEN_BEAN_BUFF_DURATION, (Object)0L);
        builder.method_56912(CURRENT_LOOK_UP_ANIM_ID, (Object)1);
        builder.method_56912(SHOULDER_ANIMATION_STATE, (Object)ShoulderAnimationState.STANDING.ordinal());
    }

    protected void method_5959() {
        AdorableHamsterPets.LOGGER.debug("[AI Init {} Tick {}] Initializing goals. Current State: isSleeping={}, isSittingPose={}", new Object[]{this.method_5628(), this.method_37908().field_9236 ? "ClientTick?" : Long.valueOf(this.method_37908().method_8510()), this.method_6113(), this.method_6172()});
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new HamsterSeekDiamondGoal(this));
        this.field_6201.method_6277(1, (class_1352)new HamsterStealDiamondGoal(this));
        this.field_6201.method_6277(2, (class_1352)new HamsterMeleeAttackGoal(this, 1.5, true));
        this.field_6201.method_6277(3, (class_1352)new HamsterMateGoal(this, 0.75));
        this.field_6201.method_6277(4, (class_1352)new HamsterFollowOwnerGoal(this, 1.0, 4.0f, 16.0f));
        this.field_6201.method_6277(5, new HamsterFleeGoal<class_1309>(this, class_1309.class, 8.0f, 0.75, 1.5));
        this.field_6201.method_6277(6, (class_1352)new HamsterTemptGoal(this, 1.0, false));
        this.field_6201.method_6277(7, (class_1352)new HamsterSitGoal(this));
        this.field_6201.method_6277(8, (class_1352)new HamsterSleepGoal(this));
        this.field_6201.method_6277(9, (class_1352)new HamsterWanderAroundFarGoal(this, 0.75));
        this.field_6201.method_6277(10, (class_1352)new HamsterLookAtEntityGoal((class_1308)this, class_1657.class, 2.0f, 0.15f));
        this.field_6201.method_6277(11, (class_1352)new HamsterLookAroundGoal((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        AdorableHamsterPets.LOGGER.debug("[AI Init {} Tick {}] Finished initializing goals.", (Object)this.method_5628(), this.method_37908().field_9236 ? "ClientTick?" : Long.valueOf(this.method_37908().method_8510()));
    }

    public void method_5980(@Nullable class_1309 target) {
        if (target == null) {
            super.method_5980(null);
            return;
        }
        if (this.method_6181() && this.method_35057() != null) {
            class_8046 ownableFallback;
            class_1297 fallbackOwnerEntity;
            class_1309 owner = this.method_35057();
            UUID ownerUuid = owner.method_5667();
            boolean preventTargeting = false;
            if (target instanceof class_1321) {
                class_1321 tameablePet = (class_1321)target;
                UUID petOwnerUuid = tameablePet.method_6139();
                if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid) && tameablePet != this) {
                    preventTargeting = true;
                }
            } else if (target instanceof class_1496) {
                class_1496 horsePet = (class_1496)target;
                class_1309 horseOwnerEntity = horsePet.method_35057();
                if (horseOwnerEntity != null && horseOwnerEntity.method_5667().equals(ownerUuid)) {
                    preventTargeting = true;
                }
            } else if (target instanceof class_8046 && (fallbackOwnerEntity = (ownableFallback = (class_8046)target).method_24921()) != null && fallbackOwnerEntity.method_5667().equals(ownerUuid) && ownableFallback != this) {
                preventTargeting = true;
            }
            if (preventTargeting) {
                super.method_5980(null);
                return;
            }
        }
        super.method_5980(target);
    }

    protected class_3414 method_5994() {
        if (this.isKnockedOut()) {
            return null;
        }
        if (this.isBegging() || this.isTaunting()) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.field_5974);
        }
        boolean playSleepSounds = false;
        if (this.method_6181()) {
            DozingPhase phase = this.getDozingPhase();
            if (phase == DozingPhase.DRIFTING_OFF || phase == DozingPhase.SETTLING_INTO_SLUMBER || phase == DozingPhase.DEEP_SLEEP) {
                playSleepSounds = true;
            }
        } else if (this.method_6113()) {
            playSleepSounds = true;
        }
        if (playSleepSounds) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.field_5974);
        }
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.field_5974);
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null && Arrays.asList(ModSounds.HAMSTER_BEG_SOUNDS).contains(soundEvent)) {
            this.method_5783(soundEvent, 0.8f, this.method_6017());
        } else {
            super.method_5966();
        }
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.field_5974);
    }

    protected class_3414 method_6002() {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DEATH_SOUNDS, this.field_5974);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.method_37908().method_8608()) {
            return;
        }
        if (!HamsterRenderTracker.isBeingRendered(this.method_5628())) {
            try {
                class_2498 group = state.method_26231();
                float volume = state.method_27852(class_2246.field_10255) ? 0.060000002f : 0.1f;
                this.method_5783(group.method_10594(), volume, group.method_10599() * 1.5f);
            }
            catch (Exception ex) {
                AdorableHamsterPets.LOGGER.warn("Error playing fallback step sound", (Throwable)ex);
            }
        }
    }

    protected boolean canHitEntity(class_1297 entity) {
        if (entity instanceof class_1531) {
            return !entity.method_7325();
        }
        if (!entity.method_7325() && entity.method_5805() && entity.method_5863()) {
            class_1309 owner = this.method_35057();
            return entity != this && (owner == null || !owner.method_5794(entity));
        }
        return false;
    }

    protected void method_56990() {
        if (this.isThrown() && this.method_5740()) {
            return;
        }
        super.method_56990();
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] HamsterEntity.initialize called. SpawnReason: {}", (Object)spawnReason);
        this.field_6011.method_12778(ANIMATION_PERSONALITY_ID, (Object)this.field_5974.method_39332(1, 3));
        if (spawnReason == class_3730.field_16459 || spawnReason == class_3730.field_16465 || spawnReason == class_3730.field_16472) {
            class_6880 biomeEntry = world.method_23753(this.method_24515());
            String biomeKeyStr = biomeEntry.method_40230().map(key -> key.method_29177().toString()).orElse("UNKNOWN");
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] SpawnReason: {}, BiomeKey: {}", (Object)spawnReason, (Object)biomeKeyStr);
            HamsterVariant chosenVariant = HamsterEntity.determineVariantForBiome((class_6880<class_1959>)biomeEntry, this.field_5974);
            this.setVariant(chosenVariant.getId());
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] Assigned variant: {}", (Object)chosenVariant.name());
        } else {
            int randomVariantId = this.field_5974.method_43048(HamsterVariant.values().length);
            this.setVariant(randomVariantId);
            AdorableHamsterPets.LOGGER.debug("[HamsterInit] SpawnReason: {}, Assigned random variant: {}", (Object)spawnReason, (Object)HamsterVariant.byId(randomVariantId).name());
        }
        if (!this.method_6181()) {
            this.method_5996(class_5134.field_23716).method_6192(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.method_6033(this.method_6063());
        }
        this.updateCheekTrackers();
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected class_1330 method_5963() {
        return new HamsterBodyControl((class_1308)this);
    }

    private boolean getHamsterFlag(int flag) {
        return ((Integer)this.field_6011.method_12789(HAMSTER_FLAGS) & flag) != 0;
    }

    private void setHamsterFlag(int flag, boolean value) {
        int currentFlags = (Integer)this.field_6011.method_12789(HAMSTER_FLAGS);
        if (value) {
            this.field_6011.method_12778(HAMSTER_FLAGS, (Object)(currentFlags | flag));
        } else {
            this.field_6011.method_12778(HAMSTER_FLAGS, (Object)(currentFlags & ~flag));
        }
    }

    private boolean isSafeSpawnLocation(class_2338 pos, class_1937 world) {
        class_2338 floorPos = pos.method_10074();
        class_2680 floorState = world.method_8320(floorPos);
        class_7 floorType = LandPathNodeMakerInvoker.callGetCommonNodeType((class_1922)world, floorPos);
        if (HAZARDOUS_FLOOR_TYPES.contains(floorType)) {
            return false;
        }
        if (floorState.method_26220((class_1922)world, floorPos).method_1110()) {
            return false;
        }
        class_3726 entityContext = class_3726.method_16195((class_1297)this);
        return world.method_8320(pos).method_26194((class_1922)world, pos, entityContext).method_1110() && world.method_8320(pos.method_10084()).method_26194((class_1922)world, pos.method_10084(), entityContext).method_1110();
    }

    public boolean isItemDisallowed(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (ModItemTags.isPouchAllowed(stack)) {
            return false;
        }
        if (ModItemTags.isPouchDisallowed(stack)) {
            return true;
        }
        if (stack.method_57824(class_9334.field_50075) != null) {
            return false;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1747) {
            return true;
        }
        return item instanceof class_1826;
    }

    private class_7225.class_7874 getRegistryLookup() {
        return this.method_37908().method_30349();
    }

    private boolean tryTame(class_1657 player, class_1799 itemStack) {
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int denominator = Math.max(1, (Integer)config.tamingChanceDenominator.get());
        if (this.field_5974.method_43048(denominator) == 0) {
            this.method_6174(player.method_5667());
            this.method_6173(true, true);
            this.field_6189.method_6340();
            this.method_24346(false);
            this.setSleeping(false);
            this.method_5980(null);
            this.method_37908().method_8421((class_1297)this, (byte)7);
            class_3414 celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.field_5974);
            this.method_37908().method_8396(null, this.method_24515(), celebrateSound, class_3419.field_15254, 0.7f, 1.0f);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_1201.method_9132(serverPlayer, (class_1429)this);
            }
            return true;
        }
        this.method_37908().method_8421((class_1297)this, (byte)6);
        return false;
    }

    private boolean checkRepeatFoodRefusal(class_1799 currentStack, class_1657 player) {
        if (ModItemTags.isRepeatableFood(currentStack)) {
            return false;
        }
        if (!this.lastFoodItem.method_7960() && class_1799.method_7984((class_1799)this.lastFoodItem, (class_1799)currentStack)) {
            this.setRefusingFood(true);
            this.refuseTimer = 40;
            player.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.food_refusal"), true);
            if (!this.method_37908().method_8608()) {
                boolean isMoving;
                boolean bl = isMoving = this.method_18798().method_37268() > 1.0E-6;
                if (isMoving) {
                    this.triggerAnimOnServer("mainController", "moving_headshake");
                } else {
                    this.triggerAnimOnServer("mainController", "stationary_headshake");
                }
            }
            return true;
        }
        return false;
    }

    private boolean tryFeedingAsTamed(class_1657 player, class_1799 stack) {
        boolean isFood = ModItemTags.isStandardFood(stack);
        boolean isBuffItem = ModItemTags.isBuffFood(stack);
        boolean isPouchUnlockFood = ModItemTags.isPouchUnlockFood(stack);
        boolean canHeal = this.method_6032() < this.method_6063();
        boolean readyToBreed = this.method_5618() == 0 && !this.isInCustomLove();
        class_1937 world = this.method_37908();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        boolean actionTaken = false;
        AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Entering tryFeedingAsTamed. Item: {}, isFood={}, isBuff={}, canHeal={}, breedingAge={}, isInCustomLove={}, readyToBreed={}", new Object[]{this.method_5628(), world.method_8510(), stack.method_7909(), isFood, isBuffItem, canHeal, this.method_5618(), this.isInCustomLove(), readyToBreed});
        if (isPouchUnlockFood && !this.getHamsterFlag(512)) {
            this.setHamsterFlag(512, true);
            AdorableHamsterPets.LOGGER.debug("Hamster {} cheek pouch unlocked by {}.", (Object)this.method_5628(), (Object)stack.method_7909());
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ((CheekPouchUnlockedCriterion)((Object)ModCriteria.CHEEK_POUCH_UNLOCKED.get())).trigger(serverPlayer, this);
            }
            world.method_8396(null, this.method_24515(), class_3417.field_14709, class_3419.field_15254, 0.5f, 1.5f);
            if (!world.field_9236) {
                ((class_3218)world).method_14199((class_2394)new class_2392(class_2398.field_11218, stack.method_7972()), this.method_23317(), this.method_23323(0.2), this.method_23321(), 25, 0.25, 0.15, 0.25, 0.0);
            }
            return true;
        }
        if (isBuffItem) {
            long currentTime = world.method_8510();
            if (this.greenBeanBuffEndTick > currentTime) {
                long remainingTicks = this.greenBeanBuffEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                player.method_7353((class_2561)class_2561.method_43469((String)"message.adorablehamsterpets.beans_cooldown", (Object[])new Object[]{minutes, seconds}).method_27692(class_124.field_1061), true);
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Buff item used, but on cooldown ({} ticks remaining). Returning false.", new Object[]{this.method_5628(), world.method_8510(), remainingTicks});
                return false;
            }
            int duration = (Integer)config.greenBeanBuffDuration.get();
            int speedAmplifier = (Integer)config.greenBeanBuffAmplifierSpeed.get();
            int strengthAmplifier = (Integer)config.greenBeanBuffAmplifierStrength.get();
            int absorptionAmplifier = (Integer)config.greenBeanBuffAmplifierAbsorption.get();
            int regenAmplifier = (Integer)config.greenBeanBuffAmplifierRegen.get();
            this.zoomiesIsClockwise = this.field_5974.method_43056();
            this.lastZoomiesAngle = 0.0;
            this.method_6092(new class_1293(class_1294.field_5904, duration, speedAmplifier));
            this.method_6092(new class_1293(class_1294.field_5910, duration, strengthAmplifier));
            this.method_6092(new class_1293(class_1294.field_5898, duration, absorptionAmplifier));
            this.method_6092(new class_1293(class_1294.field_5924, duration, regenAmplifier));
            this.zoomiesIsClockwise = this.field_5974.method_43056();
            this.zoomiesRadiusModifier = this.field_5974.method_39332(-2, 4);
            double dx = this.method_23317() - player.method_23317();
            double dz = this.method_23321() - player.method_23321();
            this.lastZoomiesAngle = Math.atan2(dz, dx);
            class_3414 buffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.field_5974);
            world.method_8396(null, this.method_24515(), buffSound, class_3419.field_15254, 1.0f, 1.0f);
            long buffDurationEnd = currentTime + (long)((Integer)config.greenBeanBuffDuration.get()).intValue();
            this.method_5841().method_12778(GREEN_BEAN_BUFF_DURATION, (Object)buffDurationEnd);
            this.greenBeanBuffEndTick = currentTime + (long)((Integer)config.steamedGreenBeansBuffCooldown.get()).intValue();
            actionTaken = true;
            AdorableHamsterPets.LOGGER.trace("[FeedAttempt {} Tick {}] Applied buffs. Duration ends at tick {}. Cooldown ends at tick {}.", new Object[]{this.method_5628(), world.method_8510(), buffDurationEnd, this.greenBeanBuffEndTick});
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ((FedHamsterSteamedBeansCriterion)((Object)ModCriteria.FED_HAMSTER_STEAMED_BEANS.get())).trigger(serverPlayer, this);
            }
        } else if (ModItemTags.isStandardFood(stack)) {
            if (canHeal) {
                this.method_6025(((Float)config.standardFoodHealing.get()).floatValue());
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Healed with standard food.", (Object)this.method_5628());
            } else if (readyToBreed) {
                this.setSitting(false, true);
                this.setCustomInLove(player);
                this.setInLove(true);
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Entered love mode with standard food.", (Object)this.method_5628());
            }
        }
        if (!actionTaken) {
            AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Item {} was not a valid food for any action.", new Object[]{this.method_5628(), world.method_8510(), stack.method_7909()});
        }
        return actionTaken;
    }

    @Unique
    private boolean checkConditionsForInitiatingDrowsiness() {
        if (!this.method_24345()) {
            return false;
        }
        class_1937 world = this.method_37908();
        if (Configs.AHP.requireDaytimeForTamedSleep && !world.method_8530()) {
            return false;
        }
        if (this.method_6479()) {
            return false;
        }
        if (!this.method_24828()) {
            return false;
        }
        double threatRadius = ((Integer)Configs.AHP.tamedSleepThreatDetectionRadiusBlocks.get()).intValue();
        List nearbyHostiles = world.method_8390(class_1309.class, this.method_5829().method_1014(threatRadius), entity -> entity instanceof class_1588 && entity.method_5805() && !entity.method_7325());
        return nearbyHostiles.isEmpty();
    }

    @Unique
    private boolean checkConditionsForSustainingSlumber() {
        return this.method_24345() && this.checkConditionsForInitiatingDrowsiness();
    }

    @Unique
    private void resetSleepSequence(String reason) {
        AdorableHamsterPets.LOGGER.debug("Hamster {} resetting sleep sequence: {}. Current phase was: {}", new Object[]{this.method_5628(), reason, this.getDozingPhase()});
        this.setDozingPhase(DozingPhase.NONE);
        this.quiescentSitDurationTimer = 0;
        this.driftingOffTimer = 0;
        this.settleSleepAnimationCooldown = 0;
    }

    public void method_36209() {
        super.method_36209();
        if (!this.method_37908().method_8608()) {
            HamsterRenderTracker.onEntityUnload(this.method_5628());
        }
    }

    public static enum DozingPhase {
        NONE,
        QUIESCENT_SITTING,
        DRIFTING_OFF,
        SETTLING_INTO_SLUMBER,
        DEEP_SLEEP;

    }
}

