/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.client.announcements.Announcement;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.mixin.accessor.BookContentsBuilderAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;

@Mixin(value={BookContentsBuilder.class}, remap=false)
public class BookContentsBuilderMixin {
    @Inject(method={"build"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onBuild(class_1937 level, CallbackInfoReturnable<BookContents> cir) {
        BookCategory cat;
        class_2960 announcementsId;
        BookContentsBuilderAccessor accessor = (BookContentsBuilderAccessor)((Object)this);
        Book hamsterBook = accessor.getBook();
        if (hamsterBook == null || !hamsterBook.id.equals((Object)class_2960.method_60655((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"))) {
            return;
        }
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] Found target book. Starting virtual content injection.");
        Map<class_2960, BookCategory> categories = accessor.getCategories();
        Map<class_2960, BookEntry> entries = accessor.getEntries();
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] Before injection: {} categories, {} entries.", (Object)categories.size(), (Object)entries.size());
        class_2960 updatesId = class_2960.method_60655((String)"adorablehamsterpets", (String)"update_notes");
        if (!categories.containsKey(updatesId)) {
            BookCategory updatesCategory = this.createVirtualCategory(hamsterBook, "book.adorablehamsterpets.category.update_notes", "minecraft:writable_book", 99, updatesId);
            categories.put(updatesId, updatesCategory);
        }
        if (!categories.containsKey(announcementsId = class_2960.method_60655((String)"adorablehamsterpets", (String)"announcements"))) {
            BookCategory announcementsCategory = this.createVirtualCategory(hamsterBook, "book.adorablehamsterpets.category.announcements", "adorablehamsterpets:announcement_bell_icon", 98, announcementsId);
            categories.put(announcementsId, announcementsCategory);
        }
        BookContentsBuilder self = (BookContentsBuilder)this;
        List<Announcement> allMessages = AnnouncementManager.INSTANCE.getAllManifestMessages();
        allMessages.stream().sorted(Comparator.comparing(Announcement::published, Comparator.reverseOrder())).forEach(announcement -> {
            class_2960 entryId = class_2960.method_60655((String)"adorablehamsterpets", (String)("announcement_" + announcement.id()));
            if (!entries.containsKey(entryId)) {
                AdorableHamsterPets.LOGGER.debug("[AHP Mixin] -> Creating virtual entry '{}'", (Object)entryId);
                boolean isUpdate = "update".equals(announcement.kind());
                class_2960 categoryId = isUpdate ? updatesId : announcementsId;
                String icon = isUpdate ? "minecraft:writable_book" : "adorablehamsterpets:announcement_bell_icon";
                BookEntry entry = this.createVirtualEntry(hamsterBook, announcement.title(), icon, isUpdate, categoryId, entryId);
                entry.initCategory(entryId, categories::get);
                entries.put(entryId, entry);
                try {
                    entry.build(level, self);
                }
                catch (Exception e) {
                    AdorableHamsterPets.LOGGER.error("[AHP Mixin] Failed to build virtual entry {}", (Object)entryId, (Object)e);
                }
            }
        });
        if (categories.containsKey(updatesId)) {
            cat = categories.get(updatesId);
            cat.build(self);
            cat.updateLockStatus(true);
            AdorableHamsterPets.LOGGER.debug("[AHP Mixin] Built 'update_notes' category with {} entries.", (Object)cat.getEntries().size());
        }
        if (categories.containsKey(announcementsId)) {
            cat = categories.get(announcementsId);
            cat.build(self);
            cat.updateLockStatus(true);
            AdorableHamsterPets.LOGGER.debug("[AHP Mixin] Built 'announcements' category with {} entries.", (Object)cat.getEntries().size());
        }
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] After injection: {} categories, {} entries.", (Object)categories.size(), (Object)entries.size());
    }

    private BookCategory createVirtualCategory(Book book, String nameKey, String icon, int sortnum, class_2960 id) {
        JsonObject json = new JsonObject();
        json.addProperty("name", nameKey);
        json.addProperty("description", nameKey + ".desc");
        json.addProperty("icon", icon);
        json.addProperty("sortnum", (Number)sortnum);
        json.addProperty("parent", "");
        return new BookCategory(json, id, book);
    }

    private BookEntry createVirtualEntry(Book book, String name, String icon, boolean priority, class_2960 categoryId, class_2960 entryId) {
        JsonObject json = new JsonObject();
        json.addProperty("name", name);
        json.addProperty("icon", icon);
        json.addProperty("priority", Boolean.valueOf(priority));
        json.addProperty("category", categoryId.toString());
        json.add("pages", (JsonElement)new JsonArray());
        return new BookEntry(json, entryId, book, "adorablehamsterpets");
    }
}

