/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.tag;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class ModItemTags {
    private static final Set<class_1792> tamingItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> tamingTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> standardFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> standardFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> stealableItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> stealableTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> buffFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> buffFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> shoulderMountItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> shoulderMountTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> pouchUnlockItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> pouchUnlockTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> repeatableFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> repeatableFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> pouchAllowedItems = new HashSet<class_1792>();
    private static final Set<class_1792> autoHealFoodItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> autoHealFoodTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_6862<class_1792>> pouchAllowedTags = new HashSet<class_6862<class_1792>>();
    private static final Set<class_1792> pouchDisallowedItems = new HashSet<class_1792>();
    private static final Set<class_6862<class_1792>> pouchDisallowedTags = new HashSet<class_6862<class_1792>>();

    public static void parseConfig() {
        ModItemTags.clearAll();
        ModItemTags.parseList(Configs.AHP.tamingFoods, tamingItems, tamingTags, "tamingFoods");
        ModItemTags.parseList(Configs.AHP.standardFoods, standardFoodItems, standardFoodTags, "standardFoods");
        ModItemTags.parseList(Configs.AHP.stealableItems, stealableItems, stealableTags, "stealableItems");
        ModItemTags.parseList(Configs.AHP.buffFoods, buffFoodItems, buffFoodTags, "buffFoods");
        ModItemTags.parseList(Configs.AHP.shoulderMountFoods, shoulderMountItems, shoulderMountTags, "shoulderMountFoods");
        ModItemTags.parseList(Configs.AHP.pouchUnlockFoods, pouchUnlockItems, pouchUnlockTags, "pouchUnlockFoods");
        ModItemTags.parseList(Configs.AHP.repeatableFoods, repeatableFoodItems, repeatableFoodTags, "repeatableFoods");
        ModItemTags.parseList(Configs.AHP.pouchAllowedItems, pouchAllowedItems, pouchAllowedTags, "pouchAllowedItems");
        ModItemTags.parseList(Configs.AHP.pouchDisallowedItems, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedItems");
        ModItemTags.parseList(Configs.AHP.pouchDisallowedTags, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedTags");
        ModItemTags.parseList(Configs.AHP.autoHealFoods, autoHealFoodItems, autoHealFoodTags, "autoHealFoods");
        AdorableHamsterPets.LOGGER.info("Parsed all item tag overrides from config.");
    }

    public static boolean isTamingFood(class_1799 stack) {
        return ModItemTags.matches(stack, tamingItems, tamingTags);
    }

    public static boolean isStandardFood(class_1799 stack) {
        return ModItemTags.matches(stack, standardFoodItems, standardFoodTags);
    }

    public static boolean isStealableItem(class_1799 stack) {
        return ModItemTags.matches(stack, stealableItems, stealableTags);
    }

    public static boolean isBuffFood(class_1799 stack) {
        return ModItemTags.matches(stack, buffFoodItems, buffFoodTags);
    }

    public static boolean isShoulderMountFood(class_1799 stack) {
        return ModItemTags.matches(stack, shoulderMountItems, shoulderMountTags);
    }

    public static boolean isPouchUnlockFood(class_1799 stack) {
        return ModItemTags.matches(stack, pouchUnlockItems, pouchUnlockTags);
    }

    public static boolean isRepeatableFood(class_1799 stack) {
        return ModItemTags.matches(stack, repeatableFoodItems, repeatableFoodTags);
    }

    public static boolean isAutoHealFood(class_1799 stack) {
        return ModItemTags.matches(stack, autoHealFoodItems, autoHealFoodTags);
    }

    public static boolean isPouchAllowed(class_1799 stack) {
        return ModItemTags.matches(stack, pouchAllowedItems, pouchAllowedTags);
    }

    public static boolean isPouchDisallowed(class_1799 stack) {
        return ModItemTags.matches(stack, pouchDisallowedItems, pouchDisallowedTags);
    }

    private static void parseList(List<String> configList, Set<class_1792> itemSet, Set<class_6862<class_1792>> tagSet, String listName) {
        for (String entry : configList) {
            if (entry.startsWith("#")) {
                try {
                    class_2960 tagId = class_2960.method_60654((String)entry.substring(1));
                    tagSet.add((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7923.field_41178.method_30517(), (class_2960)tagId));
                }
                catch (Exception e) {
                    AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item tag identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
                }
                continue;
            }
            try {
                class_2960 itemId = class_2960.method_60654((String)entry);
                class_7923.field_41178.method_17966(itemId).ifPresent(itemSet::add);
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static boolean matches(class_1799 stack, Set<class_1792> itemSet, Set<class_6862<class_1792>> tagSet) {
        if (stack.method_7960()) {
            return false;
        }
        if (itemSet.contains(stack.method_7909())) {
            return true;
        }
        for (class_6862<class_1792> tag : tagSet) {
            if (!stack.method_31573(tag)) continue;
            return true;
        }
        return false;
    }

    private static void clearAll() {
        tamingItems.clear();
        tamingTags.clear();
        standardFoodItems.clear();
        standardFoodTags.clear();
        stealableItems.clear();
        stealableTags.clear();
        buffFoodItems.clear();
        buffFoodTags.clear();
        shoulderMountItems.clear();
        shoulderMountTags.clear();
        pouchUnlockItems.clear();
        pouchUnlockTags.clear();
        repeatableFoodItems.clear();
        repeatableFoodTags.clear();
        autoHealFoodItems.clear();
        autoHealFoodTags.clear();
        pouchAllowedItems.clear();
        pouchAllowedTags.clear();
        pouchDisallowedItems.clear();
        pouchDisallowedTags.clear();
    }
}

