/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.abyssaldescent.block;

import net.mcreator.abyssaldescent.init.AbyssalDescentModBlocks;
import net.mcreator.abyssaldescent.procedures.ClosedTotemHoleOnTickUpdateProcedure;
import net.mcreator.abyssaldescent.procedures.TotemHoleEntityWalksOnTheBlockProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ClosedTotemHoleBlock
extends Block {
    public ClosedTotemHoleBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.SCULK_SHRIEKER).strength(15.0f, 1.0f).requiresCorrectToolForDrops());
    }

    public int getLightBlock(BlockState state) {
        return 15;
    }

    public ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData, Player entity) {
        return new ItemStack((ItemLike)AbyssalDescentModBlocks.TOTEM_HOLE.get());
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 20);
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        ClosedTotemHoleOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 20);
    }

    public void stepOn(Level world, BlockPos pos, BlockState blockstate, Entity entity) {
        super.stepOn(world, pos, blockstate, entity);
        TotemHoleEntityWalksOnTheBlockProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), entity);
    }
}

