/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cropcraft.entity;

import io.netty.buffer.Unpooled;
import net.mcreator.cropcraft.procedures.EndermenFloristIsNoyInActionProcedure;
import net.mcreator.cropcraft.procedures.EndermenFloristPriObnovlieniiTikaSushchnostiProcedure;
import net.mcreator.cropcraft.procedures.EndermenFloristPriRanieniiSushchnostiProcedure;
import net.mcreator.cropcraft.procedures.EndermenFloristUsloviieProighryvaniiaProcedure;
import net.mcreator.cropcraft.world.inventory.EndermenFloristGUIMenu;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityArmorInvWrapper;
import net.neoforged.neoforge.items.wrapper.EntityHandsInvWrapper;

public class EndermenFloristEntity
extends Monster {
    public static final EntityDataAccessor<Boolean> DATA_sitting = SynchedEntityData.defineId(EndermenFloristEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    private final ItemStackHandler inventory = new ItemStackHandler(9);
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public EndermenFloristEntity(EntityType<EndermenFloristEntity> type, Level world) {
        super(type, world);
        this.xpReward = 5;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_sitting, (Object)false);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal(this, (PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }
        });
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = EndermenFloristEntity.this.getX();
                double y = EndermenFloristEntity.this.getY();
                double z = EndermenFloristEntity.this.getZ();
                EndermenFloristEntity entity = EndermenFloristEntity.this;
                Level world = EndermenFloristEntity.this.level();
                return super.canUse() && EndermenFloristIsNoyInActionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = EndermenFloristEntity.this.getX();
                double y = EndermenFloristEntity.this.getY();
                double z = EndermenFloristEntity.this.getZ();
                EndermenFloristEntity entity = EndermenFloristEntity.this;
                Level world = EndermenFloristEntity.this.level();
                return super.canContinueToUse() && EndermenFloristIsNoyInActionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = EndermenFloristEntity.this.getX();
                double y = EndermenFloristEntity.this.getY();
                double z = EndermenFloristEntity.this.getZ();
                EndermenFloristEntity entity = EndermenFloristEntity.this;
                Level world = EndermenFloristEntity.this.level();
                return super.canUse() && EndermenFloristIsNoyInActionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = EndermenFloristEntity.this.getX();
                double y = EndermenFloristEntity.this.getY();
                double z = EndermenFloristEntity.this.getZ();
                EndermenFloristEntity entity = EndermenFloristEntity.this;
                Level world = EndermenFloristEntity.this.level();
                return super.canContinueToUse() && EndermenFloristIsNoyInActionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = EndermenFloristEntity.this.getX();
                double y = EndermenFloristEntity.this.getY();
                double z = EndermenFloristEntity.this.getZ();
                EndermenFloristEntity entity = EndermenFloristEntity.this;
                Level world = EndermenFloristEntity.this.level();
                return super.canUse() && EndermenFloristIsNoyInActionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = EndermenFloristEntity.this.getX();
                double y = EndermenFloristEntity.this.getY();
                double z = EndermenFloristEntity.this.getZ();
                EndermenFloristEntity entity = EndermenFloristEntity.this;
                Level world = EndermenFloristEntity.this.level();
                return super.canContinueToUse() && EndermenFloristIsNoyInActionProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.enderman.ambient"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.enderman.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.enderman.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        EndermenFloristEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        EndermenFloristPriRanieniiSushchnostiProcedure.execute(x, y, z, (Entity)entity);
        return super.hurtServer(level, damagesource, amount);
    }

    public CombinedInvWrapper getCombinedInventory() {
        return this.combined;
    }

    protected void dropEquipment(ServerLevel serverLevel) {
        super.dropEquipment(serverLevel);
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
            this.spawnAtLocation(serverLevel, itemstack);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Datasitting", ((Boolean)this.entityData.get(DATA_sitting)).booleanValue());
        compound.put("InventoryCustom", (Tag)this.inventory.serializeNBT((HolderLookup.Provider)this.registryAccess()));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        Tag tag;
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datasitting")) {
            this.entityData.set(DATA_sitting, (Object)compound.getBoolean("Datasitting"));
        }
        if ((tag = compound.get("InventoryCustom")) instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)tag;
            this.inventory.deserializeNBT((HolderLookup.Provider)this.registryAccess(), inventoryTag);
        }
    }

    public InteractionResult mobInteract(final Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        if (sourceentity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Endermen florist");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(sourceentity.blockPosition());
                    packetBuffer.writeByte(0);
                    packetBuffer.writeVarInt(EndermenFloristEntity.this.getId());
                    return new EndermenFloristGUIMenu(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.writeBlockPos(sourceentity.blockPosition());
                buf.writeByte(0);
                buf.writeVarInt(this.getId());
            });
        }
        super.mobInteract(sourceentity, hand);
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState2.animateWhen(EndermenFloristUsloviieProighryvaniiaProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        EndermenFloristPriObnovlieniiTikaSushchnostiProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 40.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 7.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.0);
        return builder;
    }
}

