/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cropcraft.entity;

import net.mcreator.cropcraft.init.CropcraftModEntities;
import net.mcreator.cropcraft.init.CropcraftModItems;
import net.mcreator.cropcraft.procedures.VoraciousParsnipsIsNoyInActionProcedure;
import net.mcreator.cropcraft.procedures.VoraciousParsnipsPriObnovlieniiTikaSushchnostiProcedure;
import net.mcreator.cropcraft.procedures.VoraciousParsnipsUsloviieProighryvaniiaProcedure;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class VoraciousParsnipsEntity
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> DATA_actionState = SynchedEntityData.defineId(VoraciousParsnipsEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<String> DATA_model = SynchedEntityData.defineId(VoraciousParsnipsEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();

    public VoraciousParsnipsEntity(EntityType<VoraciousParsnipsEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_actionState, (Object)0);
        builder.define(DATA_model, (Object)"AGRO");
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 32.0f, 4.0f));
        this.targetSelector.addGoal(3, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = VoraciousParsnipsEntity.this.getX();
                double y = VoraciousParsnipsEntity.this.getY();
                double z = VoraciousParsnipsEntity.this.getZ();
                VoraciousParsnipsEntity entity = VoraciousParsnipsEntity.this;
                Level world = VoraciousParsnipsEntity.this.level();
                return super.canUse() && VoraciousParsnipsIsNoyInActionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = VoraciousParsnipsEntity.this.getX();
                double y = VoraciousParsnipsEntity.this.getY();
                double z = VoraciousParsnipsEntity.this.getZ();
                VoraciousParsnipsEntity entity = VoraciousParsnipsEntity.this;
                Level world = VoraciousParsnipsEntity.this.level();
                return super.canContinueToUse() && VoraciousParsnipsIsNoyInActionProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = VoraciousParsnipsEntity.this.getX();
                double y = VoraciousParsnipsEntity.this.getY();
                double z = VoraciousParsnipsEntity.this.getZ();
                VoraciousParsnipsEntity entity = VoraciousParsnipsEntity.this;
                Level world = VoraciousParsnipsEntity.this.level();
                return super.canUse() && VoraciousParsnipsIsNoyInActionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = VoraciousParsnipsEntity.this.getX();
                double y = VoraciousParsnipsEntity.this.getY();
                double z = VoraciousParsnipsEntity.this.getZ();
                VoraciousParsnipsEntity entity = VoraciousParsnipsEntity.this;
                Level world = VoraciousParsnipsEntity.this.level();
                return super.canContinueToUse() && VoraciousParsnipsIsNoyInActionProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(6, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = VoraciousParsnipsEntity.this.getX();
                double y = VoraciousParsnipsEntity.this.getY();
                double z = VoraciousParsnipsEntity.this.getZ();
                VoraciousParsnipsEntity entity = VoraciousParsnipsEntity.this;
                Level world = VoraciousParsnipsEntity.this.level();
                return super.canUse() && VoraciousParsnipsIsNoyInActionProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = VoraciousParsnipsEntity.this.getX();
                double y = VoraciousParsnipsEntity.this.getY();
                double z = VoraciousParsnipsEntity.this.getZ();
                VoraciousParsnipsEntity entity = VoraciousParsnipsEntity.this;
                Level world = VoraciousParsnipsEntity.this.level();
                return super.canContinueToUse() && VoraciousParsnipsIsNoyInActionProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    protected void dropCustomDeathLoot(ServerLevel serverLevel, DamageSource source, boolean recentlyHitIn) {
        super.dropCustomDeathLoot(serverLevel, source, recentlyHitIn);
        this.spawnAtLocation(serverLevel, new ItemStack((ItemLike)CropcraftModItems.PARSNIPS.get()));
    }

    public SoundEvent getAmbientSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.sniffer.idle"));
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.sniffer.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.sniffer.death"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("DataactionState", ((Integer)this.entityData.get(DATA_actionState)).intValue());
        compound.putString("Datamodel", (String)this.entityData.get(DATA_model));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("DataactionState")) {
            this.entityData.set(DATA_actionState, (Object)compound.getInt("DataactionState"));
        }
        if (compound.contains("Datamodel")) {
            this.entityData.set(DATA_model, (Object)compound.getString("Datamodel"));
        }
    }

    public InteractionResult mobInteract(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.getItemInHand(hand);
        InteractionResult.Success retval = InteractionResult.SUCCESS;
        Item item = itemstack.getItem();
        if (itemstack.getItem() instanceof SpawnEggItem) {
            retval = super.mobInteract(sourceentity, hand);
        } else if (this.level().isClientSide()) {
            retval = this.isTame() && this.isOwnedBy((LivingEntity)sourceentity) || this.isFood(itemstack) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        } else if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)sourceentity)) {
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                    float nutrition = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(nutrition);
                    retval = InteractionResult.SUCCESS;
                } else if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    this.usePlayerItem(sourceentity, hand, itemstack);
                    this.heal(4.0f);
                    retval = InteractionResult.SUCCESS;
                } else {
                    retval = super.mobInteract(sourceentity, hand);
                }
            }
        } else if (this.isFood(itemstack)) {
            this.usePlayerItem(sourceentity, hand, itemstack);
            if (this.random.nextInt(3) == 0 && !EventHooks.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.tame(sourceentity);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            this.setPersistenceRequired();
            retval = InteractionResult.SUCCESS;
        } else {
            retval = super.mobInteract(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.setPersistenceRequired();
            }
        }
        return retval;
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
            this.animationState2.animateWhen(VoraciousParsnipsUsloviieProighryvaniiaProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public void baseTick() {
        super.baseTick();
        VoraciousParsnipsPriObnovlieniiTikaSushchnostiProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        VoraciousParsnipsEntity retval = (VoraciousParsnipsEntity)((EntityType)CropcraftModEntities.VORACIOUS_PARSNIPS.get()).create((Level)serverWorld, EntitySpawnReason.BREEDING);
        retval.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(retval.blockPosition()), EntitySpawnReason.BREEDING, null);
        return retval;
    }

    public boolean isFood(ItemStack stack) {
        return Ingredient.of((ItemLike)((ItemLike)CropcraftModItems.FERTILIZER.get())).test(stack);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 0.25);
        return builder;
    }
}

