/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cropcraft.init;

import net.mcreator.cropcraft.entity.EndermenFloristEntity;
import net.mcreator.cropcraft.entity.FertiliflyEntity;
import net.mcreator.cropcraft.entity.VoraciousCarrotEntity;
import net.mcreator.cropcraft.entity.VoraciousParsnipsEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class CropcraftModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"cropcraft");
    public static final DeferredHolder<EntityType<?>, EntityType<VoraciousCarrotEntity>> VORACIOUS_CARROT = CropcraftModEntities.register("voracious_carrot", EntityType.Builder.of(VoraciousCarrotEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.5f, 1.2f));
    public static final DeferredHolder<EntityType<?>, EntityType<VoraciousParsnipsEntity>> VORACIOUS_PARSNIPS = CropcraftModEntities.register("voracious_parsnips", EntityType.Builder.of(VoraciousParsnipsEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<EndermenFloristEntity>> ENDERMEN_FLORIST = CropcraftModEntities.register("endermen_florist", EntityType.Builder.of(EndermenFloristEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 3.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<FertiliflyEntity>> FERTILIFLY = CropcraftModEntities.register("fertilifly", EntityType.Builder.of(FertiliflyEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.6f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cropcraft", (String)registryname))));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerEntity(Capabilities.ItemHandler.ENTITY, (EntityType)ENDERMEN_FLORIST.get(), (living, context) -> living.getCombinedInventory());
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        VoraciousCarrotEntity.init(event);
        VoraciousParsnipsEntity.init(event);
        EndermenFloristEntity.init(event);
        FertiliflyEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)VORACIOUS_CARROT.get(), VoraciousCarrotEntity.createAttributes().build());
        event.put((EntityType)VORACIOUS_PARSNIPS.get(), VoraciousParsnipsEntity.createAttributes().build());
        event.put((EntityType)ENDERMEN_FLORIST.get(), EndermenFloristEntity.createAttributes().build());
        event.put((EntityType)FERTILIFLY.get(), FertiliflyEntity.createAttributes().build());
    }
}

