/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cropcraft.item;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.mcreator.cropcraft.procedures.LinenBundleTextureProcedure;
import net.mcreator.cropcraft.procedures.LinenBundleZnachieniieSvoistva2Procedure;
import net.mcreator.cropcraft.procedures.LinenBundleZnachieniieSvoistvaProcedure;
import net.mcreator.cropcraft.world.inventory.LinenBundleInterfaceMenu;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LinenBundleItem
extends Item {
    public LinenBundleItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResult use(Level world, final Player entity, final InteractionHand hand) {
        InteractionResult ar = super.use(world, entity, hand);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Linen bundle");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(entity.blockPosition());
                    packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    return new LinenBundleInterfaceMenu(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.writeBlockPos(entity.blockPosition());
                buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
            });
        }
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
        super.inventoryTick(itemstack, world, entity, slot);
        LinenBundleTextureProcedure.execute(itemstack);
    }

    public record ClosedProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<ClosedProperty> MAP_CODEC = MapCodec.unit((Object)new ClosedProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)LinenBundleZnachieniieSvoistva2Procedure.execute(itemStackToRender);
        }

        public MapCodec<ClosedProperty> type() {
            return MAP_CODEC;
        }
    }

    public record OpenProperty() implements RangeSelectItemModelProperty
    {
        public static final MapCodec<OpenProperty> MAP_CODEC = MapCodec.unit((Object)new OpenProperty());

        public float get(ItemStack itemStackToRender, @Nullable ClientLevel clientWorld, @Nullable LivingEntity entity, int seed) {
            return (float)LinenBundleZnachieniieSvoistvaProcedure.execute(itemStackToRender);
        }

        public MapCodec<OpenProperty> type() {
            return MAP_CODEC;
        }
    }
}

