/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cropcraft.block;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.mcreator.cropcraft.block.entity.SprayStationTier1BlockEntity;
import net.mcreator.cropcraft.procedures.SprayStationTier1PriObnovlieniiTikaProcedure;
import net.mcreator.cropcraft.procedures.SprayStationTier1RiedstounVkliuchionProcedure;
import net.mcreator.cropcraft.procedures.SprayStationTier1RiedstounVykliuchienProcedure;
import net.mcreator.cropcraft.world.inventory.SprayStationTier1GUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SprayStationTier1Block
extends Block
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BlockStateProperties.ACTIVE;
    public static final IntegerProperty LEVEL = IntegerProperty.create((String)"level", (int)0, (int)3);

    public SprayStationTier1Block(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.WOOD).sound(SoundType.MUD_BRICKS).strength(1.0f, 2.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false).instrument(NoteBlockInstrument.COW_BELL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)SprayStationTier1Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0), (VoxelShape[])new VoxelShape[]{SprayStationTier1Block.box((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), SprayStationTier1Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), SprayStationTier1Block.box((double)3.25, (double)3.0, (double)3.25, (double)12.75, (double)6.0, (double)12.75), SprayStationTier1Block.box((double)3.25, (double)3.0, (double)3.25, (double)12.75, (double)7.0, (double)12.75), SprayStationTier1Block.box((double)3.25, (double)3.0, (double)3.25, (double)12.75, (double)8.0, (double)12.75), SprayStationTier1Block.box((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)17.0, (double)9.0), SprayStationTier1Block.box((double)6.0, (double)17.0, (double)6.0, (double)10.0, (double)19.0, (double)10.0), SprayStationTier1Block.box((double)3.0, (double)16.75, (double)5.75, (double)7.0, (double)19.25, (double)8.25), SprayStationTier1Block.box((double)3.0, (double)16.75, (double)7.75, (double)7.0, (double)19.25, (double)10.25), SprayStationTier1Block.box((double)7.0, (double)17.5, (double)7.0, (double)9.0, (double)19.5, (double)9.0), SprayStationTier1Block.box((double)9.0, (double)16.75, (double)7.75, (double)13.0, (double)19.25, (double)10.25), SprayStationTier1Block.box((double)9.0, (double)16.75, (double)5.75, (double)13.0, (double)19.25, (double)8.25)});
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ACTIVE, LEVEL});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return true;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 20);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, orientation, moving);
        if (world.getBestNeighborSignal(pos) > 0) {
            SprayStationTier1RiedstounVkliuchionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
        } else {
            SprayStationTier1RiedstounVykliuchienProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
        }
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        SprayStationTier1PriObnovlieniiTikaProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), blockstate);
        world.scheduleTick(pos, (Block)this, 20);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Spray Station Tier 1");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new SprayStationTier1GUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SprayStationTier1BlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof SprayStationTier1BlockEntity) {
                SprayStationTier1BlockEntity be = (SprayStationTier1BlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof SprayStationTier1BlockEntity) {
            SprayStationTier1BlockEntity be = (SprayStationTier1BlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

