/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cropcraft.network;

import net.mcreator.cropcraft.CropcraftMod;
import net.mcreator.cropcraft.procedures.ResultXPProcedureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record GeneticSynthesizerInterfaceSlotMessage(int slotID, int x, int y, int z, int changeType, int meta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GeneticSynthesizerInterfaceSlotMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"cropcraft", (String)"genetic_synthesizer_interface_slots"));
    public static final StreamCodec<RegistryFriendlyByteBuf, GeneticSynthesizerInterfaceSlotMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.slotID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
        buffer.writeInt(message.changeType);
        buffer.writeInt(message.meta);
    }, buffer -> new GeneticSynthesizerInterfaceSlotMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<GeneticSynthesizerInterfaceSlotMessage> type() {
        return TYPE;
    }

    public static void handleData(GeneticSynthesizerInterfaceSlotMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> GeneticSynthesizerInterfaceSlotMessage.handleSlotAction(context.player(), message.slotID, message.changeType, message.meta, message.x, message.y, message.z)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleSlotAction(Player entity, int slot, int changeType, int meta, int x, int y, int z) {
        Level world = entity.level();
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (slot == 2 && changeType == 1) {
            int amount = meta;
            ResultXPProcedureProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CropcraftMod.addNetworkMessage(TYPE, STREAM_CODEC, GeneticSynthesizerInterfaceSlotMessage::handleData);
    }
}

