/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.cropcraft.entity;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.mcreator.cropcraft.init.CropcraftModEntities;
import net.mcreator.cropcraft.init.CropcraftModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class FertiliflyEntity
extends PathfinderMob {
    public final AnimationState animationState0 = new AnimationState();
    private BlockPos targetPlant;
    private int fertilizeTimer;
    private static final int FERTILIZE_TIME = 50;
    private static final int GLOBAL_COOLDOWN_TICKS = 12000;
    private int rechargeTicks = 0;
    private static final int MAX_ALTITUDE_ABOVE_GROUND = 5;
    private final List<BlockPos> fertilizedBlocks = new ArrayList<BlockPos>();

    public FertiliflyEntity(EntityType<FertiliflyEntity> type, Level world) {
        super(type, world);
        this.xpReward = 2;
        this.setNoAi(false);
        this.setPersistenceRequired();
        this.moveControl = new FlyingMoveControl((Mob)this, 10, true);
    }

    protected PathNavigation createNavigation(Level world) {
        return new FlyingPathNavigation((Mob)this, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FertilizePlantsGoal(this, this));
        this.goalSelector.addGoal(1, (Goal)new TemptWithFlowersGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal(this, 0.8, 20){

            protected Vec3 getPosition() {
                double clampedY;
                RandomSource random = FertiliflyEntity.this.getRandom();
                double dir_x = FertiliflyEntity.this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                BlockPos here = FertiliflyEntity.this.blockPosition();
                int groundY = FertiliflyEntity.this.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, here.getX(), here.getZ());
                double dir_y = clampedY = Math.min((double)(groundY + 5), FertiliflyEntity.this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f));
                double dir_z = FertiliflyEntity.this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                return new Vec3(dir_x, dir_y, dir_z);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.5f));
        this.goalSelector.addGoal(5, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
    }

    public void fertilizePlant(BlockPos plantPos) {
        ++this.fertilizeTimer;
        if (this.fertilizeTimer >= 50) {
            this.applyFertilizerEffects(plantPos);
            this.markBlockAsFertilized(plantPos);
            this.rechargeTicks = 12000;
            this.fertilizeTimer = 0;
            this.targetPlant = null;
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.2, 0.0));
        }
    }

    private void markBlockAsFertilized(BlockPos pos) {
        BlockPos immutablePos = pos.immutable();
        if (!this.fertilizedBlocks.contains(immutablePos)) {
            this.fertilizedBlocks.add(immutablePos);
        }
    }

    public boolean isBlockFertilized(BlockPos pos) {
        return this.fertilizedBlocks.contains(pos.immutable());
    }

    private void applyFertilizerEffects(BlockPos plantPos) {
        Level level;
        if (this.level().isClientSide()) {
            for (int i = 0; i < 15; ++i) {
                double px = (double)plantPos.getX() + 0.5 + (this.random.nextDouble() - 0.5) * 3.0;
                double py = (double)plantPos.getY() + 0.5 + (this.random.nextDouble() - 0.5) * 3.0;
                double pz = (double)plantPos.getZ() + 0.5 + (this.random.nextDouble() - 0.5) * 3.0;
                this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, px, py, pz, 0.0, 0.1, 0.0);
            }
        }
        if (!this.level().isClientSide() && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)CropcraftModParticleTypes.FERTILIZER_PARTICLE.get()), (double)plantPos.getX() + 0.5, (double)plantPos.getY() + 0.5, (double)plantPos.getZ() + 0.5, 52, 0.25, 0.25, 0.25, 0.0);
        }
        this.level().playSound(null, plantPos, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.bee.pollinate")), SoundSource.NEUTRAL, 0.8f, 1.0f);
        if (!this.level().isClientSide()) {
            this.setFertilizerNBT(plantPos);
        }
    }

    private void setFertilizerNBT(BlockPos plantPos) {
        BlockEntity blockEntity = this.level().getBlockEntity(plantPos);
        if (blockEntity != null) {
            blockEntity.getPersistentData().putBoolean("fertilizer", true);
            BlockState state = this.level().getBlockState(plantPos);
            Level level = this.level();
            if (level instanceof Level) {
                Level _level = level;
                _level.sendBlockUpdated(plantPos, state, state, 3);
            }
        }
    }

    private void applyFertilizerToPlant(BlockPos plantPos) {
        BlockState currentState = this.level().getBlockState(plantPos);
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)currentState.getBlock()).toString();
        if (blockId.contains("bush")) {
            System.out.println("Fertilifly: \u041a\u0443\u0441\u0442 \u0443\u0434\u043e\u0431\u0440\u0435\u043d \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 " + String.valueOf(plantPos));
        } else {
            this.accelerateVanillaPlantGrowth(plantPos, currentState);
        }
    }

    private void accelerateVanillaPlantGrowth(BlockPos plantPos, BlockState currentState) {
        if (currentState.hasProperty((Property)CropBlock.AGE)) {
            try {
                int currentAge = (Integer)currentState.getValue((Property)CropBlock.AGE);
                int maxAge = 7;
                if (currentAge < maxAge) {
                    int newAge = Math.min(currentAge + 1 + this.random.nextInt(3), maxAge);
                    BlockState newState = (BlockState)currentState.setValue((Property)CropBlock.AGE, (Comparable)Integer.valueOf(newAge));
                    this.level().setBlock(plantPos, newState, 3);
                    System.out.println("Fertilifly: \u0423\u0441\u043a\u043e\u0440\u0435\u043d \u0440\u043e\u0441\u0442 \u0440\u0430\u0441\u0442\u0435\u043d\u0438\u044f \u043d\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0438 " + String.valueOf(plantPos) + " \u0441 \u0432\u043e\u0437\u0440\u0430\u0441\u0442\u0430 " + currentAge + " \u0434\u043e " + newAge);
                }
            }
            catch (Exception e) {
                System.out.println("Fertilifly: \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0443\u0441\u043a\u043e\u0440\u0435\u043d\u0438\u0438 \u0440\u043e\u0441\u0442\u0430: " + e.getMessage());
            }
        }
    }

    public void tick() {
        super.tick();
        if (this.rechargeTicks > 0) {
            --this.rechargeTicks;
        }
        this.enforceAltitudeLimit();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(true, this.tickCount);
        }
    }

    private void enforceAltitudeLimit() {
        BlockPos pos = this.blockPosition();
        int groundY = this.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX(), pos.getZ());
        double maxY = (double)(groundY + 5) + 0.5;
        if (this.getY() > maxY) {
            Vec3 current = this.getDeltaMovement();
            this.setDeltaMovement(current.x, Math.min(current.y, -0.15), current.z);
            if (this.getNavigation().isInProgress()) {
                this.getNavigation().moveTo(this.getX(), maxY, this.getZ(), 1.0);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (itemstack.is(ItemTags.FLOWERS)) {
            Level level;
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            if ((level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, this.getX(), this.getY() + 0.5, this.getZ(), 8, 0.4, 0.4, 0.4, 0.0);
            }
            this.rechargeTicks = 0;
            this.level().playSound(null, this.blockPosition(), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.bee.pollinate")), SoundSource.NEUTRAL, 0.8f, 1.0f);
            return this.level().isClientSide() ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        ListTag blocksList = new ListTag();
        for (BlockPos pos : this.fertilizedBlocks) {
            CompoundTag posTag = new CompoundTag();
            posTag.putInt("x", pos.getX());
            posTag.putInt("y", pos.getY());
            posTag.putInt("z", pos.getZ());
            blocksList.add((Object)posTag);
        }
        compound.put("FertilizedBlocks", (Tag)blocksList);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        Optional blocksListOpt = compound.getList("FertilizedBlocks");
        if (blocksListOpt.isPresent()) {
            ListTag blocksList = (ListTag)blocksListOpt.get();
            this.fertilizedBlocks.clear();
            for (int i = 0; i < blocksList.size(); ++i) {
                Optional posTagOpt = blocksList.getCompound(i);
                if (!posTagOpt.isPresent()) continue;
                CompoundTag posTag = (CompoundTag)posTagOpt.get();
                Optional xOpt = posTag.getInt("x");
                Optional yOpt = posTag.getInt("y");
                Optional zOpt = posTag.getInt("z");
                if (!xOpt.isPresent() || !yOpt.isPresent() || !zOpt.isPresent()) continue;
                int x = (Integer)xOpt.get();
                int y = (Integer)yOpt.get();
                int z = (Integer)zOpt.get();
                BlockPos pos = new BlockPos(x, y, z);
                this.fertilizedBlocks.add(pos.immutable());
            }
        }
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.bee.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"entity.bee.death"));
    }

    public boolean causeFallDamage(double l, float d, DamageSource source) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void setNoGravity(boolean ignored) {
        super.setNoGravity(true);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)CropcraftModEntities.FERTILIFLY.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && world.getRawBrightness(pos, 0) > 8, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 6.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 0.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 24.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.FLYING_SPEED, 0.3);
        return builder;
    }

    public static boolean isBlockFertilizedByFertilifly(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return false;
        }
        return false;
    }

    class FertilizePlantsGoal
    extends Goal {
        private final FertiliflyEntity fertilifly;
        private BlockPos targetPos;
        private int cooldown;

        public FertilizePlantsGoal(FertiliflyEntity this$0, FertiliflyEntity fertilifly) {
            this.fertilifly = fertilifly;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            if (this.fertilifly.rechargeTicks > 0) {
                return false;
            }
            if (this.fertilifly.tickCount % 40 == 0) {
                this.targetPos = this.findNearestPlant();
            }
            return this.targetPos != null;
        }

        public boolean canContinueToUse() {
            return this.targetPos != null && this.isPlantBlock(this.targetPos) && !this.isBlockAlreadyFertilized(this.targetPos) && !this.hasFertilizerNBT(this.targetPos) && this.fertilifly.distanceToSqr(this.targetPos.getX(), this.targetPos.getY(), this.targetPos.getZ()) < 256.0;
        }

        public void start() {
            if (this.targetPos != null) {
                this.fertilifly.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 1.5);
            }
        }

        public void tick() {
            if (this.targetPos != null) {
                this.fertilifly.getLookControl().setLookAt((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5);
                double distanceToTarget = this.fertilifly.distanceToSqr((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5);
                if (distanceToTarget < 1.0) {
                    this.fertilifly.getNavigation().stop();
                    this.fertilifly.setDeltaMovement(Vec3.ZERO);
                    this.fertilifly.fertilizePlant(this.targetPos);
                } else if (distanceToTarget > 100.0) {
                    this.stop();
                } else {
                    if (this.fertilifly.getNavigation().isDone()) {
                        this.fertilifly.getNavigation().moveTo((double)this.targetPos.getX() + 0.5, (double)this.targetPos.getY() + 0.5, (double)this.targetPos.getZ() + 0.5, 1.5);
                    }
                    if (distanceToTarget < 16.0) {
                        Vec3 toCenter = new Vec3((double)this.targetPos.getX() + 0.5 - this.fertilifly.getX(), (double)this.targetPos.getY() + 0.5 - this.fertilifly.getY(), (double)this.targetPos.getZ() + 0.5 - this.fertilifly.getZ()).scale(0.1);
                        this.fertilifly.setDeltaMovement(this.fertilifly.getDeltaMovement().add(toCenter));
                    }
                }
            }
        }

        public void stop() {
            this.targetPos = null;
            this.fertilifly.getNavigation().stop();
            this.fertilifly.fertilizeTimer = 0;
            this.cooldown = 60;
        }

        private BlockPos findNearestPlant() {
            BlockPos currentPos = this.fertilifly.blockPosition();
            int range = 12;
            ArrayList<BlockPos> plantPositions = new ArrayList<BlockPos>();
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos checkPos = currentPos.offset(x, y, z);
                        if (!this.isPlantBlock(checkPos) || this.isBlockAlreadyFertilized(checkPos) || this.hasFertilizerNBT(checkPos)) continue;
                        plantPositions.add(checkPos);
                    }
                }
            }
            BlockPos nearest = null;
            double nearestDistance = Double.MAX_VALUE;
            for (BlockPos pos : plantPositions) {
                double distance = currentPos.distSqr((Vec3i)pos);
                if (!(distance < nearestDistance)) continue;
                nearest = pos;
                nearestDistance = distance;
            }
            return nearest;
        }

        private boolean isPlantBlock(BlockPos pos) {
            BlockState state = this.fertilifly.level().getBlockState(pos);
            String blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
            boolean isTagged = state.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:all_plants"))) || state.is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"minecraft:bush"))) || state.is(BlockTags.CROPS) || state.is(BlockTags.FLOWERS);
            boolean isCustomPlant = blockId.contains("cropcraft:") && (blockId.contains("_bush") || blockId.contains("_crop") || blockId.contains("_stem") || blockId.contains("tea_bush") || blockId.contains("flax_crop") || blockId.contains("coffee_bush") || blockId.contains("parsnips_crops") || blockId.contains("pineapple_bush") || blockId.contains("bell_pepper_bush") || blockId.contains("blueberry_bush") || blockId.contains("cucumber_bush") || blockId.contains("basil_crop") || blockId.contains("jalapeno_bush") || blockId.contains("cotton_crop") || blockId.contains("corn_crop") || blockId.contains("pea_bush") || blockId.contains("rice_crop"));
            return isTagged || isCustomPlant;
        }

        private boolean isCustomPlant(BlockState state) {
            String blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
            return blockId.contains("plant") || blockId.contains("crop") || blockId.contains("stem") || blockId.contains("berry") || blockId.contains("bush") || blockId.contains("sprout") || blockId.contains("sapling");
        }

        private boolean isBlockAlreadyFertilized(BlockPos pos) {
            return this.fertilifly.fertilizedBlocks.contains(pos);
        }

        private boolean hasFertilizerNBT(BlockPos pos) {
            BlockEntity be = this.fertilifly.level().getBlockEntity(pos);
            if (be != null) {
                return be.getPersistentData().getBooleanOr("fertilizer", false);
            }
            return false;
        }
    }

    class TemptWithFlowersGoal
    extends Goal {
        private final FertiliflyEntity mob;
        private Player temptingPlayer;
        private final double speed = 1.25;

        public TemptWithFlowersGoal(FertiliflyEntity this$0, FertiliflyEntity mob) {
            this.mob = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            List players = this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate(10.0));
            for (Player p : players) {
                if (!this.isHoldingFlower(p)) continue;
                this.temptingPlayer = p;
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.temptingPlayer != null && this.temptingPlayer.isAlive() && this.isHoldingFlower(this.temptingPlayer) && this.mob.distanceTo((Entity)this.temptingPlayer) < 16.0f;
        }

        public void stop() {
            this.temptingPlayer = null;
            this.mob.getNavigation().stop();
        }

        public void tick() {
            if (this.temptingPlayer != null) {
                this.mob.getLookControl().setLookAt((Entity)this.temptingPlayer, 30.0f, 30.0f);
                this.mob.getNavigation().moveTo(this.temptingPlayer.getX(), this.temptingPlayer.getY() + 0.5, this.temptingPlayer.getZ(), 1.25);
            }
        }

        private boolean isHoldingFlower(Player p) {
            return p.getMainHandItem().is(ItemTags.FLOWERS) || p.getOffhandItem().is(ItemTags.FLOWERS);
        }
    }
}

