package codes.bruno.mod.bse.gui;

import codes.bruno.mod.bse.BetterSignEditModClient;
import codes.bruno.mod.bse.config.ClientConfig;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import java.io.IOException;

public class ConfigScreen {

    public static class_437 create(class_437 parent) {
        var clientConfig = ClientConfig.getInstance();

        var builder = ConfigBuilder.create()
            .setParentScreen(parent)
            .setTitle(class_2561.method_43471("text.better-sign-edit.config.title"));

        var entryBuilder = builder.entryBuilder();

        var generalCategory = builder.getOrCreateCategory(class_2561.method_30163("General"));

        generalCategory.addEntry(
            entryBuilder.startBooleanToggle(
                    class_2561.method_43471("text.better-sign-edit.config.option.saveChangesWithEscape"),
                    clientConfig.isSaveChangesWithEscape()
                )
                .setDefaultValue(false)
                .setSaveConsumer(saveChangesWithEscape -> {
                    clientConfig.setSaveChangesWithEscape(saveChangesWithEscape);
                    try {
                        clientConfig.saveToFile();
                    } catch (IOException e) {
                        BetterSignEditModClient.LOGGER.error("Couldn't save the client config file", e);
                    }
                })
                .build()
        );

        return builder.build();
    }

}
