package codes.bruno.mod.bse.mixin.client;

import codes.bruno.mod.bse.config.ClientConfig;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Arrays;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_2625;
import net.minecraft.class_7743;

@Mixin(class_7743.class)
public class SignEditScreenMixin {

    private static final ClientConfig clientConfig = ClientConfig.getInstance();

    @Shadow @Final private String[] messages;

    private String[] initialMessages;

    @Inject(
        method = "<init>(Lnet/minecraft/block/entity/SignBlockEntity;ZZLnet/minecraft/text/Text;)V",
        at = @At("TAIL")
    )
    public void bse$init(class_2625 blockEntity, boolean front, boolean filtered, class_2561 title, CallbackInfo ci) {
        if (!clientConfig.isSaveChangesWithEscape()) {
            initialMessages = Arrays.copyOf(messages, messages.length);
        }
    }

    @Inject(
        method = "keyPressed",
        at = @At(
            value = "INVOKE",
            target = "Lnet/minecraft/client/gui/screen/Screen;keyPressed(Lnet/minecraft/client/input/KeyInput;)Z"
        )
    )
    public void bse$keyPressed(class_11908 input, CallbackInfoReturnable<Boolean> cir) {
        if (!clientConfig.isSaveChangesWithEscape() && input.comp_4795() == GLFW.GLFW_KEY_ESCAPE) {
            System.arraycopy(initialMessages, 0, messages, 0, messages.length);
        }
    }

}
