/*
 * Decompiled with CFR 0.152.
 */
package codes.bruno.mod.bse.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public abstract class BaseConfig {
    private static final String BASE_MOD_CONFIG_FOLDER = "better-sign-edit";
    private final Properties properties = new Properties();
    private final Path filePath;

    public BaseConfig(String fileName) {
        this.filePath = Path.of("config", BASE_MOD_CONFIG_FOLDER, fileName);
    }

    public void loadFromFile() throws IOException {
        File file = this.filePath.toFile();
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            try (InputStream is = this.getClass().getResourceAsStream("/default-" + String.valueOf(this.filePath.getFileName()));){
                Files.copy(is, this.filePath, new CopyOption[0]);
            }
        }
        try (BufferedReader br = Files.newBufferedReader(this.filePath, StandardCharsets.UTF_8);){
            this.properties.load(br);
        }
        this.loadProperties(this.properties);
    }

    public void saveToFile() throws IOException {
        this.saveProperties(this.properties);
        try (BufferedWriter bw = Files.newBufferedWriter(this.filePath, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.properties.store(bw, null);
        }
    }

    abstract void loadProperties(Properties var1);

    abstract void saveProperties(Properties var1);
}

