/*
 * Decompiled with CFR 0.152.
 */
package com.codex.realseasons;

import com.codex.realseasons.RealSeasonsSharedData;
import com.codex.realseasons.calendar.RealSeasonsCalendarService;
import com.codex.realseasons.config.RealSeasonsCommonConfig;
import com.codex.realseasons.network.RealSeasonsPackets;
import com.codex.realseasons.server.RealSeasonsSeasonDataProvider;
import com.codex.realseasons.server.RealSeasonsSeasonStateStore;
import com.codex.realseasons.server.RealSeasonsSeasonSynchronizer;
import java.time.Clock;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import sereneseasons.api.season.SeasonHelper;

public final class RealSeasonsModInitializer
implements ModInitializer {
    private static volatile RealSeasonsCommonConfig config;
    private static RealSeasonsSeasonSynchronizer synchronizer;
    private static RealSeasonsSeasonStateStore stateStore;

    public void onInitialize() {
        SeasonHelper.ISeasonDataProvider originalProvider;
        config = RealSeasonsCommonConfig.loadOrCreate();
        stateStore = new RealSeasonsSeasonStateStore();
        RealSeasonsCalendarService calendarService = new RealSeasonsCalendarService(Clock.systemDefaultZone());
        synchronizer = new RealSeasonsSeasonSynchronizer(() -> config, calendarService, stateStore);
        synchronizer.register();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER) {
            PayloadTypeRegistry.playS2C().register(RealSeasonsPackets.DisplayDaysPayload.TYPE, RealSeasonsPackets.DisplayDaysPayload.STREAM_CODEC);
        }
        if ((originalProvider = SeasonHelper.dataProvider) != null) {
            SeasonHelper.dataProvider = new RealSeasonsSeasonDataProvider(stateStore, originalProvider);
        } else {
            RealSeasonsSharedData.LOGGER.warn("SeasonHelper data provider was null during initialization; real-time sync relies on it to propagate to clients.");
        }
        RealSeasonsSharedData.LOGGER.info("Real Serene Seasons ready: hemisphere {}, cadence {}, interpolation {}.", new Object[]{config.useSouthernHemisphere() ? "southern" : "northern", config.cadence(), config.interpolateTimeOfDay() ? "enabled" : "disabled"});
    }

    public static RealSeasonsCommonConfig config() {
        return config;
    }

    public static void reloadConfig(RealSeasonsCommonConfig newConfig) {
        Objects.requireNonNull(newConfig, "newConfig");
        config = newConfig;
        if (synchronizer != null) {
            synchronizer.resetCachedState();
        }
        RealSeasonsSharedData.LOGGER.info("Config updated: hemisphere {}, cadence {}, interpolation {}.", new Object[]{newConfig.useSouthernHemisphere() ? "southern" : "northern", newConfig.cadence(), newConfig.interpolateTimeOfDay() ? "enabled" : "disabled"});
    }
}

