/*
 * Decompiled with CFR 0.152.
 */
package com.codex.realseasons.server;

import com.codex.realseasons.config.RealSeasonsCadence;
import com.codex.realseasons.config.RealSeasonsCommonConfig;
import com.codex.realseasons.network.RealSeasonsPackets;
import java.time.LocalDate;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import sereneseasons.init.ModConfig;

public final class RealSeasonsDisplayLinker {
    private int lastAppliedDays = -1;

    public void maybeApply(MinecraftServer server, RealSeasonsCommonConfig config) {
        int desired = this.desiredDays(config);
        if (desired <= 0) {
            return;
        }
        if (ModConfig.seasons.subSeasonDuration != desired) {
            ModConfig.seasons.subSeasonDuration = desired;
        }
        if (this.lastAppliedDays != desired) {
            this.broadcastDisplayDays(server, desired);
            this.lastAppliedDays = desired;
        }
    }

    private int desiredDays(RealSeasonsCommonConfig config) {
        return switch (config.cadence()) {
            default -> throw new MatchException(null, null);
            case RealSeasonsCadence.MONTH -> LocalDate.now(config.zoneId()).lengthOfMonth();
            case RealSeasonsCadence.WEEK -> 7;
            case RealSeasonsCadence.DAY -> 1;
        };
    }

    private void broadcastDisplayDays(MinecraftServer server, int days) {
        RealSeasonsPackets.DisplayDaysPayload payload = new RealSeasonsPackets.DisplayDaysPayload(days);
        for (class_3222 player : server.method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }
}

