/*
 * Decompiled with CFR 0.152.
 */
package com.codex.realseasons.server;

import com.codex.realseasons.RealSeasonsSharedData;
import com.codex.realseasons.calendar.RealSeasonsCalendarService;
import com.codex.realseasons.config.RealSeasonsCommonConfig;
import com.codex.realseasons.server.RealSeasonsDisplayLinker;
import com.codex.realseasons.server.RealSeasonsSeasonStateStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import sereneseasons.api.SSGameRules;
import sereneseasons.init.ModConfig;
import sereneseasons.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public final class RealSeasonsSeasonSynchronizer {
    private final Supplier<RealSeasonsCommonConfig> configSupplier;
    private final RealSeasonsCalendarService calendarService;
    private final RealSeasonsSeasonStateStore stateStore;
    private final RealSeasonsDisplayLinker displayLinker;
    private final Map<class_5321<class_1937>, Integer> lastBroadcastTicks = new HashMap<class_5321<class_1937>, Integer>();
    private final Set<class_5321<class_1937>> disabledCycleRule = new HashSet<class_5321<class_1937>>();

    public RealSeasonsSeasonSynchronizer(Supplier<RealSeasonsCommonConfig> configSupplier, RealSeasonsCalendarService calendarService, RealSeasonsSeasonStateStore stateStore) {
        this.configSupplier = Objects.requireNonNull(configSupplier, "configSupplier");
        this.calendarService = Objects.requireNonNull(calendarService, "calendarService");
        this.stateStore = Objects.requireNonNull(stateStore, "stateStore");
        this.displayLinker = new RealSeasonsDisplayLinker();
    }

    public void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.syncAll(server, true));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> this.resetCachedState());
        ServerTickEvents.END_SERVER_TICK.register(server -> this.syncAll(server, false));
    }

    public void resetCachedState() {
        this.lastBroadcastTicks.clear();
        this.disabledCycleRule.clear();
    }

    private void syncAll(MinecraftServer server, boolean forceBroadcast) {
        RealSeasonsCommonConfig config = this.configSupplier.get();
        this.displayLinker.maybeApply(server, config);
        RealSeasonsCalendarService.RealSeasonsCalendarSnapshot snapshot = this.calendarService.snapshot(config);
        SeasonTime desiredState = snapshot.seasonTime();
        this.stateStore.update(desiredState);
        for (class_3218 level : server.method_3738()) {
            if (!ModConfig.seasons.isDimensionWhitelisted(level.method_27983())) continue;
            this.disableSeasonCycle(level);
            this.applySeasonState(level, desiredState, forceBroadcast);
        }
    }

    private void disableSeasonCycle(class_3218 level) {
        if (this.disabledCycleRule.contains(level.method_27983())) {
            return;
        }
        class_1928.class_4310 rule = (class_1928.class_4310)level.method_64395().method_20746(SSGameRules.RULE_DOSEASONCYCLE);
        if (rule != null && rule.method_20753()) {
            rule.method_20758(false, level.method_8503());
            RealSeasonsSharedData.LOGGER.info("Disabled doSeasonCycle game rule in {} to allow real-time season syncing.", (Object)level.method_27983().method_29177());
        }
        this.disabledCycleRule.add((class_5321<class_1937>)level.method_27983());
    }

    private void applySeasonState(class_3218 level, SeasonTime desiredState, boolean forceBroadcast) {
        boolean changed;
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData((class_1937)level);
        if (savedData == null) {
            return;
        }
        int targetTick = desiredState.getSeasonCycleTicks();
        boolean bl = changed = savedData.seasonCycleTicks != targetTick;
        if (changed) {
            savedData.seasonCycleTicks = targetTick;
            savedData.method_80();
        }
        SeasonHandler.prevServerSeasonCycleTicks.put(level.method_27983(), targetTick);
        Integer previous = this.lastBroadcastTicks.get(level.method_27983());
        if (forceBroadcast || changed || previous == null || previous != targetTick) {
            SeasonHandler.sendSeasonUpdate((class_1937)level);
            this.lastBroadcastTicks.put((class_5321<class_1937>)level.method_27983(), targetTick);
        }
    }
}

