/*
 * Decompiled with CFR 0.152.
 */
package com.codex.realseasons.config;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.WeekFields;
import java.util.Locale;

public enum RealSeasonsCadence {
    MONTH("One sub-season per real calendar month"){

        @Override
        public Position position(LocalDateTime now, boolean interpolate) {
            int monthIndex;
            int completed = monthIndex = now.getMonthValue() - 1;
            double fraction = interpolate ? RealSeasonsCadence.fractionOfMonth(now.toLocalDate(), now.toLocalTime()) : 0.0;
            return new Position(completed, fraction);
        }
    }
    ,
    WEEK("One sub-season per real week (ISO weeks)"){

        @Override
        public Position position(LocalDateTime now, boolean interpolate, WeekFields wf) {
            int weekIndex = Math.max(1, now.get(wf.weekOfYear()));
            int completed = (weekIndex - 1) % 12;
            double fraction = interpolate ? ((double)(now.getDayOfWeek().getValue() - 1) + RealSeasonsCadence.fractionOfDay(now.toLocalTime())) / 7.0 : 0.0;
            return new Position(completed, RealSeasonsCadence.clamp(fraction));
        }
    }
    ,
    DAY("One sub-season per real day"){

        @Override
        public Position position(LocalDateTime now, boolean interpolate) {
            int dayIndex = (now.getDayOfYear() - 1) % 12;
            double fraction = interpolate ? RealSeasonsCadence.fractionOfDay(now.toLocalTime()) : 0.0;
            return new Position(dayIndex, fraction);
        }
    };

    private static final int SUB_SEASON_COUNT = 12;
    private final String description;

    private RealSeasonsCadence(String description) {
        this.description = description;
    }

    public String description() {
        return this.description;
    }

    public String fileKey() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Position position(LocalDateTime now, boolean interpolate) {
        return this.position(now, interpolate, WeekFields.ISO);
    }

    public Position position(LocalDateTime now, boolean interpolate, WeekFields wf) {
        return this.position(now, interpolate);
    }

    public static RealSeasonsCadence fromString(Object raw, RealSeasonsCadence fallback) {
        if (raw instanceof String) {
            String text = (String)raw;
            String key = text.trim().toUpperCase(Locale.ROOT);
            if ("REAL_YEAR".equals(key)) {
                key = "MONTH";
            }
            if ("REAL_WEEK".equals(key)) {
                key = "WEEK";
            }
            if ("REAL_DAY".equals(key)) {
                key = "DAY";
            }
            try {
                return RealSeasonsCadence.valueOf(key);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return fallback;
    }

    private static double fractionOfDay(LocalTime time) {
        return (double)time.toSecondOfDay() / 86400.0;
    }

    private static double fractionOfMonth(LocalDate date, LocalTime time) {
        int length = date.lengthOfMonth();
        int dayIndex = date.getDayOfMonth() - 1;
        return ((double)dayIndex + RealSeasonsCadence.fractionOfDay(time)) / (double)length;
    }

    private static double clamp(double value) {
        double wrapped = value % 1.0;
        return wrapped < 0.0 ? wrapped + 1.0 : wrapped;
    }

    public record Position(int completedSubSeasons, double fractionInSubSeason) {
    }
}

