/*
 * Decompiled with CFR 0.152.
 */
package com.codex.realseasons.config;

import com.codex.realseasons.config.RealSeasonsCadence;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.DayOfWeek;
import java.time.ZoneId;
import java.util.Locale;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RealSeasonsCommonConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"real-seasons-config");
    private static final String FILE_NAME = "real_serene_seasons.toml";
    private final boolean useSouthernHemisphere;
    private final RealSeasonsCadence cadence;
    private final boolean interpolateTimeOfDay;
    private final String timezoneId;
    private final DayOfWeek weekStartDay;
    private final int weekMinDays;

    private RealSeasonsCommonConfig(boolean useSouthernHemisphere, RealSeasonsCadence cadence, boolean interpolateTimeOfDay, String timezoneId, DayOfWeek weekStartDay, int weekMinDays) {
        this.useSouthernHemisphere = useSouthernHemisphere;
        this.cadence = cadence;
        this.interpolateTimeOfDay = interpolateTimeOfDay;
        this.timezoneId = timezoneId;
        this.weekStartDay = weekStartDay;
        this.weekMinDays = Math.max(1, Math.min(7, weekMinDays));
    }

    public boolean useSouthernHemisphere() {
        return this.useSouthernHemisphere;
    }

    public RealSeasonsCadence cadence() {
        return this.cadence;
    }

    public boolean interpolateTimeOfDay() {
        return this.interpolateTimeOfDay;
    }

    public String timezoneId() {
        return this.timezoneId;
    }

    public ZoneId zoneId() {
        try {
            if (this.timezoneId != null && !this.timezoneId.isBlank()) {
                return ZoneId.of(this.timezoneId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ZoneId.systemDefault();
    }

    public DayOfWeek weekStartDay() {
        return this.weekStartDay;
    }

    public int weekMinDays() {
        return this.weekMinDays;
    }

    public static RealSeasonsCommonConfig loadOrCreate() {
        RealSeasonsCommonConfig realSeasonsCommonConfig;
        block9: {
            RealSeasonsCommonConfig defaults = new RealSeasonsCommonConfig(false, RealSeasonsCadence.MONTH, true, "", DayOfWeek.MONDAY, 4);
            Path path = RealSeasonsCommonConfig.configPath();
            if (!Files.exists(path, new LinkOption[0])) {
                RealSeasonsCommonConfig.writeConfig(path, defaults);
                return defaults;
            }
            CommentedFileConfig file = RealSeasonsCommonConfig.openFile(path);
            try {
                file.load();
                RealSeasonsCommonConfig loaded = RealSeasonsCommonConfig.fromToml((CommentedConfig)file, defaults);
                RealSeasonsCommonConfig.writeToFile(file, loaded);
                realSeasonsCommonConfig = loaded;
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("Failed to load {}: {}", new Object[]{FILE_NAME, t.toString(), t});
                    RealSeasonsCommonConfig.writeConfig(path, defaults);
                    return defaults;
                }
            }
            file.close();
        }
        return realSeasonsCommonConfig;
    }

    public static RealSeasonsCommonConfig overwrite(boolean useSouthernHemisphere, RealSeasonsCadence cadence, boolean interpolateTimeOfDay, String timezoneId, DayOfWeek weekStartDay, int weekMinDays) {
        RealSeasonsCommonConfig updated = new RealSeasonsCommonConfig(useSouthernHemisphere, cadence, interpolateTimeOfDay, timezoneId, weekStartDay, weekMinDays);
        RealSeasonsCommonConfig.writeConfig(RealSeasonsCommonConfig.configPath(), updated);
        return updated;
    }

    private static RealSeasonsCommonConfig fromToml(CommentedConfig config, RealSeasonsCommonConfig defaults) {
        boolean useSouthern = defaults.useSouthernHemisphere;
        Object rawSetting = config.get("use_southern_hemisphere");
        if (rawSetting instanceof Boolean) {
            Boolean bool = (Boolean)rawSetting;
            useSouthern = bool;
        }
        RealSeasonsCadence cadence = defaults.cadence;
        Object rawCadence = config.get("cadence");
        cadence = RealSeasonsCadence.fromString(rawCadence, cadence);
        boolean interpolate = defaults.interpolateTimeOfDay;
        Object rawInterpolation = config.get("interpolate_time_of_day");
        if (rawInterpolation instanceof Boolean) {
            Boolean bool = (Boolean)rawInterpolation;
            interpolate = bool;
        }
        String tz = defaults.timezoneId;
        Object rawTz = config.get("timezone_id");
        if (rawTz instanceof String) {
            String s = (String)rawTz;
            tz = s.trim();
        }
        DayOfWeek weekStart = defaults.weekStartDay;
        Object rawStart = config.get("week_start_day");
        if (rawStart instanceof String) {
            String s = (String)rawStart;
            try {
                weekStart = DayOfWeek.valueOf(s.trim().toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        int minDays = defaults.weekMinDays;
        Object rawMin = config.get("week_min_days");
        if (rawMin instanceof Number) {
            Number n = (Number)rawMin;
            minDays = Math.max(1, Math.min(7, n.intValue()));
        }
        return new RealSeasonsCommonConfig(useSouthern, cadence, interpolate, tz, weekStart, minDays);
    }

    private static void writeConfig(Path path, RealSeasonsCommonConfig config) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config directory for {}", (Object)FILE_NAME, (Object)e);
            return;
        }
        try (CommentedFileConfig file = RealSeasonsCommonConfig.openFile(path);){
            file.load();
            RealSeasonsCommonConfig.writeToFile(file, config);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to write {}: {}", new Object[]{FILE_NAME, t.toString(), t});
        }
    }

    private static CommentedFileConfig openFile(Path path) {
        return (CommentedFileConfig)CommentedFileConfig.builder((Path)path).preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
    }

    private static void writeToFile(CommentedFileConfig file, RealSeasonsCommonConfig config) {
        file.set("#", (Object)"Real Serene Seasons - Config");
        file.set("#1", (Object)"Controls how calendar-based season syncing is interpreted.");
        file.set("use_southern_hemisphere", (Object)config.useSouthernHemisphere);
        file.setComment("use_southern_hemisphere", "If true, invert the calendar to match southern hemisphere seasons.");
        file.set("cadence", (Object)config.cadence.name());
        file.setComment("cadence", "Per-sub-season cadence: MONTH (calendar month), WEEK (7 days), or DAY (24 hours). Full cycle = 12 sub-seasons.");
        file.set("interpolate_time_of_day", (Object)config.interpolateTimeOfDay);
        file.setComment("interpolate_time_of_day", "If true, include the current time of day when mapping the calendar (smoother transitions).");
        file.set("timezone_id", (Object)config.timezoneId);
        file.setComment("timezone_id", "IANA ZoneId (e.g., America/New_York, Europe/Berlin, UTC). Blank = system default.");
        file.set("week_start_day", (Object)config.weekStartDay.name());
        file.setComment("week_start_day", "Only used when cadence=WEEK. First day of week: MONDAY/TUESDAY/.../SUNDAY.");
        file.set("week_min_days", (Object)config.weekMinDays);
        file.setComment("week_min_days", "Only used when cadence=WEEK. Minimum days in first week (1-7). ISO uses 4.");
        file.save();
    }

    private static Path configPath() {
        return FabricLoader.getInstance().getConfigDir().resolve(FILE_NAME);
    }
}

