package com.codex.realseasons;

import com.codex.realseasons.config.RealSeasonsCadence;
import com.codex.realseasons.config.RealSeasonsCommonConfig;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;

/**
 * Builds the Cloth Config screen for Real Serene Seasons when available.
 */
public final class RealSeasonsClientConfigScreenFactory {
    private RealSeasonsClientConfigScreenFactory() {
    }

    public static class_437 create(class_437 parent) {
        RealSeasonsCommonConfig current = RealSeasonsCommonConfig.loadOrCreate();
        final boolean[] useSouthernHemisphere = { current.useSouthernHemisphere() };
        final RealSeasonsCadence[] cadence = { current.cadence() };
        final boolean[] interpolateTimeOfDay = { current.interpolateTimeOfDay() };
        final String[] timezoneId = { current.timezoneId() };
        final java.time.DayOfWeek[] weekStart = { current.weekStartDay() };
        final int[] weekMinDays = { current.weekMinDays() };

        ConfigBuilder builder = ConfigBuilder.create()
                .setParentScreen(parent)
                .setTitle(class_2561.method_43470("Real Serene Seasons"));
        builder.setSavingRunnable(() -> {
            RealSeasonsCommonConfig updated = RealSeasonsCommonConfig.overwrite(
                    useSouthernHemisphere[0],
                    cadence[0],
                    interpolateTimeOfDay[0],
                    timezoneId[0],
                    weekStart[0],
                    weekMinDays[0]
            );
            RealSeasonsModInitializer.reloadConfig(updated);
        });

        ConfigCategory general = builder.getOrCreateCategory(class_2561.method_43470("Calendar"));
        ConfigEntryBuilder entries = builder.entryBuilder();

        general.addEntry(entries.startBooleanToggle(class_2561.method_43470("Use Southern Hemisphere"), useSouthernHemisphere[0])
                .setDefaultValue(false)
                .setTooltip(class_2561.method_43470("Flips season order so January becomes mid summer instead of mid winter."))
                .setSaveConsumer(value -> useSouthernHemisphere[0] = value)
                .build());

        general.addEntry(entries.startEnumSelector(class_2561.method_43470("Cadence (per sub-season)"), RealSeasonsCadence.class, cadence[0])
                .setDefaultValue(RealSeasonsCadence.MONTH)
                .setTooltip(class_2561.method_43470("How long one sub-season lasts in real time: Month, Week, or Day. The full cycle is always 12 sub-seasons."))
                .setSaveConsumer(value -> cadence[0] = value)
                .build());

        general.addEntry(entries.startBooleanToggle(class_2561.method_43470("Interpolate Time Of Day"), interpolateTimeOfDay[0])
                .setDefaultValue(true)
                .setTooltip(class_2561.method_43470("If enabled, transitions happen smoothly throughout each real day."))
                .setSaveConsumer(value -> interpolateTimeOfDay[0] = value)
                .build());

        general.addEntry(entries.startStrField(class_2561.method_43470("Timezone ID"), timezoneId[0])
                .setDefaultValue("")
                .setTooltip(class_2561.method_43470("IANA ZoneId (e.g., America/New_York, Europe/Berlin, UTC). Blank = system default."))
                .setSaveConsumer(value -> timezoneId[0] = value)
                .build());

        general.addEntry(entries.startEnumSelector(class_2561.method_43470("Week Start Day"), java.time.DayOfWeek.class, weekStart[0])
                .setDefaultValue(java.time.DayOfWeek.MONDAY)
                .setTooltip(class_2561.method_43470("Used when cadence=WEEK. First day of week."))
                .setSaveConsumer(value -> weekStart[0] = value)
                .build());

        general.addEntry(entries.startIntField(class_2561.method_43470("Week Min Days (first week)"), weekMinDays[0])
                .setDefaultValue(4)
                .setMin(1)
                .setMax(7)
                .setTooltip(class_2561.method_43470("Used when cadence=WEEK. Minimum days in first ISO week (1-7)."))
                .setSaveConsumer(value -> weekMinDays[0] = Math.max(1, Math.min(7, value)))
                .build());

        return builder.build();
    }
}
