package com.codex.realseasons.server;

import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.SeasonHelper;

import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_6880;

/**
 * Supplies Real Serene Seasons' computed season state while delegating other queries to Serene Seasons.
 */
public final class RealSeasonsSeasonDataProvider implements SeasonHelper.ISeasonDataProvider {
    private final RealSeasonsSeasonStateStore stateStore;
    private final SeasonHelper.ISeasonDataProvider delegate;

    public RealSeasonsSeasonDataProvider(RealSeasonsSeasonStateStore stateStore, SeasonHelper.ISeasonDataProvider delegate) {
        this.stateStore = Objects.requireNonNull(stateStore, "stateStore");
        this.delegate = Objects.requireNonNull(delegate, "delegate");
    }

    @Override
    public ISeasonState getServerSeasonState(class_1937 level) {
        return stateStore.current();
    }

    @Override
    public ISeasonState getClientSeasonState(class_1937 level) {
        // Use our synchronized state on client too to prevent desync
        return stateStore.current();
    }

    @Override
    public boolean usesTropicalSeasons(class_6880<class_1959> biome) {
        return delegate.usesTropicalSeasons(biome);
    }
}
