/*
 * Decompiled with CFR 0.152.
 */
package com.codex.realseasons;

import com.codex.realseasons.RealSeasonsModInitializer;
import com.codex.realseasons.config.RealSeasonsCadence;
import com.codex.realseasons.config.RealSeasonsCommonConfig;
import java.time.DayOfWeek;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public final class RealSeasonsClientConfigScreenFactory {
    private RealSeasonsClientConfigScreenFactory() {
    }

    public static class_437 create(class_437 parent) {
        RealSeasonsCommonConfig current = RealSeasonsCommonConfig.loadOrCreate();
        boolean[] useSouthernHemisphere = new boolean[]{current.useSouthernHemisphere()};
        RealSeasonsCadence[] cadence = new RealSeasonsCadence[]{current.cadence()};
        boolean[] interpolateTimeOfDay = new boolean[]{current.interpolateTimeOfDay()};
        String[] timezoneId = new String[]{current.timezoneId()};
        DayOfWeek[] weekStart = new DayOfWeek[]{current.weekStartDay()};
        int[] weekMinDays = new int[]{current.weekMinDays()};
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((class_2561)class_2561.method_43470((String)"Real Serene Seasons"));
        builder.setSavingRunnable(() -> {
            RealSeasonsCommonConfig updated = RealSeasonsCommonConfig.overwrite(useSouthernHemisphere[0], cadence[0], interpolateTimeOfDay[0], timezoneId[0], weekStart[0], weekMinDays[0]);
            RealSeasonsModInitializer.reloadConfig(updated);
        });
        ConfigCategory general = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)"Calendar"));
        ConfigEntryBuilder entries = builder.entryBuilder();
        general.addEntry((AbstractConfigListEntry)entries.startBooleanToggle((class_2561)class_2561.method_43470((String)"Use Southern Hemisphere"), useSouthernHemisphere[0]).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_43470((String)"Flips season order so January becomes mid summer instead of mid winter.")}).setSaveConsumer(value -> {
            useSouthernHemisphere[0] = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entries.startEnumSelector((class_2561)class_2561.method_43470((String)"Cadence (per sub-season)"), RealSeasonsCadence.class, (Enum)cadence[0]).setDefaultValue((Enum)RealSeasonsCadence.MONTH).setTooltip(new class_2561[]{class_2561.method_43470((String)"How long one sub-season lasts in real time: Month, Week, or Day. The full cycle is always 12 sub-seasons.")}).setSaveConsumer(value -> {
            cadence[0] = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entries.startBooleanToggle((class_2561)class_2561.method_43470((String)"Interpolate Time Of Day"), interpolateTimeOfDay[0]).setDefaultValue(true).setTooltip(new class_2561[]{class_2561.method_43470((String)"If enabled, transitions happen smoothly throughout each real day.")}).setSaveConsumer(value -> {
            interpolateTimeOfDay[0] = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entries.startStrField((class_2561)class_2561.method_43470((String)"Timezone ID"), timezoneId[0]).setDefaultValue("").setTooltip(new class_2561[]{class_2561.method_43470((String)"IANA ZoneId (e.g., America/New_York, Europe/Berlin, UTC). Blank = system default.")}).setSaveConsumer(value -> {
            timezoneId[0] = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entries.startEnumSelector((class_2561)class_2561.method_43470((String)"Week Start Day"), DayOfWeek.class, (Enum)weekStart[0]).setDefaultValue((Enum)DayOfWeek.MONDAY).setTooltip(new class_2561[]{class_2561.method_43470((String)"Used when cadence=WEEK. First day of week.")}).setSaveConsumer(value -> {
            weekStart[0] = value;
        }).build());
        general.addEntry((AbstractConfigListEntry)entries.startIntField((class_2561)class_2561.method_43470((String)"Week Min Days (first week)"), weekMinDays[0]).setDefaultValue(4).setMin(1).setMax(7).setTooltip(new class_2561[]{class_2561.method_43470((String)"Used when cadence=WEEK. Minimum days in first ISO week (1-7).")}).setSaveConsumer(value -> {
            weekMinDays[0] = Math.max(1, Math.min(7, value));
        }).build());
        return builder.build();
    }
}

