/*
 * Decompiled with CFR 0.152.
 */
package net.okipiak.ulterior_motives.client;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.okipiak.ulterior_motives.particle.ModParticles;
import net.okipiak.ulterior_motives.util.ModEnchantments;

public class TrailwatchingTracker {
    private static final Map<class_1657, Deque<TimestampedPos>> historyMap = new HashMap<class_1657, Deque<TimestampedPos>>();
    private static final Map<class_1657, Long> lastParticleMap = new HashMap<class_1657, Long>();
    private static final Map<class_1657, Boolean> leftStepMap = new HashMap<class_1657, Boolean>();
    private static final Map<class_1657, class_243> lastPositionMap = new HashMap<class_1657, class_243>();
    private static boolean wasUsingSpyglass = false;
    private static final long DELAY_MS = 10L;
    private static final long INTERVAL_MS = 250L;

    public static void detectInvisibles(class_310 client) {
        class_638 world = client.field_1687;
        class_746 player = client.field_1724;
        if (world == null || player == null) {
            return;
        }
        boolean isFirstPerson = client.field_1690.method_31044().method_31034();
        boolean isUsingSpyglass = player.method_6115() && player.method_6030().method_31574(class_1802.field_27070);
        int level = class_1890.method_8225((class_1887)ModEnchantments.TRAILWATCHING, (class_1799)player.method_6030());
        if (!(!wasUsingSpyglass || isFirstPerson && isUsingSpyglass && level > 0)) {
            wasUsingSpyglass = false;
            return;
        }
        if (!isFirstPerson || !isUsingSpyglass || level <= 0) {
            return;
        }
        wasUsingSpyglass = true;
        long now = System.currentTimeMillis();
        for (class_1657 otherPlayer : world.method_18456()) {
            TimestampedPos delayed;
            if (otherPlayer == player || !otherPlayer.method_5767() || otherPlayer.method_7325() || otherPlayer.method_5739((class_1297)player) > 32.0f) continue;
            class_243 currentPos = otherPlayer.method_19538();
            class_243 lastPos = lastPositionMap.getOrDefault(otherPlayer, currentPos);
            lastPositionMap.put(otherPlayer, currentPos);
            if (currentPos.method_1025(lastPos) < 4.0E-4) continue;
            historyMap.computeIfAbsent(otherPlayer, p -> new ArrayDeque()).add(new TimestampedPos(now, currentPos));
            Deque<TimestampedPos> queue = historyMap.get(otherPlayer);
            while (!queue.isEmpty() && now - queue.peekFirst().time > 510L) {
                queue.pollFirst();
            }
            long last = lastParticleMap.getOrDefault(otherPlayer, 0L);
            if (now - last < 250L || (delayed = (TimestampedPos)queue.stream().filter(p -> now - p.time >= 10L).findFirst().orElse(null)) == null) continue;
            boolean left = leftStepMap.getOrDefault(otherPlayer, false);
            leftStepMap.put(otherPlayer, !left);
            class_243 pos = delayed.pos;
            double offset = 0.2;
            double dx = left ? -offset : offset;
            class_243 look = otherPlayer.method_5828(1.0f);
            class_243 sideways = look.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
            class_243 footprintPos = pos.method_1019(sideways.method_1021(dx));
            double px = footprintPos.field_1352;
            double py = footprintPos.field_1351 + 0.01;
            double pz = footprintPos.field_1350;
            world.method_8406((class_2394)ModParticles.FOOTPRINT, px, py, pz, 0.0, 0.0, 0.0);
            lastParticleMap.put(otherPlayer, now);
        }
    }

    private static class TimestampedPos {
        final long time;
        final class_243 pos;

        TimestampedPos(long time, class_243 pos) {
            this.time = time;
            this.pos = pos;
        }
    }
}

