/*
 * Decompiled with CFR 0.152.
 */
package me.daxanius.npe.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.daxanius.npe.NoPryingEyes;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

public class NoPryingEyesConfig {
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("npe.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static NoPryingEyesConfig INSTANCE;
    private transient boolean tempSign = false;
    private transient boolean toastHasBeenSent = false;
    public boolean disable_telemetry = true;
    public boolean disable_global_bans = true;
    public boolean disable_profanity_filter = true;
    public boolean server_toasts = true;
    public boolean fake_ban = false;
    public boolean verbose = false;
    public SigningMode signing_mode = SigningMode.NO_KEY;
    public OnDemandWarning onDemandWarning = OnDemandWarning.IF_TOAST_NOT_SENT;
    public ChatIndicatorOptions chat_indicator = new ChatIndicatorOptions();

    public boolean noSign() {
        return this.signing_mode != SigningMode.SIGN && !this.tempSign() || this.noKey();
    }

    public boolean noKey() {
        return this.signing_mode == SigningMode.NO_KEY;
    }

    public boolean onDemand() {
        return this.signing_mode == SigningMode.ON_DEMAND;
    }

    public boolean tempSign() {
        return this.tempSign;
    }

    public void setTempSign(boolean value) {
        this.tempSign = value;
    }

    public boolean toastHasBeenSent() {
        return this.toastHasBeenSent;
    }

    public void setToastHasBeenSent(boolean value) {
        this.toastHasBeenSent = value;
    }

    public static NoPryingEyesConfig getInstance() {
        if (INSTANCE == null) {
            NoPryingEyesConfig.load();
        }
        return INSTANCE;
    }

    public static void setInstance(NoPryingEyesConfig instance) {
        INSTANCE = instance;
    }

    public static void load() {
        NoPryingEyes.LOGGER.info("Loading config");
        INSTANCE = NoPryingEyesConfig.readFile();
        if (INSTANCE == null) {
            INSTANCE = new NoPryingEyesConfig();
            NoPryingEyesConfig.save();
        }
    }

    public static void save() {
        NoPryingEyes.LOGGER.info("Saving config");
        if (INSTANCE == null) {
            INSTANCE = new NoPryingEyesConfig();
        }
        NoPryingEyesConfig.writeFile(INSTANCE);
    }

    @Nullable
    private static NoPryingEyesConfig readFile() {
        NoPryingEyesConfig noPryingEyesConfig;
        block9: {
            if (!Files.isRegularFile(CONFIG_FILE, new LinkOption[0])) {
                return null;
            }
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);
            try {
                noPryingEyesConfig = (NoPryingEyesConfig)GSON.fromJson((Reader)reader, NoPryingEyesConfig.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            reader.close();
        }
        return noPryingEyesConfig;
    }

    private static void writeFile(NoPryingEyesConfig instance) {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
            GSON.toJson((Object)instance, (Appendable)writer);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static enum SigningMode {
        SIGN,
        NO_SIGN,
        NO_KEY,
        ON_DEMAND;

    }

    public static enum OnDemandWarning {
        ALWAYS,
        NEVER,
        IF_TOAST_NOT_SENT;

    }

    public static class ChatIndicatorOptions {
        public boolean hide_red = true;
        public boolean hide_yellow = false;
    }
}

