/*
 * Decompiled with CFR 0.152.
 */
package me.cutebow.client_side_anchors.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import me.cutebow.client_side_anchors.config.ClientSideAnchorsConfig;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4969;
import net.minecraft.class_638;

public class AnchorPredictionManager {
    private static final Map<class_2338, Prediction> PREDICTIONS = new HashMap<class_2338, Prediction>();
    private static int tickCounter = 0;

    public static void handleInteract(class_638 world, class_1268 hand, class_3965 hitResult) {
        class_1799 stack;
        int charges;
        ClientSideAnchorsConfig cfg = ClientSideAnchorsConfig.INSTANCE;
        if (!cfg.enabled) {
            return;
        }
        if (!cfg.instantExplosion) {
            return;
        }
        if (world == null || hitResult == null) {
            return;
        }
        class_2338 pos = hitResult.method_17777();
        if (pos == null || !world.method_22340(pos)) {
            return;
        }
        if (world.method_8597().comp_649()) {
            return;
        }
        class_2680 state = world.method_8320(pos);
        if (!(state.method_26204() instanceof class_4969)) {
            return;
        }
        int n = charges = state.method_28498((class_2769)class_4969.field_23153) ? (Integer)state.method_11654((class_2769)class_4969.field_23153) : 0;
        if (charges <= 0) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_1799 class_17992 = stack = mc.field_1724 != null ? mc.field_1724.method_5998(hand) : class_1799.field_8037;
        if (stack.method_31574(class_1802.field_8801)) {
            return;
        }
        if (cfg.swingHandOnUse && mc.field_1724 != null) {
            mc.field_1724.method_6104(hand);
        }
        AnchorPredictionManager.applyTemporaryAir(world, pos, state);
        if (cfg.hideGlowstoneRing) {
            AnchorPredictionManager.hideGlowstoneRing(world, pos);
        }
        if (cfg.hurtCamFromAnchor && mc.field_1724 != null) {
            mc.field_1724.method_5711((byte)2);
        }
    }

    private static void hideGlowstoneRing(class_638 world, class_2338 center) {
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                class_2338 p;
                class_2680 s;
                if (dx == 0 && dz == 0 || !(s = world.method_8320(p = center.method_10069(dx, 0, dz))).method_27852(class_2246.field_10171)) continue;
                AnchorPredictionManager.applyTemporaryAir(world, p, s);
            }
        }
    }

    private static void applyTemporaryAir(class_638 world, class_2338 pos, class_2680 before) {
        class_2680 predicted = class_2246.field_10124.method_9564();
        world.method_8652(pos, predicted, 0);
        Prediction p = new Prediction();
        p.pos = pos.method_10062();
        p.before = before;
        p.after = predicted;
        p.createdTick = tickCounter;
        PREDICTIONS.put(p.pos, p);
    }

    public static void onServerBlockUpdate(class_638 world, class_2338 pos, class_2680 newState) {
        Prediction p = PREDICTIONS.get(pos);
        if (p == null) {
            return;
        }
        if (!newState.equals((Object)p.after)) {
            world.method_8652(pos, newState, 0);
        }
        PREDICTIONS.remove(pos);
    }

    public static boolean isSuppressed(class_2338 pos) {
        Prediction p = PREDICTIONS.get(pos);
        if (p == null) {
            return false;
        }
        int age = tickCounter - p.createdTick;
        return age <= 40;
    }

    public static void tick() {
        ++tickCounter;
        if (PREDICTIONS.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world == null) {
            PREDICTIONS.clear();
            return;
        }
        Iterator<Map.Entry<class_2338, Prediction>> it = PREDICTIONS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_2338, Prediction> e = it.next();
            Prediction p = e.getValue();
            if (p.pos == null || !world.method_22340(p.pos)) {
                it.remove();
                continue;
            }
            if (tickCounter - p.createdTick <= 40) continue;
            class_2680 current = world.method_8320(p.pos);
            if (current.equals((Object)p.after)) {
                world.method_8652(p.pos, p.before, 0);
            }
            it.remove();
        }
    }

    private static class Prediction {
        class_2338 pos;
        class_2680 before;
        class_2680 after;
        int createdTick;

        private Prediction() {
        }
    }
}

