/*
 * Decompiled with CFR 0.152.
 */
package net.jeremiah.sculkdecor.utils;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.authlib.yggdrasil.YggdrasilMinecraftSessionService;
import com.mojang.authlib.yggdrasil.response.MinecraftProfilePropertiesResponse;
import java.net.URL;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.jeremiah.sculkdecor.SculkmansDecor;
import net.jeremiah.sculkdecor.mixin.YggdrasilAuthenticationServiceAccessor;
import net.jeremiah.sculkdecor.utils.MinecraftProfileResponse;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

public class PlayerUtils {
    public static UUID getPlayerUUID(@NotNull class_1657 plr) {
        return plr.method_7334().getId();
    }

    public static boolean playerMatch(class_1657 plr, UUID uuid) {
        return PlayerUtils.getPlayerUUID(plr).equals(uuid);
    }

    public static boolean playerMatch(UUID uuid, class_1657 plr) {
        return PlayerUtils.playerMatch(plr, uuid);
    }

    public static boolean playerMatch(class_1657 plr, GameProfile gp) {
        return PlayerUtils.playerMatch(plr, gp != null ? gp.getId() : null);
    }

    public static boolean playerMatch(GameProfile gp, class_1657 plr) {
        return PlayerUtils.playerMatch(plr, gp);
    }

    public static boolean playerMatch(class_1657 plr, class_1657 plr2) {
        return PlayerUtils.playerMatch(plr, plr2 != null ? plr2.method_7334() : null);
    }

    @Environment(value=EnvType.CLIENT)
    public static GameProfile fillGameProfile(GameProfile gp) {
        if (gp.isComplete()) {
            return gp;
        }
        YggdrasilAuthenticationService auth = ((YggdrasilMinecraftSessionService)class_310.method_1551().method_1495()).getAuthenticationService();
        if (gp.getId() == null) {
            gp = new GameProfile(PlayerUtils.getUserUUID(gp.getName()), gp.getName());
        } else if (gp.getName() == null) {
            try {
                URL url = HttpAuthenticationService.constantURL((String)("https://sessionserver.mojang.com/session/minecraft/profile/" + gp.getId().toString()));
                MinecraftProfilePropertiesResponse resp = ((YggdrasilAuthenticationServiceAccessor)auth).sculkdecor$makeRequest(url, null, MinecraftProfilePropertiesResponse.class, null);
                gp = new GameProfile(resp.getId(), resp.getName());
                gp.getProperties().putAll((Multimap)resp.getProperties());
            }
            catch (AuthenticationException e) {
                SculkmansDecor.LOGGER.error("Couldn't retreive user game profile");
                return null;
            }
        }
        gp = class_310.method_1551().method_1495().fillProfileProperties(gp, false);
        return gp;
    }

    private static MinecraftProfileResponse getUserProfile(YggdrasilAuthenticationService auth, URL url) {
        try {
            return ((YggdrasilAuthenticationServiceAccessor)auth).sculkdecor$makeRequest(url, null, MinecraftProfileResponse.class, null);
        }
        catch (AuthenticationException e) {
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static UUID getUserUUID(String username) {
        YggdrasilAuthenticationService auth = ((YggdrasilMinecraftSessionService)class_310.method_1551().method_1495()).getAuthenticationService();
        MinecraftProfileResponse resp = PlayerUtils.getUserProfile(auth, HttpAuthenticationService.constantURL((String)("https://api.mojang.com/users/profiles/minecraft/" + username)));
        if (resp == null) {
            return null;
        }
        return resp.getId();
    }
}

