/*
 * Decompiled with CFR 0.152.
 */
package net.jeremiah.sculkdecor.entity;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.jeremiah.sculkdecor.SculkmansDecor;
import net.jeremiah.sculkdecor.registry.ModBlockEntityTypes;
import net.jeremiah.sculkdecor.utils.SonicBoomUtils;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public final class SonicBoomGeneratorBlockEntity
extends class_2586 {
    public static final class_2960 NETWORK_CHANNEL = SculkmansDecor.id("sonic_boom_generator");
    private static final int RANGE = 15;
    private static final float COOLDOWN = 15.0f;
    private boolean isCharging = false;
    private int chargeTicks = 0;
    private static final int CHARGE_DURATION = 40;
    private final Set<GameProfile> ignored = new HashSet<GameProfile>();
    private GameProfile owner = null;
    private int cooldown = 0;

    public SonicBoomGeneratorBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.SONIC_BOOM_GENERATOR, pos, state);
    }

    public void method_5431() {
        assert (this.field_11863 != null);
        this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        super.method_5431();
    }

    protected void method_11007(class_2487 nbt) {
        nbt.method_10569("Cooldown", this.cooldown);
        if (this.owner != null) {
            class_2487 nbtOwner = new class_2487();
            class_2512.method_10684((class_2487)nbtOwner, (GameProfile)this.owner);
            nbt.method_10566("Owner", (class_2520)nbtOwner);
        }
        class_2499 nbtIgnored = new class_2499();
        for (GameProfile gp : this.ignored) {
            class_2487 nbtGp = new class_2487();
            class_2512.method_10684((class_2487)nbtGp, (GameProfile)gp);
            nbtIgnored.add((Object)nbtGp);
        }
        nbt.method_10566("Ignored", (class_2520)nbtIgnored);
    }

    public void method_11014(class_2487 nbt) {
        this.cooldown = nbt.method_10550("Cooldown");
        this.owner = null;
        this.ignored.clear();
        class_2487 nbtOwner = nbt.method_10562("Owner");
        if (nbtOwner != null) {
            this.owner = class_2512.method_10683((class_2487)nbtOwner);
        }
        class_2499 nbtIgnored = nbt.method_10554("Ignored", 10);
        for (class_2520 elem : nbtIgnored) {
            this.ignored.add(class_2512.method_10683((class_2487)((class_2487)elem)));
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.method_8608() || this.owner == null) {
            return;
        }
        if (this.cooldown != 0) {
            --this.cooldown;
            return;
        }
        class_1657 plr = world.method_8604((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 15.0, e -> e.method_5863() && !e.method_7325() && !((class_1657)e).method_31549().field_7477 && !this.canInteract(((class_1657)e).method_7334()));
        if (plr == null) {
            return;
        }
        if (!this.isCharging) {
            this.isCharging = true;
            this.chargeTicks = 0;
            world.method_8396(null, pos, class_3417.field_38831, class_3419.field_15250, 1.0f, 1.0f);
            return;
        }
        ++this.chargeTicks;
        if (this.chargeTicks < 40) {
            if (this.chargeTicks % 10 == 0) {
                // empty if block
            }
            return;
        }
        class_243 origin = pos.method_46558();
        SonicBoomUtils.create((class_3218)world, origin, (class_1309)plr, plr.method_19538().method_1020(origin));
        this.isCharging = false;
        this.chargeTicks = 0;
        this.cooldown = 300;
    }

    public void addIgnoredPlayer(GameProfile plr) {
        this.ignored.add(plr);
        this.method_5431();
        assert (this.field_11863 != null);
    }

    public void removeIgnoredPlayer(GameProfile plr) {
        this.ignored.remove(plr);
        this.method_5431();
        assert (this.field_11863 != null);
    }

    public boolean canInteract(GameProfile gp) {
        if (this.owner == null || this.owner.equals((Object)gp)) {
            return true;
        }
        for (GameProfile ignored : this.ignored) {
            if (!ignored.equals((Object)gp)) continue;
            return true;
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public void addIgnoredPlayerClient(GameProfile plr) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(0);
        buf.method_10807(this.field_11867);
        buf.method_43616(plr);
        ClientPlayNetworking.send((class_2960)NETWORK_CHANNEL, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public void removeIgnoredPlayerClient(GameProfile plr) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(1);
        buf.method_10807(this.field_11867);
        buf.method_43616(plr);
        ClientPlayNetworking.send((class_2960)NETWORK_CHANNEL, (class_2540)buf);
    }

    public Set<GameProfile> getIgnoredPlayers() {
        return ImmutableSet.copyOf(this.ignored);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(GameProfile gp) {
        this.owner = gp;
        this.method_5431();
    }
}

