/*
 * Decompiled with CFR 0.152.
 */
package net.jeremiah.sculkdecor.utils;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;

public class RaycastUtils {
    public static <T extends class_1297> RaycastResult<T> spherecast(List<T> entities, class_243 origin, class_243 end, double maxDist) {
        class_1297 closest = null;
        double closestDist = Double.POSITIVE_INFINITY;
        for (class_1297 entity : entities) {
            double line_dist = RaycastUtils.segmentPointDist(origin, end, entity.method_19538());
            double direct_dist = entity.method_19538().method_1020(origin).method_1033();
            if (!(line_dist <= maxDist) || !(direct_dist <= closestDist)) continue;
            closest = entity;
            closestDist = direct_dist;
        }
        return new RaycastResult<Object>(closest != null, closest);
    }

    private static double segmentPointDist(class_243 a, class_243 b, class_243 c) {
        class_243 ab = b.method_1020(a);
        class_243 ac = c.method_1020(a);
        double t = Math.max(0.0, Math.min(1.0, ac.method_1026(ab) / ab.method_1027()));
        class_243 projection = a.method_1019(ab.method_1021(t));
        return c.method_1022(projection);
    }

    public record RaycastResult<T>(boolean hit, @Nullable(value="hit=false") @Nullable(value="hit=false") T result) {
    }
}

