/*
 * Decompiled with CFR 0.152.
 */
package net.jeremiah.sculkdecor.gui;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.jeremiah.sculkdecor.SculkmansDecor;
import net.jeremiah.sculkdecor.entity.SonicBoomGeneratorBlockEntity;
import net.jeremiah.sculkdecor.gui.SonicBoomAddPlayerScreen;
import net.minecraft.class_1071;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_7532;
import net.minecraft.class_7919;

public final class SonicBoomScreen
extends class_437 {
    private static final class_2561 TITLE = class_2561.method_43471((String)"block.sculkdecor.sonic_boom_generator");
    private static final class_2960 BACKGROUND = SculkmansDecor.id("textures/gui/sonic_boom_gen.png");
    private static final int GUI_WIDTH = 236;
    private static final int HEADER_SIZE = 16;
    private static final int FOOTER_SIZE = 32;
    private static final int UNIT_SIZE = 18;
    private static final int CELL_HEIGHT = 36;
    private static final int SCROLL_MULTIPLIER = 6;
    private final List<GameProfile> players = new ArrayList<GameProfile>();
    private final class_2338 pos;
    private SonicBoomGeneratorBlockEntity entity;
    private int guiLeft = 0;
    private int guiTop = 0;
    private int ySize = 0;
    private int units = 0;
    private int scroll = 0;
    private int maxScroll = 0;
    private class_1071 skinProvider;

    public SonicBoomScreen(class_2338 pos) {
        super(TITLE);
        this.pos = pos;
    }

    protected void method_25426() {
        assert (this.field_22787 != null && this.field_22787.field_1687 != null);
        this.entity = (SonicBoomGeneratorBlockEntity)this.field_22787.field_1687.method_8321(this.pos);
        if (this.entity == null) {
            this.method_25419();
            return;
        }
        int minUnits = class_3532.method_15386((float)2.2222223f);
        this.guiLeft = (this.field_22789 - 236) / 2 + 2;
        this.guiTop = 32;
        this.units = Math.max(minUnits, (this.field_22790 - 16 - 32 - 64) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        int buttonY = this.guiTop + this.ySize - 20 - 7;
        int buttonSize = 20;
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.sculkdecor.sonic_boom_generator.add_button"), this::addPlayer).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.sculkdecor.sonic_boom_generator.add_button.tooltip"))).method_46433(this.guiLeft + 236 - 107, buttonY).method_46437(100, buttonSize).method_46431());
        this.players.clear();
        this.players.addAll(this.entity.getIgnoredPlayers());
        this.skinProvider = this.field_22787.method_1582();
        this.maxScroll = Math.max(0, this.players.size() - this.units) * 3;
    }

    private void addPlayer(class_4185 btn) {
        assert (this.field_22787 != null);
        this.field_22787.method_1507((class_437)new SonicBoomAddPlayerScreen(this));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int i;
        this.players.clear();
        this.players.addAll(this.entity.getIgnoredPlayers());
        int scrollOffset = this.scroll * 6;
        int nbPlayer = this.players.size();
        this.method_25420(context);
        for (i = 0; i < this.units; ++i) {
            int y = this.guiTop + 16 + 18 * i;
            context.method_25302(BACKGROUND, this.guiLeft, y, 0, 16, 236, 18);
        }
        for (i = 0; i < nbPlayer; ++i) {
            GameProfile plr = this.players.get(i);
            int x = this.guiLeft + 9;
            int y = this.guiTop + 16 + 18 * i + 1 - scrollOffset;
            if (y + 18 <= this.guiTop + 16 + 1 || y > this.guiTop + this.ySize - 32) continue;
            if (mouseX > this.guiLeft + 7 && mouseX < this.guiLeft + 236 - 7 && mouseY > y && mouseY < y + 18) {
                context.method_25294(this.guiLeft + 7, y, this.guiLeft + 236 - 8, y + 18, -1996488705);
            }
            class_7532.method_44443((class_332)context, (class_2960)this.skinProvider.method_44705(plr), (int)x, (int)y, (int)16);
            String string = plr.getName();
            Objects.requireNonNull(this.field_22793);
            context.method_51433(this.field_22793, string, x + 18, y + 9 / 2, -3355444, false);
        }
        context.method_25302(BACKGROUND, this.guiLeft, this.guiTop, 0, 0, 236, 16);
        int titleWidth = this.field_22793.method_27525((class_5348)TITLE);
        int n = (this.field_22789 - titleWidth) / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_51439(this.field_22793, TITLE, n, this.guiTop + 9 / 2, -12303292, false);
        context.method_25302(BACKGROUND, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, 236, 32);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private GameProfile getHoveredGameProfile(int mouseX, int mouseY) {
        if (mouseX < this.guiLeft + 7 || mouseX > this.guiLeft + 236 - 7 || mouseY < this.guiTop + 16 || mouseY > this.guiTop + this.ySize - 32) {
            return null;
        }
        int index = class_3532.method_15375((float)((float)(mouseY += this.scroll * 6 - this.guiTop - 16) / 18.0f));
        if (index < this.players.size()) {
            return this.players.remove(index);
        }
        return null;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (super.method_25401(mouseX, mouseY, amount)) {
            return true;
        }
        this.scroll -= (int)amount;
        if (this.scroll >= 0 && this.scroll <= this.maxScroll) {
            return false;
        }
        this.scroll = class_3532.method_15340((int)this.scroll, (int)0, (int)this.maxScroll);
        return true;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        GameProfile gp;
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0 && (gp = this.getHoveredGameProfile((int)mouseX, (int)mouseY)) != null) {
            this.entity.removeIgnoredPlayerClient(gp);
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }

    public void addIgnoredPlayer(GameProfile gp) {
        this.entity.addIgnoredPlayerClient(gp);
        this.players.add(gp);
    }
}

