/*
 * Decompiled with CFR 0.152.
 */
package winlyps.accessShulker;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R&\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lwinlyps/accessShulker/AccessShulker;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "openShulkerBoxes", "", "Ljava/util/UUID;", "Lkotlin/Pair;", "Lorg/bukkit/inventory/ItemStack;", "", "shulkerDataKey", "Lorg/bukkit/NamespacedKey;", "onEnable", "", "onDisable", "onPlayerInteract", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onInventoryClose", "Lorg/bukkit/event/inventory/InventoryCloseEvent;", "saveShulkerContents", "item", "inventory", "Lorg/bukkit/inventory/Inventory;", "loadShulkerContents", "isShulkerBox", "", "material", "Lorg/bukkit/Material;", "AccessShulker"})
public final class AccessShulker
extends JavaPlugin
implements Listener {
    @NotNull
    private final Map<UUID, Pair<ItemStack, Integer>> openShulkerBoxes = new LinkedHashMap();
    private NamespacedKey shulkerDataKey;

    public void onEnable() {
        this.shulkerDataKey = new NamespacedKey((Plugin)this, "shulker_contents");
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("AccessShulker plugin enabled!");
    }

    public void onDisable() {
        this.getLogger().info("AccessShulker plugin disabled!");
    }

    @EventHandler
    public final void onPlayerInteract(@NotNull PlayerInteractEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        ItemStack itemStack = player2.getInventory().getItemInMainHand();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInMainHand(...)");
        ItemStack itemInHand = itemStack;
        Material material = itemInHand.getType();
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
        if (!this.isShulkerBox(material)) {
            return;
        }
        event.setCancelled(true);
        this.openShulkerBoxes.put(player2.getUniqueId(), (Pair<ItemStack, Integer>)new Pair((Object)itemInHand.clone(), (Object)player2.getInventory().getHeldItemSlot()));
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)"Shulker Box");
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"createInventory(...)");
        Inventory inventory2 = inventory;
        this.loadShulkerContents(itemInHand, inventory2);
        player2.openInventory(inventory2);
    }

    @EventHandler
    public final void onInventoryClose(@NotNull InventoryCloseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Pair<ItemStack, Integer> pair = event.getPlayer();
        Player player = pair instanceof Player ? (Player)pair : null;
        if (player == null) {
            return;
        }
        Player player2 = player;
        UUID uUID = player2.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUniqueId(...)");
        UUID playerId = uUID;
        Pair<ItemStack, Integer> pair2 = this.openShulkerBoxes.remove(playerId);
        if (pair2 == null) {
            return;
        }
        pair = pair2;
        ItemStack originalItem = (ItemStack)pair.component1();
        int slot = ((Number)pair.component2()).intValue();
        if (Intrinsics.areEqual((Object)event.getView().getTitle(), (Object)"Shulker Box")) {
            ItemStack itemStack = originalItem.clone();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"clone(...)");
            ItemStack newItem = itemStack;
            Inventory inventory = event.getInventory();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"getInventory(...)");
            this.saveShulkerContents(newItem, inventory);
            player2.getInventory().setItem(slot, newItem);
        }
    }

    private final void saveShulkerContents(ItemStack item, Inventory inventory) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ItemMeta meta = itemMeta;
        ItemStack[] itemStackArray = inventory.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
        ItemStack[] contents = itemStackArray;
        List contentsData = new ArrayList();
        int n = contents.length;
        for (int i = 0; i < n; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null || itemStack.getType() == Material.AIR) continue;
            String itemData = i + ":" + itemStack.getType().name() + ":" + itemStack.getAmount();
            contentsData.add(itemData);
        }
        String dataString = CollectionsKt.joinToString$default((Iterable)contentsData, (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
        PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
        NamespacedKey namespacedKey = this.shulkerDataKey;
        if (namespacedKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shulkerDataKey");
            namespacedKey = null;
        }
        persistentDataContainer.set(namespacedKey, PersistentDataType.STRING, (Object)dataString);
        if (meta instanceof BlockStateMeta) {
            BlockState blockState = ((BlockStateMeta)meta).getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            BlockState blockState2 = blockState;
            if (blockState2 instanceof ShulkerBox) {
                ((ShulkerBox)blockState2).getInventory().clear();
                int n2 = contents.length;
                for (int i = 0; i < n2; ++i) {
                    ItemStack itemStack = contents[i];
                    if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                    ((ShulkerBox)blockState2).getInventory().setItem(i, itemStack.clone());
                }
                blockState2.update();
                ((BlockStateMeta)meta).setBlockState(blockState2);
            }
        }
        item.setItemMeta(meta);
    }

    private final void loadShulkerContents(ItemStack item, Inventory inventory) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta == null) {
            return;
        }
        ItemMeta meta = itemMeta;
        boolean loadedFromVanilla = false;
        if (meta instanceof BlockStateMeta) {
            BlockState blockState = ((BlockStateMeta)meta).getBlockState();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            BlockState blockState2 = blockState;
            if (blockState2 instanceof ShulkerBox) {
                ItemStack[] itemStackArray = ((ShulkerBox)blockState2).getInventory().getContents();
                Intrinsics.checkNotNullExpressionValue((Object)itemStackArray, (String)"getContents(...)");
                ItemStack[] vanillaContents = itemStackArray;
                int n = vanillaContents.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack itemStack = vanillaContents[i];
                    if (itemStack == null || itemStack.getType() == Material.AIR) continue;
                    inventory.setItem(i, itemStack.clone());
                    loadedFromVanilla = true;
                }
            }
        }
        if (!loadedFromVanilla) {
            String dataString;
            PersistentDataContainer persistentDataContainer = meta.getPersistentDataContainer();
            NamespacedKey namespacedKey = this.shulkerDataKey;
            if (namespacedKey == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"shulkerDataKey");
                namespacedKey = null;
            }
            if ((dataString = (String)persistentDataContainer.get(namespacedKey, PersistentDataType.STRING)) != null && ((CharSequence)dataString).length() > 0) {
                String[] stringArray = new String[]{";"};
                List contentsData = StringsKt.split$default((CharSequence)dataString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                for (String itemData : contentsData) {
                    String[] stringArray2;
                    List parts;
                    if (!(((CharSequence)itemData).length() > 0) || (parts = StringsKt.split$default((CharSequence)itemData, (String[])(stringArray2 = new String[]{":"}), (boolean)false, (int)0, (int)6, null)).size() < 3) continue;
                    try {
                        int slot = Integer.parseInt((String)parts.get(0));
                        Material material = Material.valueOf((String)((String)parts.get(1)));
                        int amount = Integer.parseInt((String)parts.get(2));
                        ItemStack itemStack = new ItemStack(material, amount);
                        inventory.setItem(slot, itemStack);
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Failed to load item data: " + itemData);
                    }
                }
            }
        }
    }

    private final boolean isShulkerBox(Material material) {
        return switch (WhenMappings.$EnumSwitchMapping$0[material.ordinal()]) {
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> true;
            default -> false;
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Material.values().length];
            try {
                nArray[Material.SHULKER_BOX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.WHITE_SHULKER_BOX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.ORANGE_SHULKER_BOX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.MAGENTA_SHULKER_BOX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.LIGHT_BLUE_SHULKER_BOX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.YELLOW_SHULKER_BOX.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.LIME_SHULKER_BOX.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.PINK_SHULKER_BOX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.GRAY_SHULKER_BOX.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.LIGHT_GRAY_SHULKER_BOX.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.CYAN_SHULKER_BOX.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.PURPLE_SHULKER_BOX.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.BLUE_SHULKER_BOX.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.BROWN_SHULKER_BOX.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.GREEN_SHULKER_BOX.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.RED_SHULKER_BOX.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Material.BLACK_SHULKER_BOX.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

