/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.self_sustainable.block;

import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3920;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_8786;
import org.btwr.self_sustainable.block.entity.VariableCampfireBE;
import org.btwr.self_sustainable.block.interfaces.IVariableCampfireBlock;
import org.btwr.self_sustainable.block.interfaces.Ignitable;
import org.btwr.self_sustainable.block.utils.CampfireState;
import org.btwr.self_sustainable.tag.ModTags;
import org.jetbrains.annotations.NotNull;

public class CampfireBlockMixinManager
implements Ignitable,
IVariableCampfireBlock {
    private static final CampfireBlockMixinManager instance = new CampfireBlockMixinManager();

    private CampfireBlockMixinManager() {
    }

    public static CampfireBlockMixinManager getInstance() {
        return instance;
    }

    public class_1269 onUse(class_2680 state, @NotNull class_1937 world, class_2338 pos, @NotNull class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 heldStack = player.method_5998(hand);
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof VariableCampfireBE) {
            VariableCampfireBE campfireBE = (VariableCampfireBE)blockEntity;
            if (heldStack.method_7909() instanceof class_1821 && (Integer)state.method_11654((class_2769)FIRE_LEVEL) > 0) {
                if (!world.field_9236) {
                    campfireBE.changeFireLevel(world, 0);
                }
                Ignitable.playExtinguishSound(world, pos, false);
                return class_1269.field_5812;
            }
            if (!this.getHasSpit((class_1936)world, pos)) {
                if (heldStack.method_31574(class_1802.field_8600)) {
                    this.setHasSpit(world, state, pos, true);
                    heldStack.method_7934(1);
                    return class_1269.field_5812;
                }
            } else {
                Map fuelMap = class_2609.method_11196();
                if (!this.getCookStack(campfireBE).method_7960() && (heldStack.method_7960() || !this.isIgnitableItem(heldStack) && !fuelMap.containsKey(heldStack.method_7909()))) {
                    campfireBE.retrieveItem(world, campfireBE, player);
                    this.playGetItemSound(world, pos, player);
                    return class_1269.field_5812;
                }
                if (heldStack.method_7960() && this.getCookStack(campfireBE).method_7960()) {
                    this.setHasSpit(world, state, pos, false);
                    player.method_7270(new class_1799((class_1935)class_1802.field_8600));
                    this.playGetItemSound(world, pos, player);
                    return class_1269.field_5812;
                }
                Optional<class_8786<class_3920>> optional = campfireBE.getRecipeFor(heldStack);
                if (optional.isPresent() && this.getCookStack(campfireBE).method_7960()) {
                    campfireBE.addItem((class_1297)player, player.method_31549().field_7477 ? heldStack.method_7972() : heldStack, ((class_3920)optional.get().comp_1933()).method_8167());
                    return class_1269.field_5812;
                }
            }
            if ((Integer)state.method_11654((class_2769)FIRE_LEVEL) > 0 || this.getFuelState((class_1936)world, pos) == CampfireState.SMOULDERING) {
                class_1747 blockItem;
                int itemBurnTime = this.getItemFuelTime(heldStack);
                class_1792 class_17922 = heldStack.method_7909();
                if (class_17922 instanceof class_1747 && (blockItem = (class_1747)class_17922).method_7711().method_9564().method_26164(class_3481.field_15475)) {
                    return class_1269.field_5811;
                }
                if (heldStack.method_7909().btwr$getCanBeFedDirectlyIntoCampfire(heldStack)) {
                    if (!world.field_9236) {
                        Ignitable.playLitFX(world, pos);
                        campfireBE.addBurnTime(state, itemBurnTime);
                    }
                    heldStack.method_7934(1);
                    return class_1269.field_5812;
                }
            }
        }
        return class_1269.field_5811;
    }

    private boolean isIgnitableItem(class_1799 stack) {
        return stack.method_31573(ModTags.Items.DIRECT_IGNITERS) || stack.method_31573(ModTags.Items.PRIMITIVE_FIRESTARTERS) || stack.method_7909() == class_1802.field_8884;
    }

    public int getItemFuelTime(class_1799 fuel) {
        if (fuel.method_7960()) {
            return 0;
        }
        class_1792 item = fuel.method_7909();
        return class_2609.method_11196().getOrDefault(item, 0);
    }

    private CampfireState getFuelState(class_1936 blockAccess, class_2338 pos) {
        return this.getFuelState(blockAccess.method_8320(pos));
    }

    private CampfireState getFuelState(class_2680 state) {
        return (CampfireState)((Object)state.method_11654((class_2769)FUEL_STATE));
    }

    private class_1799 getCookStack(VariableCampfireBE campfireBE) {
        return (class_1799)campfireBE.getItemsBeingCooked().getFirst();
    }

    public class_265 setCustomShapes(class_2680 state) {
        if (!((Boolean)state.method_11654((class_2769)HAS_SPIT)).booleanValue()) {
            return SHAPE;
        }
        return SHAPE_WITH_SPIT;
    }

    public void appendCustomProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LIT, FUEL_STATE, FIRE_LEVEL, HAS_SPIT, class_3922.field_17353, class_3922.field_17354, class_3922.field_17564});
    }

    public boolean getHasSpit(class_1936 blockAccess, class_2338 pos) {
        return (Boolean)blockAccess.method_8320(pos).method_11654((class_2769)HAS_SPIT);
    }

    public boolean setHasSpit(class_1937 world, class_2680 state, class_2338 pos, boolean bHasSpit) {
        return !world.method_8608() && world.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_SPIT, (Comparable)Boolean.valueOf(bHasSpit)));
    }

    private void playGetItemSound(class_1937 world, class_2338 pos, class_1657 player) {
        world.method_8396(null, pos, class_3417.field_15197, class_3419.field_15245, 0.2f, ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
    }
}

