/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.self_sustainable.block.entity;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.btwr.self_sustainable.block.blocks.SmokerOvenBlock;
import org.btwr.self_sustainable.block.interfaces.Ignitable;
import org.btwr.self_sustainable.entity.util.CustomSingleStackInventory;
import org.btwr.self_sustainable.recipe.cooking.OvenCookingRecipe;

public abstract class AbstractOvenBE
extends class_2586
implements Ignitable,
CustomSingleStackInventory {
    public int unlitFuelBurnTime;
    public int fuelBurnTime;
    int cookTime = 0;
    int cookTimeTotal = 0;
    public boolean lightOnNextUpdate = false;
    public static final int DEFAULT_COOK_TIME = 400;
    private final int cookTimeMultiplier = 4;
    protected class_1799 cookStack = class_1799.field_8037;
    private final Object2IntOpenHashMap<class_2960> recipesUsed = new Object2IntOpenHashMap();
    final class_1863.class_7266<class_9696, OvenCookingRecipe> matchGetter = class_1863.method_42302((class_3956)OvenCookingRecipe.Type.INSTANCE);
    public static final Map<class_1792, Integer> FUEL_TIME_MAP = class_2609.method_11196();
    private static final float CHANCE_OF_FIRE_SPREAD = 0.01f;
    public static final int BASE_BURN_TIME_MULTIPLIER = 2;
    private final int brickBurnTimeMultiplier = 4;
    public final int maxFuelBurnTime = 14200;
    public final int visualFuelLevelIncrement = 1600;
    public final int visualSputterFuelLevel = 400;
    protected int visualFuelLevel;

    public AbstractOvenBE(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.cookStack = class_1799.field_8037;
    }

    public Optional<class_8786<OvenCookingRecipe>> getRecipeFor(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return this.matchGetter.method_42303((class_9695)new class_9696(stack), this.field_11863);
    }

    protected static void markDirty(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8524(pos);
        if (!state.method_26215()) {
            world.method_8455(pos, state.method_26204());
        }
    }

    public int attemptToAddFuel(class_1799 stack) {
        if (!FUEL_TIME_MAP.containsKey(stack.method_7909())) {
            return 0;
        }
        int totalBurnTime = this.unlitFuelBurnTime + this.fuelBurnTime;
        int deltaBurnTime = 14200 - totalBurnTime;
        int numItemsBurned = 0;
        int itemBurnTime = FUEL_TIME_MAP.get(stack.method_7909());
        if (deltaBurnTime > 0) {
            numItemsBurned = deltaBurnTime / itemBurnTime;
            if (numItemsBurned == 0 && this.getVisualFuelLevel() <= 2) {
                numItemsBurned = 1;
            }
            if (numItemsBurned > 0) {
                if (numItemsBurned > stack.method_7947()) {
                    numItemsBurned = stack.method_7947();
                }
                this.unlitFuelBurnTime += itemBurnTime * numItemsBurned;
                this.method_5431();
            }
        }
        return numItemsBurned;
    }

    public boolean attemptToLight() {
        if (this.unlitFuelBurnTime > 0) {
            this.lightOnNextUpdate = true;
            return true;
        }
        return false;
    }

    void updateVisualFuelLevel() {
        int iTotalBurnTime = this.unlitFuelBurnTime + this.fuelBurnTime;
        int iNewFuelLevel = 0;
        if (iTotalBurnTime > 0) {
            if (iTotalBurnTime < 400) {
                iNewFuelLevel = 1;
            } else {
                int increments = (iTotalBurnTime - 400) / 1600;
                iNewFuelLevel = Math.min(increments + 2, 8);
            }
        }
        this.setVisualFuelLevel(iNewFuelLevel);
    }

    static void setParticles(class_1937 world, class_2338 pos, class_2680 state) {
        if (!((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            return;
        }
        double d = (double)pos.method_10263() + 0.5;
        double e = pos.method_10264();
        double f = (double)pos.method_10260() + 0.5;
        if (world.method_8409().method_43058() < 0.05) {
            world.method_8486(d, e, f, class_3417.field_14993, class_3419.field_15245, 0.25f + world.field_9229.method_43057() * 0.25f, 0.5f + world.field_9229.method_43057() * 0.25f, false);
            class_2350 direction = (class_2350)state.method_11654((class_2769)SmokerOvenBlock.FACING);
            class_2350.class_2351 axis = direction.method_10166();
            double g = 0.52;
            double h = world.method_8409().method_43058() * 0.6 - 0.3;
            double i = axis == class_2350.class_2351.field_11048 ? (double)direction.method_10148() * 0.52 : h;
            double j = world.method_8409().method_43058() * 6.0 / 16.0;
            double k = axis == class_2350.class_2351.field_11051 ? (double)direction.method_10165() * 0.52 : h;
            world.method_8406((class_2394)class_2398.field_11251, d + i, e + j, f + k, 0.0, 0.0, 0.0);
            world.method_8406((class_2394)class_2398.field_11240, d + i, e + j, f + k, 0.0, 0.0, 0.0);
        }
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.visualFuelLevel = nbt.method_10550("VisualFuelLevel");
        this.unlitFuelBurnTime = nbt.method_10568("UnlitFuelBurnTime");
        this.fuelBurnTime = nbt.method_10568("FuelBurnTime");
        this.cookTime = nbt.method_10568("CookTime");
        this.cookTimeTotal = nbt.method_10568("CookTimeTotal");
        this.readCookStackNbt(nbt, registryLookup);
        class_2487 nbtCompound = nbt.method_10562("RecipesUsed");
        for (String string : nbtCompound.method_10541()) {
            this.recipesUsed.put((Object)class_2960.method_60654((String)string), nbtCompound.method_10550(string));
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10575("VisualFuelLevel", (short)this.visualFuelLevel);
        nbt.method_10575("UnlitFuelBurnTime", (short)this.unlitFuelBurnTime);
        nbt.method_10575("FuelBurnTime", (short)this.fuelBurnTime);
        nbt.method_10575("CookTime", (short)this.cookTime);
        nbt.method_10575("CookTimeTotal", (short)this.cookTimeTotal);
        this.writeCookStackNbt(nbt, this.cookStack, registryLookup);
        class_2487 nbtCompound = new class_2487();
        this.recipesUsed.forEach((identifier, count) -> nbtCompound.method_10569(identifier.toString(), count.intValue()));
        nbt.method_10566("RecipesUsed", (class_2520)nbtCompound);
    }

    private void readCookStackNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (!nbt.method_10573("CookStack", 10)) {
            return;
        }
        this.cookStack = class_1799.field_24671.parse((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt.method_10562("CookStack")).result().orElse(class_1799.field_8037);
    }

    private void writeCookStackNbt(class_2487 nbt, class_1799 cookStack, class_7225.class_7874 registryLookup) {
        if (cookStack.method_7960()) {
            return;
        }
        nbt.method_10566("CookStack", cookStack.method_57376(registryLookup, (class_2520)new class_2487()));
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = this.method_38244(registryLookup);
        this.writeCookStackNbt(nbtCompound, this.cookStack, registryLookup);
        return nbtCompound;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public int getVisualFuelLevel() {
        return this.visualFuelLevel;
    }

    boolean isBurning() {
        return this.fuelBurnTime > 0;
    }

    public void setVisualFuelLevel(int visualFuelLevel) {
        assert (this.field_11863 != null);
        this.field_11863.method_8652(this.field_11867, (class_2680)this.field_11863.method_8320(this.field_11867).method_11657((class_2769)SmokerOvenBlock.FUEL_LEVEL, (Comparable)Integer.valueOf(visualFuelLevel)), 3);
        this.visualFuelLevel = visualFuelLevel;
        this.method_5431();
    }

    public boolean addItem(class_1297 user, class_1799 stack, int cookTime) {
        this.cookTimeTotal = cookTime;
        this.cookTime = 0;
        this.cookStack = stack.method_7971(1);
        this.method_10997().method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)user, (class_2680)this.method_11010()));
        this.updateListeners();
        return true;
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void retrieveItem(class_1657 player) {
        class_1799 cookStack = this.getCookStack();
        boolean addedToInventory = player.method_7270(cookStack);
        if (!addedToInventory) {
            player.method_7328(cookStack, false);
        }
        this.setStack(class_1799.field_8037);
        this.method_10997().method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)player, (class_2680)this.method_11010()));
        this.updateListeners();
    }

    @Override
    public boolean isEmpty() {
        return this.cookStack.method_7960();
    }

    @Override
    public class_1799 getCookStack() {
        return this.cookStack;
    }

    @Override
    public class_1799 removeStack() {
        this.cookStack = class_1799.field_8037;
        return this.cookStack;
    }

    @Override
    public void setStack(class_1799 newStack) {
        this.cookStack = newStack;
    }

    @Override
    public boolean canPlayerUse(class_1657 var1) {
        return true;
    }

    public void method_5448() {
    }
}

