/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.self_sustainable.block.entity;

import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.btwr.self_sustainable.block.ModBlocks;
import org.btwr.self_sustainable.block.blocks.UnfiredBrickBlock;
import org.btwr.self_sustainable.entity.ModBlockEntities;

public class UnfiredBrickBE
extends class_2586 {
    protected int dryingLevel = 0;
    private static final int TIME_TO_COOK = 12000;
    private static final int RAIN_COOK_DECAY = 10;
    private boolean isDrying = false;

    public UnfiredBrickBE(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.BRICK_UNFIRED, pos, state);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.dryingLevel = nbt.method_10568("DryingTime");
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10575("DryingTime", (short)this.dryingLevel);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, UnfiredBrickBE be) {
        if (!world.field_9236) {
            be.updateDrying();
        }
    }

    public void updateDrying() {
        int currentDryLevel;
        int displayedDryLevel;
        assert (this.field_11863 != null);
        boolean bNewDrying = this.field_11863.method_22339(this.field_11867) >= 15;
        class_2680 stateAbove = this.field_11863.method_8320(this.field_11867.method_10084());
        class_2248 blockAbove = stateAbove.method_26204();
        if (bNewDrying != this.isDrying) {
            this.isDrying = bNewDrying;
            this.field_11863.method_8524(this.field_11867);
        }
        UnfiredBrickBlock brickBlock = (UnfiredBrickBlock)ModBlocks.BRICK_UNFIRED;
        if (this.isDrying) {
            ++this.dryingLevel;
            if (this.dryingLevel >= 12000) {
                brickBlock.onFinishedCooking(this.field_11863, this.field_11867, this.field_11863.method_8320(this.field_11867));
                return;
            }
        } else if (this.isRainingOnBrick(this.field_11863, this.field_11867)) {
            this.dryingLevel -= 10;
            if (this.dryingLevel < 0) {
                this.dryingLevel = 0;
            }
        }
        if ((displayedDryLevel = brickBlock.getDryLevel((class_1936)this.field_11863, this.field_11867)) != (currentDryLevel = this.computeDryLevel())) {
            UnfiredBrickBlock.setDryingLevel(this.field_11863, this.field_11867, currentDryLevel);
        }
    }

    public boolean isRainingOnBrick(class_1937 world, class_2338 pos) {
        return world.method_8419() && world.method_8520(pos);
    }

    private int computeDryLevel() {
        if (this.dryingLevel > 0) {
            int iCookLevel = (int)((float)this.dryingLevel / 12000.0f * 7.0f) + 1;
            return class_3532.method_15340((int)iCookLevel, (int)0, (int)7);
        }
        return 0;
    }
}

