/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.self_sustainable.emi;

import dev.emi.emi.EmiPort;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.handler.CookingRecipeHandler;
import dev.emi.emi.recipe.EmiCookingRecipe;
import dev.emi.emi.runtime.EmiReloadLog;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.btwr.self_sustainable.block.ModBlocks;
import org.btwr.self_sustainable.item.ModItems;
import org.btwr.self_sustainable.recipe.cooking.OvenCookingRecipe;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class SSEmiPlugin
implements EmiPlugin {
    public static EmiRecipeCategory CRAFTING_SHAPED_WITH_DAMAGE = SSEmiPlugin.category("crafting_shaped_with_damage", EmiStack.of((class_1935)class_2246.field_9980));
    public static EmiRecipeCategory OVEN_COOKING = SSEmiPlugin.category("oven_cooking", EmiStack.of((class_1935)ModBlocks.OVEN_BRICK));
    public static EmiRecipeCategory PROGRESSIVE_CRAFTING = SSEmiPlugin.category("progressive_crafting", EmiStack.of((class_1935)ModItems.WICKER_WEAVING));

    public static EmiRecipeCategory category(String id, EmiStack icon) {
        return new EmiRecipeCategory(class_2960.method_60655((String)"self_sustainable", (String)id), (EmiRenderable)icon, (arg_0, arg_1, arg_2, arg_3) -> ((EmiStack)icon).render(arg_0, arg_1, arg_2, arg_3));
    }

    public void register(EmiRegistry registry) {
        this.registerOvenCooking(registry);
        this.registerProgressiveCrafting(registry);
    }

    private void registerOvenCooking(EmiRegistry registry) {
        registry.addCategory(OVEN_COOKING);
        registry.addWorkstation(OVEN_COOKING, (EmiIngredient)EmiStack.of((class_1935)ModBlocks.OVEN_BRICK));
        registry.addRecipeHandler(class_3917.field_17335, (EmiRecipeHandler)new CookingRecipeHandler(OVEN_COOKING));
        for (OvenCookingRecipe recipe : SSEmiPlugin.getRecipes(registry, OvenCookingRecipe.Type.INSTANCE)) {
            SSEmiPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((class_1874)recipe, OVEN_COOKING, 1, false), recipe);
        }
    }

    private void registerProgressiveCrafting(EmiRegistry registry) {
        registry.addCategory(PROGRESSIVE_CRAFTING);
        registry.addWorkstation(PROGRESSIVE_CRAFTING, (EmiIngredient)EmiStack.of((class_1935)ModItems.WICKER));
        registry.addRecipeHandler(class_3917.field_17335, (EmiRecipeHandler)new CookingRecipeHandler(PROGRESSIVE_CRAFTING));
        this.registerFakeProgression(registry, ModItems.WICKER_WEAVING, ModItems.WICKER);
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier, class_1860<?> recipe) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn((String)("Exception thrown when parsing vanilla aself_sustainablerecipe" + String.valueOf(EmiPort.getId(recipe))));
            EmiReloadLog.error((Throwable)e);
        }
    }

    private void registerFakeProgression(EmiRegistry registry, final class_1792 inputItem, class_1792 outputItem) {
        final EmiStack input = EmiStack.of((class_1935)inputItem);
        final EmiStack output = EmiStack.of((class_1935)outputItem);
        EmiRecipe fakeRecipe = new EmiRecipe(){

            public EmiRecipeCategory getCategory() {
                return PROGRESSIVE_CRAFTING;
            }

            @Nullable
            public class_2960 getId() {
                return class_2960.method_60655((String)"self_sustainable", (String)("progression_" + class_7923.field_41178.method_10221((Object)inputItem).method_12832()));
            }

            public List<EmiIngredient> getInputs() {
                return List.of(input);
            }

            public List<EmiStack> getOutputs() {
                return List.of(output);
            }

            public int getDisplayWidth() {
                return 78;
            }

            public int getDisplayHeight() {
                return 22;
            }

            public void addWidgets(WidgetHolder widgets) {
                widgets.addFillingArrow(27, 2, 60000).tooltip((mx, my) -> List.of(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable((String)"emi.progressive_crafting.tooltip", (Object[])new Object[]{Float.valueOf(10.0f)})))));
                widgets.addSlot((EmiIngredient)input, 5, 2);
                widgets.addSlot((EmiIngredient)output, 55, 2).recipeContext((EmiRecipe)this);
            }
        };
        registry.addRecipe(fakeRecipe);
    }

    private static <C extends class_9695, T extends class_1860<C>> Iterable<T> getRecipes(EmiRegistry registry, class_3956<T> type) {
        return registry.getRecipeManager().method_30027(type).stream().map(class_8786::comp_1933)::iterator;
    }
}

