/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.self_sustainable.item.items;

import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_5819;
import org.btwr.self_sustainable.item.items.FireStarterItem;
import org.btwr.self_sustainable.util.WorldUtils;

public class FireStarterItemPrimitive
extends FireStarterItem {
    private final float baseChance;
    private final float maxChance;
    private final float chanceIncreasePerUse;

    public FireStarterItemPrimitive(class_1792.class_1793 settings, float fExhaustionPerUse, float fBaseChance, float fMaxChance, float fChanceIncreasePerUse) {
        super(settings, fExhaustionPerUse);
        this.baseChance = fBaseChance;
        this.maxChance = fMaxChance;
        this.chanceIncreasePerUse = fChanceIncreasePerUse;
    }

    @Override
    public boolean checkChanceOfStart(class_1799 stack, class_5819 random) {
        boolean returnValue = false;
        class_1799 stackAdded = stack;
        float chance = stackAdded.btwr$getAccumulatedChance(this.baseChance);
        long currentTime = WorldUtils.getOverworldTimeServerOnly();
        long lastTime = stackAdded.btwr$getTimeOfLastUse();
        if (lastTime > 0L) {
            if (currentTime > lastTime) {
                long decayTime = currentTime - lastTime - 40L;
                if (decayTime > 0L && (chance -= (float)decayTime * 2.5E-4f) < this.baseChance) {
                    chance = this.baseChance;
                }
            } else if (currentTime < lastTime) {
                chance = this.baseChance;
            }
        }
        if (random.method_43057() <= chance) {
            returnValue = true;
        }
        if ((chance += this.chanceIncreasePerUse) > this.maxChance) {
            chance = this.maxChance;
        }
        stackAdded.btwr$setAccumulatedChance(chance);
        stackAdded.btwr$setTimeOfLastUse(currentTime);
        return returnValue;
    }

    @Override
    public void performUseEffects(class_1838 context) {
        class_1657 player = context.method_8036();
        assert (player != null);
        player.method_5783(class_3417.field_20614, 0.5f + 0.5f * (float)player.method_59922().method_43048(2), player.method_59922().method_43057() * 0.25f + 1.75f);
        if (!player.method_37908().method_8608()) {
            for (int var3 = 0; var3 < 5; ++var3) {
                class_243 var4 = new class_243(((double)player.method_59922().method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                var4 = var4.method_1037(-player.method_36455() * (float)Math.PI / 180.0f);
                var4 = var4.method_1024(-player.method_36454() * (float)Math.PI / 180.0f);
                class_243 var5 = new class_243(((double)player.method_59922().method_43057() - 0.5) * 0.3, (double)(-player.method_59922().method_43057()) * 0.6 - 0.3, 0.6);
                var5 = var5.method_1037(-player.method_36455() * (float)Math.PI / 180.0f);
                var5 = var5.method_1024(-player.method_36454() * (float)Math.PI / 180.0f);
                var5 = var5.method_1031(player.method_23317(), player.method_23318() + (double)player.method_18381(player.method_18376()), player.method_23321());
                player.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, this.method_7854()), var5.method_10216(), var5.method_10214(), var5.method_10215(), var4.method_10216(), var4.method_10214() + 0.05, var4.method_10215());
            }
        }
    }

    @Override
    public boolean attemptToLightBlock(class_1799 stack, class_1937 world, class_2338 pos, class_2350 facing) {
        if (super.attemptToLightBlock(stack, world, pos, facing)) {
            stack.btwr$setAccumulatedChance(this.baseChance);
            return true;
        }
        return false;
    }
}

