/*
 * Decompiled with CFR 0.152.
 */
package org.btwr.self_sustainable.util;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.class_2248;
import org.btwr.self_sustainable.block.blocks.CrudeTorchBlock;
import org.btwr.self_sustainable.block.blocks.CrudeWallTorchBlock;
import org.btwr.self_sustainable.block.utils.TorchFireState;

public class ModTorchHandler {
    private final Map<TorchFireState, CrudeTorchBlock> standingTorches = new EnumMap<TorchFireState, CrudeTorchBlock>(TorchFireState.class);
    private final Map<TorchFireState, CrudeWallTorchBlock> wallTorches = new EnumMap<TorchFireState, CrudeWallTorchBlock>(TorchFireState.class);
    public final String name;

    public ModTorchHandler(String name) {
        this.name = name;
    }

    public void addTorch(class_2248 block) {
        if (block instanceof CrudeTorchBlock) {
            CrudeTorchBlock standingTorch = (CrudeTorchBlock)block;
            this.addStandingTorch(standingTorch);
        } else if (block instanceof CrudeWallTorchBlock) {
            CrudeWallTorchBlock wallTorch = (CrudeWallTorchBlock)block;
            this.addWallTorch(wallTorch);
        }
    }

    private void addStandingTorch(CrudeTorchBlock block) {
        this.standingTorches.put(block.fireState, block);
        block.handler = this;
    }

    private void addWallTorch(CrudeWallTorchBlock block) {
        this.wallTorches.put(block.fireState, block);
        block.handler = this;
    }

    public CrudeTorchBlock getStandingTorch(TorchFireState state) {
        return this.standingTorches.get((Object)state);
    }

    public CrudeWallTorchBlock getWallTorch(TorchFireState state) {
        return this.wallTorches.get((Object)state);
    }
}

