/*
 * Decompiled with CFR 0.152.
 */
package net.ivangeevo.self_sustainable;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import net.ivangeevo.self_sustainable.ModItemGroup;
import net.ivangeevo.self_sustainable.block.ModBlocks;
import net.ivangeevo.self_sustainable.config.SSSettings;
import net.ivangeevo.self_sustainable.entity.ModBlockEntities;
import net.ivangeevo.self_sustainable.event.ModLootTableReplacement;
import net.ivangeevo.self_sustainable.item.ModItems;
import net.ivangeevo.self_sustainable.item.component.FoodComponentModifier;
import net.ivangeevo.self_sustainable.item.component.ModComponentsTypes;
import net.ivangeevo.self_sustainable.recipe.ModRecipes;
import net.ivangeevo.self_sustainable.registry.FuelRegistryManager;
import net.ivangeevo.self_sustainable.util.WorldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfSustainableMod
implements ModInitializer {
    public static final String MOD_ID = "self_sustainable";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"self_sustainable");
    public SSSettings settings;
    private static SelfSustainableMod instance;

    public static SelfSustainableMod getInstance() {
        return instance;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Self Sustainable.");
        this.loadSettings();
        instance = this;
        ModLootTableReplacement.initialize();
        FoodComponentModifier.register();
        ModBlocks.registerBlocks();
        ModBlocks.registerItemsPlaceableAsBlocks();
        ModBlocks.registerTorchHandler();
        ModItems.register();
        ModComponentsTypes.register();
        ModItemGroup.register();
        ModBlockEntities.register();
        ModRecipes.register();
        WorldUtils.init();
        FuelRegistryManager.initEntries();
    }

    public void loadSettings() {
        File file = new File("./config/btwr/selfSustainableCommon.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (SSSettings)gson.fromJson((Reader)fileReader, SSSettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load Tough Environment settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new SSSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/btwr/selfSustainableCommon.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save Tough Environment settings: " + e.getLocalizedMessage());
        }
    }
}

