/*
 * Decompiled with CFR 0.152.
 */
package net.ivangeevo.self_sustainable.block.blocks;

import net.ivangeevo.self_sustainable.block.ModBlocks;
import net.ivangeevo.self_sustainable.block.blocks.CrudeWallTorchBlock;
import net.ivangeevo.self_sustainable.block.entity.TorchBE;
import net.ivangeevo.self_sustainable.block.entity.util.FuelBurningBlock;
import net.ivangeevo.self_sustainable.block.interfaces.Ignitable;
import net.ivangeevo.self_sustainable.block.utils.TorchFireState;
import net.ivangeevo.self_sustainable.item.component.ModComponentsTypes;
import net.ivangeevo.self_sustainable.item.component.TorchFuelComponent;
import net.ivangeevo.self_sustainable.item.items.CrudeTorchBlockItem;
import net.ivangeevo.self_sustainable.tag.ModTags;
import net.ivangeevo.self_sustainable.util.ModTorchHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8810;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExtinguishingTorchBlock
extends class_2237
implements class_2343,
FuelBurningBlock {
    public class_2394 particle;
    public TorchFireState fireState;
    public ModTorchHandler handler;
    protected static final class_265 SHAPE = class_2248.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public AbstractExtinguishingTorchBlock(class_4970.class_2251 settings, class_2394 particle, TorchFireState fireLevel) {
        super(settings);
        this.particle = particle;
        this.fireState = fireLevel;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TorchBE(pos, state);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (this.fireState == TorchFireState.LIT || this.fireState == TorchFireState.SMOULDER) {
            AbstractExtinguishingTorchBlock.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
        }
        if (this.fireState == TorchFireState.LIT) {
            AbstractExtinguishingTorchBlock.displayParticle(this.particle, state, world, pos);
        }
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1268 hand = player.method_6058();
        class_1799 stack = player.method_5998(hand);
        if ((this.fireState == TorchFireState.LIT || this.fireState == TorchFireState.SMOULDER) && this.tryUse(ModTags.Items.TORCH_EXTINGUISHERS, stack)) {
            this.extinguish(world, pos, state);
            player.method_6104(hand);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TorchBE) {
            TorchBE be = (TorchBE)class_25862;
            if (itemStack.method_7909() instanceof CrudeTorchBlockItem) {
                TorchFuelComponent fuelComponent = (TorchFuelComponent)be.method_58693().method_57829(ModComponentsTypes.TORCH_FUEL);
                if (fuelComponent == null) {
                    return;
                }
                int fuel = fuelComponent.getFuel();
                fuelComponent.setFuel(fuel);
            }
        }
    }

    protected boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return class_8810.method_20044((class_4538)world, (class_2338)pos.method_10074(), (class_2350)class_2350.field_11036);
    }

    public boolean getCanBeSetOnFireDirectly(class_1936 blockAccess, class_2338 pos) {
        return this.fireState == TorchFireState.UNLIT;
    }

    public boolean setOnFireDirectly(class_1937 world, class_2338 pos) {
        if (this.getCanBeSetOnFireDirectly((class_1936)world, pos)) {
            class_2586 class_25862 = world.method_8321(pos);
            if (!(class_25862 instanceof TorchBE)) {
                return false;
            }
            TorchBE be = (TorchBE)class_25862;
            if (!world.method_8520(pos)) {
                this.changeTorch(world, pos, world.method_8320(pos), TorchFireState.LIT);
                Ignitable.playLitFX(world, pos);
                class_9323 components = be.method_58693();
                if (!components.method_57832(ModComponentsTypes.TORCH_FUEL)) {
                    class_9323 updatedComponents = class_9323.method_57827().method_57840(ModComponentsTypes.TORCH_FUEL, (Object)new TorchFuelComponent()).method_57838();
                    be.method_58684(updatedComponents);
                }
                be.method_5431();
            } else {
                Ignitable.playExtinguishSound(world, pos, false);
            }
            return true;
        }
        return false;
    }

    protected void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204() && this.isFuelHavingTorchBlock(newState)) {
            return;
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    private boolean isFuelHavingTorchBlock(class_2680 state) {
        return state.method_27852(ModBlocks.CRUDE_TORCH_LIT) || state.method_27852(ModBlocks.CRUDE_TORCH_SMOULDER) || state.method_27852(ModBlocks.CRUDE_WALL_TORCH_LIT) || state.method_27852(ModBlocks.CRUDE_WALL_TORCH_SMOULDER);
    }

    public void smoulder(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
        this.displaySharedParticles(state, world, pos);
        this.changeTorch(world, pos, state, TorchFireState.SMOULDER);
    }

    public void extinguish(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
        this.displaySharedParticles(state, world, pos);
        this.changeTorch(world, pos, state, TorchFireState.BURNED_OUT);
    }

    public void burnOut(class_1937 world, class_2338 pos, class_2680 state, boolean playSound) {
        if (playSound) {
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
        }
        this.displaySharedParticles(state, world, pos);
        this.changeTorch(world, pos, state, TorchFireState.BURNED_OUT);
    }

    public void light(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            Ignitable.playLitFX(world, pos);
            AbstractExtinguishingTorchBlock.displayParticle((class_2394)class_2398.field_11239, state, world, pos);
            AbstractExtinguishingTorchBlock.displayParticle((class_2394)class_2398.field_11240, state, world, pos);
            this.changeTorch(world, pos, state, TorchFireState.LIT);
        }
    }

    private void displaySharedParticles(class_2680 state, class_1937 world, class_2338 pos) {
        AbstractExtinguishingTorchBlock.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
        AbstractExtinguishingTorchBlock.displayParticle((class_2394)class_2398.field_11237, state, world, pos);
        AbstractExtinguishingTorchBlock.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
        AbstractExtinguishingTorchBlock.displayParticle((class_2394)class_2398.field_11251, state, world, pos);
    }

    public abstract boolean isWallTorch();

    public TorchFireState getFireState() {
        return this.fireState;
    }

    public void changeTorch(class_1937 world, class_2338 pos, class_2680 oldState, TorchFireState newType) {
        if (world.field_9236) {
            return;
        }
        class_9323 oldComponents = null;
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof TorchBE) {
            TorchBE oldBE = (TorchBE)class_25862;
            oldComponents = oldBE.method_58693();
        }
        class_2680 newState = this.isWallTorch() ? (class_2680)this.handler.getWallTorch(newType).method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)((class_2350)oldState.method_11654((class_2769)CrudeWallTorchBlock.FACING))) : this.handler.getStandingTorch(newType).method_9564();
        world.method_8501(pos, newState);
        class_2586 class_25863 = world.method_8321(pos);
        if (class_25863 instanceof TorchBE) {
            TorchBE newBe = (TorchBE)class_25863;
            if (oldComponents != null) {
                TorchFuelComponent oldFuel = (TorchFuelComponent)oldComponents.method_57829(ModComponentsTypes.TORCH_FUEL);
                class_9323.class_9324 builder = class_9323.method_57827();
                if (oldFuel != null) {
                    builder.method_57840(ModComponentsTypes.TORCH_FUEL, (Object)new TorchFuelComponent(oldFuel.getFuel()));
                }
                newBe.method_58684(builder.method_57838());
                newBe.method_5431();
            }
        }
    }

    public static void displayParticle(class_2394 particle, class_2680 state, class_1937 world, class_2338 pos, float spread) {
        double d = (double)pos.method_10263() + 0.5;
        double e = (double)pos.method_10264() + 0.7;
        double f = (double)pos.method_10260() + 0.5;
        if (particle != null) {
            if (state.method_28498((class_2769)class_2741.field_12481)) {
                class_2350 dir = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
                class_2350 dir2 = dir.method_10153();
                if (world instanceof class_3218) {
                    ((class_3218)world).method_14199(particle, d + 0.27 * (double)dir2.method_10148(), e + 0.22, f + 0.27 * (double)dir2.method_10165(), 1, 0.0, 0.0, 0.0, 0.0);
                } else if (world.field_9236) {
                    world.method_8406(particle, d + 0.27 * (double)dir2.method_10148(), e + 0.22, f + 0.27 * (double)dir2.method_10165(), 0.0, 0.0, 0.0);
                }
            } else if (world instanceof class_3218) {
                ((class_3218)world).method_14199(particle, d, e, f, 1, 0.0, 0.0, 0.0, 0.0);
            } else if (world.field_9236) {
                world.method_8406(particle, d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void displayParticle(class_2394 particle, class_2680 state, class_1937 world, class_2338 pos) {
        AbstractExtinguishingTorchBlock.displayParticle(particle, state, world, pos, 0.0f);
    }
}

