/*
 * Decompiled with CFR 0.152.
 */
package net.ivangeevo.self_sustainable.block.entity;

import java.util.Objects;
import java.util.Optional;
import net.ivangeevo.self_sustainable.block.interfaces.CampfireBlockAdded;
import net.ivangeevo.self_sustainable.block.interfaces.IVariableCampfireBlock;
import net.ivangeevo.self_sustainable.block.interfaces.Ignitable;
import net.ivangeevo.self_sustainable.block.utils.CampfireState;
import net.ivangeevo.self_sustainable.entity.ModBlockEntities;
import net.minecraft.class_1262;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3829;
import net.minecraft.class_3920;
import net.minecraft.class_3922;
import net.minecraft.class_3956;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class VariableCampfireBE
extends class_2586
implements class_3829 {
    private final class_2371<class_1799> itemsBeingCooked = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
    private int cookingTime = 0;
    private int cookingTotalTime = 0;
    private final class_1863.class_7266<class_9696, class_3920> matchGetter = class_1863.method_42302((class_3956)class_3956.field_17549);
    private static final int BASE_BURN_TIME_MULTIPLIER = 2;
    private static final int CAMPFIRE_BURN_TIME_MULTIPLIER = 8;
    private static final int DEFAULT_COOK_TIME = 400;
    private static final int TIME_TO_COOK = 4800;
    private static final int MAX_BURN_TIME = 6000;
    private static final int INITIAL_BURN_TIME = 3200;
    private static final int WARMUP_TIME = 200;
    private static final int REVERT_TO_SMALL_TIME = 400;
    private static final int BLAZE_TIME = 4800;
    private static final int SMOULDER_TIME = 6000;
    private static final int TIME_TO_BURN_FOOD = 2400;
    private static final float CHANCE_OF_FIRE_SPREAD = 0.05f;
    private static final float MODIFIED_CHANCE_OF_FIRE_SPREAD = 0.0045f;
    private static final float CHANCE_OF_GOING_OUT_FROM_RAIN = 0.01f;
    @Unique
    private class_1799 spitStack = null;
    private int burnTimeCountdown = 0;
    private int burnTimeSinceLit = 0;
    private int cookCounter = 0;
    private int smoulderCounter = 0;
    private int cookBurningCounter = 0;

    public int getCookTime() {
        return this.cookingTime;
    }

    public void setCookTime(int value) {
        this.cookingTime = value;
    }

    public void setTotalCookTime(int value) {
        this.cookingTotalTime = value;
    }

    public int getTotalCookTime() {
        return this.cookingTotalTime;
    }

    public int getBurnTimeSinceLit() {
        return this.burnTimeSinceLit;
    }

    public int getBurnTimeCd() {
        return this.burnTimeCountdown;
    }

    public VariableCampfireBE(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.CAMPFIRE, pos, state);
    }

    public static void litServerTick(class_1937 world, class_2338 pos, class_2680 state, VariableCampfireBE campfireBE) {
        int iCurrentFireLevel = VariableCampfireBE.getCurrentFireLevel(state);
        if (iCurrentFireLevel > 0) {
            if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10515) || world.method_8320(pos.method_10074()).method_27852(class_2246.field_10540)) {
                world.method_8501(pos, class_2246.field_10036.method_9564());
            }
            if (iCurrentFireLevel > 1 && world.field_9229.method_43057() <= 0.0045f) {
                for (class_2350 direction : class_2350.values()) {
                    VariableCampfireBE adjacentCampfireBE;
                    class_2338 adjacentPos = pos.method_10093(direction);
                    class_2680 adjacentState = world.method_8320(adjacentPos);
                    class_2248 adjacentBlock = adjacentState.method_26204();
                    if (!(adjacentBlock instanceof class_3922) || (adjacentCampfireBE = (VariableCampfireBE)world.method_8321(adjacentPos)) == null || !VariableCampfireBE.isAdjacentCampfireLightableFromSpread(adjacentState)) continue;
                    adjacentCampfireBE.changeFireLevel(world, 1);
                    adjacentCampfireBE.onFirstLit();
                    Ignitable.playLitFX(world, pos);
                }
            }
            ++campfireBE.burnTimeSinceLit;
            if (campfireBE.burnTimeCountdown > 0) {
                --campfireBE.burnTimeCountdown;
                if (iCurrentFireLevel == 3) {
                    --campfireBE.burnTimeCountdown;
                }
            }
            if ((iCurrentFireLevel = campfireBE.validateFireLevel(world, state, pos)) > 0) {
                boolean bl = false;
                class_1799 itemStack = (class_1799)campfireBE.itemsBeingCooked.getFirst();
                if (!itemStack.method_7960()) {
                    class_9696 singleStackRecipeInput;
                    class_1799 itemStack2;
                    bl = true;
                    campfireBE.setCookTime(campfireBE.getCookTime() + 1);
                    if (campfireBE.getCookTime() >= campfireBE.getTotalCookTime() && (itemStack2 = campfireBE.matchGetter.method_42303((class_9695)(singleStackRecipeInput = new class_9696(itemStack)), world).map(recipe -> ((class_3920)recipe.comp_1933()).method_59982(singleStackRecipeInput, (class_7225.class_7874)world.method_30349())).orElse(itemStack)).method_45435(world.method_45162())) {
                        campfireBE.itemsBeingCooked.set(0, (Object)itemStack2);
                        world.method_8413(pos, state, state, 3);
                        world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43287((class_2680)state));
                    }
                }
                if (bl) {
                    VariableCampfireBE.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
                }
                if (VariableCampfireBE.isGoOutFromRainChance(world, pos)) {
                    campfireBE.extinguishFire(world, state, pos, false);
                }
            }
        }
    }

    private static boolean isAdjacentCampfireLightableFromSpread(class_2680 state) {
        return (Integer)state.method_11654((class_2769)IVariableCampfireBlock.FIRE_LEVEL) == 0 && state.method_11654(IVariableCampfireBlock.FUEL_STATE) == CampfireState.NORMAL;
    }

    public static void unlitServerTick(class_1937 world, class_2338 pos, class_2680 state, VariableCampfireBE campfireBE) {
        boolean bl = false;
        if (campfireBE.smoulderCounter > 0) {
            --campfireBE.smoulderCounter;
            if (campfireBE.smoulderCounter == 0 || VariableCampfireBE.isGoOutFromRainChance(world, pos)) {
                campfireBE.stopSmouldering(world, pos);
            }
        }
        for (int i = 0; i < campfireBE.getItemsBeingCooked().size(); ++i) {
            if (campfireBE.getCookTime() <= 0) continue;
            bl = true;
            campfireBE.setCookTime(class_3532.method_15340((int)(campfireBE.getCookTime() - 2), (int)0, (int)campfireBE.getTotalCookTime()));
        }
        if (bl) {
            VariableCampfireBE.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, VariableCampfireBE campfireBE) {
        class_5819 random = world.field_9229;
        if (random.method_43057() < 0.11f) {
            int particleCount = random.method_43048(2) + 2;
            for (int i = 0; i < particleCount; ++i) {
                class_3922.method_17455((class_1937)world, (class_2338)pos, (boolean)((Boolean)state.method_11654((class_2769)class_3922.field_17353)), (boolean)false);
            }
        }
        if (!((class_1799)campfireBE.itemsBeingCooked.get(0)).method_7960() && random.method_43057() < 0.2f) {
            double d = (double)pos.method_10263() + 0.5;
            double e = (double)pos.method_10264() + 0.9;
            double g = (double)pos.method_10260() + 0.5;
            world.method_8406((class_2394)class_2398.field_11251, d, e, g, 0.0, 5.0E-4, 0.0);
        }
    }

    private static boolean isGoOutFromRainChance(class_1937 world, class_2338 pos) {
        return world.field_9229.method_43057() <= 0.01f && VariableCampfireBE.isRainingOnCampfire(world, pos);
    }

    public int validateFireLevel(class_1937 world, class_2680 state, class_2338 pos) {
        int iCurrentFireLevel = VariableCampfireBE.getCurrentFireLevel(state);
        if (iCurrentFireLevel > 0) {
            if (this.burnTimeCountdown <= 0) {
                this.extinguishFire(world, state, pos, true);
                return 0;
            }
            int iDesiredFireLevel = 2;
            if (this.burnTimeSinceLit < 200 || this.burnTimeCountdown < 400) {
                iDesiredFireLevel = 1;
            } else if (this.burnTimeCountdown > 4800) {
                iDesiredFireLevel = 3;
            }
            if (iDesiredFireLevel != iCurrentFireLevel) {
                this.changeFireLevel(world, iDesiredFireLevel);
                if (iDesiredFireLevel == 1 && iCurrentFireLevel == 2) {
                    Ignitable.playExtinguishSound(world, pos, false);
                }
                return iDesiredFireLevel;
            }
        } else if (this.burnTimeCountdown > 0 && state.method_11654(IVariableCampfireBlock.FUEL_STATE) == CampfireState.SMOULDERING) {
            this.relightSmouldering(world, pos);
            this.setFuelState(world, pos, CampfireState.NORMAL);
            return 1;
        }
        return iCurrentFireLevel;
    }

    public void setFuelState(class_1937 world, class_2338 pos, CampfireState fuelState) {
        world.method_8501(pos, (class_2680)((class_2680)world.method_8320(pos).method_11657(IVariableCampfireBlock.FUEL_STATE, (Comparable)((Object)fuelState))).method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false)));
    }

    private void relightSmouldering(class_1937 world, class_2338 pos) {
        this.burnTimeSinceLit = 0;
        class_2680 state = world.method_8320(pos);
        class_3922 block = (class_3922)state.method_26204();
        ((CampfireBlockAdded)block).relightFire(world, pos);
    }

    private void extinguishFire(class_1937 world, class_2680 state, class_2338 pos, boolean bSmoulder) {
        this.smoulderCounter = bSmoulder ? 6000 : 0;
        this.cookingTime = 0;
        this.cookBurningCounter = 0;
        class_3922 block = (class_3922)state.method_26204();
        ((CampfireBlockAdded)block).extinguishFire(world, state, pos, bSmoulder);
    }

    private void stopSmouldering(class_1937 world, class_2338 pos) {
        this.smoulderCounter = 0;
        class_3922 block = (class_3922)world.method_8320(pos).method_26204();
        ((CampfireBlockAdded)block).stopSmouldering(world, pos);
    }

    public static boolean isRainingOnCampfire(class_1937 world, class_2338 pos) {
        return world.method_8419() && world.method_8520(pos);
    }

    private static int getCurrentFireLevel(class_2680 state) {
        return (Integer)state.method_11654((class_2769)IVariableCampfireBlock.FIRE_LEVEL);
    }

    public class_2371<class_1799> getItemsBeingCooked() {
        return this.itemsBeingCooked;
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.itemsBeingCooked.clear();
        class_1262.method_5429((class_2487)nbt, this.itemsBeingCooked, (class_7225.class_7874)registryLookup);
        if (nbt.method_10545("CookingTime")) {
            this.cookingTime = nbt.method_10550("CookingTime");
        }
        if (nbt.method_10545("CookingTotalTime")) {
            this.cookingTotalTime = nbt.method_10550("CookingTotalTime");
        }
        if (nbt.method_10545("BurnCounter")) {
            this.burnTimeCountdown = nbt.method_10550("BurnCounter");
        }
        if (nbt.method_10545("BurnTime")) {
            this.burnTimeSinceLit = nbt.method_10550("BurnTime");
        }
        if (nbt.method_10545("SmoulderCounter")) {
            this.smoulderCounter = nbt.method_10550("SmoulderCounter");
        }
        if (nbt.method_10545("CookBurning")) {
            this.cookBurningCounter = nbt.method_10550("CookBurning");
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5427((class_2487)nbt, this.itemsBeingCooked, (boolean)true, (class_7225.class_7874)registryLookup);
        nbt.method_10569("CookingTime", this.cookingTime);
        nbt.method_10569("CookingTotalTime", this.cookingTotalTime);
        nbt.method_10569("BurnCounter", this.burnTimeCountdown);
        nbt.method_10569("BurnTime", this.burnTimeSinceLit);
        nbt.method_10569("SmoulderCounter", this.smoulderCounter);
        nbt.method_10569("CookBurning", this.cookBurningCounter);
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 nbtCompound = new class_2487();
        class_1262.method_5427((class_2487)nbtCompound, this.itemsBeingCooked, (boolean)true, (class_7225.class_7874)registryLookup);
        return nbtCompound;
    }

    public Optional<class_8786<class_3920>> getRecipeFor(class_1799 stack) {
        return this.itemsBeingCooked.stream().noneMatch(class_1799::method_7960) ? Optional.empty() : this.matchGetter.method_42303((class_9695)new class_9696(stack), this.field_11863);
    }

    public void addItem(@Nullable class_1297 user, class_1799 stack, int cookTime) {
        for (class_1799 itemStack : this.itemsBeingCooked) {
            if (!itemStack.method_7960()) continue;
            this.setTotalCookTime(cookTime);
            this.setCookTime(0);
            this.itemsBeingCooked.set(0, (Object)stack.method_7971(1));
            assert (this.field_11863 != null);
            this.field_11863.method_43276((class_6880)class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43286((class_1297)user, (class_2680)this.method_11010()));
            this.updateListeners();
            return;
        }
    }

    public void retrieveItem(class_1937 world, VariableCampfireBE campfireBE, class_1657 player) {
        class_1799 cookStack = (class_1799)campfireBE.getItemsBeingCooked().get(0);
        if (!cookStack.method_7960() && !world.method_8608()) {
            boolean addedToInventory = player.method_7270(cookStack);
            if (!addedToInventory) {
                player.method_7328(cookStack, false);
            }
            this.itemsBeingCooked.set(0, (Object)class_1799.field_8037);
            campfireBE.method_5431();
            Objects.requireNonNull(campfireBE.method_10997()).method_8413(campfireBE.method_11016(), campfireBE.method_11010(), campfireBE.method_11010(), 3);
        }
    }

    private void updateListeners() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public void method_5448() {
        this.itemsBeingCooked.clear();
    }

    public void changeFireLevel(class_1937 world, int iFireLevel) {
        class_2680 state = world.method_8320(this.field_11867);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_3922) {
            class_3922 block = (class_3922)class_22482;
            ((CampfireBlockAdded)block).changeFireLevel(world, this.field_11867, iFireLevel);
        }
    }

    public void setSpitStack(class_1799 stack) {
        if (stack != null) {
            this.spitStack = stack.method_7972();
            this.spitStack.method_7939(1);
        } else {
            this.spitStack = null;
        }
        this.method_5431();
    }

    public class_1799 getSpitStack() {
        return this.spitStack;
    }

    public void addBurnTime(class_2680 state, int iBurnTime) {
        this.burnTimeCountdown += iBurnTime * 8 * 2;
        this.burnTimeCountdown = Math.min(this.burnTimeCountdown, 6000);
        this.validateFireLevel(this.field_11863, state, this.field_11867);
    }

    public void addBurnTime(class_2680 state, class_1799 stack, int iBurnTime) {
        this.burnTimeCountdown += iBurnTime * stack.method_7947() * 8 * 2;
        this.burnTimeCountdown = Math.min(this.burnTimeCountdown, 6000);
        this.validateFireLevel(this.field_11863, state, this.field_11867);
    }

    public void onFirstLit() {
        this.burnTimeCountdown = 3200;
        this.burnTimeSinceLit = 0;
    }
}

