/*
 * Decompiled with CFR 0.152.
 */
package net.ivangeevo.self_sustainable.item.items;

import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.ivangeevo.self_sustainable.block.ModBlocks;
import net.ivangeevo.self_sustainable.block.blocks.AbstractExtinguishingTorchBlock;
import net.ivangeevo.self_sustainable.block.interfaces.IVariableCampfireBlock;
import net.ivangeevo.self_sustainable.block.utils.TorchFireState;
import net.ivangeevo.self_sustainable.item.component.ModComponentsTypes;
import net.ivangeevo.self_sustainable.item.component.TorchFuelComponent;
import net.ivangeevo.self_sustainable.tag.ModTags;
import net.ivangeevo.self_sustainable.util.ModTorchHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1827;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3922;

public class CrudeTorchBlockItem
extends class_1827
implements FabricItem {
    TorchFireState torchState;
    ModTorchHandler handler;
    private static final int FUEL_TIME = 24000;
    int maxFuel = 24000;

    public CrudeTorchBlockItem(class_2248 standingBlock, class_2248 wallBlock, class_1792.class_1793 settings, TorchFireState torchState, ModTorchHandler group) {
        super(standingBlock, wallBlock, settings, class_2350.field_11033);
        this.torchState = torchState;
        this.handler = group;
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 pos;
        class_1799 stack = context.method_8041();
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(pos = context.method_8037());
        if (state.method_26164(ModTags.Blocks.DIRECTLY_IGNITES_ITEM_ON_USE) || this.isSpecialLitBlock(state)) {
            if (this.torchState != TorchFireState.UNLIT) {
                return class_1269.field_5814;
            }
            if (!world.field_9236) {
                class_1657 player = context.method_8036();
                if (player != null) {
                    class_1799 litTorch = CrudeTorchBlockItem.stateStack(stack, TorchFireState.LIT);
                    stack.method_7934(1);
                    if (stack.method_7960()) {
                        player.method_6122(context.method_20287(), litTorch);
                    } else {
                        player.method_6122(context.method_20287(), stack);
                        if (!player.method_31548().method_7394(litTorch)) {
                            player.method_7328(litTorch, false);
                        }
                    }
                }
                world.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 0.5f, 1.2f);
            }
            return class_1269.field_5812;
        }
        return super.method_7884(context);
    }

    private boolean isSpecialLitBlock(class_2680 state) {
        boolean lit = state.method_28498((class_2769)class_2741.field_12548) && (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false;
        boolean hasFireLevel = state.method_28498((class_2769)IVariableCampfireBlock.FIRE_LEVEL) && (Integer)state.method_11654((class_2769)IVariableCampfireBlock.FIRE_LEVEL) > 0;
        return lit && (state.method_27852(ModBlocks.OVEN_BRICK) || state.method_27852(ModBlocks.SMOKER_BRICK)) || hasFireLevel && state.method_26204() instanceof class_3922;
    }

    public boolean method_31567(class_1799 stack) {
        int fuel = CrudeTorchBlockItem.getFuel(stack);
        return fuel > 0 && fuel < this.maxFuel;
    }

    public int method_31569(class_1799 stack) {
        int fuel = CrudeTorchBlockItem.getFuel(stack);
        if (this.maxFuel != 0) {
            return Math.round(13.0f - (float)(this.maxFuel - fuel) * 13.0f / (float)this.maxFuel);
        }
        return 0;
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        boolean newHasFuel;
        boolean oldHasFuel = oldStack.method_57353().method_57832(ModComponentsTypes.TORCH_FUEL);
        return oldHasFuel != (newHasFuel = newStack.method_57353().method_57832(ModComponentsTypes.TORCH_FUEL));
    }

    public static class_1799 stateStack(class_1799 inputStack, TorchFireState newState) {
        class_1799 outputStack = class_1799.field_8037;
        if (inputStack.method_7909() instanceof class_1747 && inputStack.method_7909() instanceof CrudeTorchBlockItem) {
            AbstractExtinguishingTorchBlock newBlock = (AbstractExtinguishingTorchBlock)((class_1747)inputStack.method_7909()).method_7711();
            CrudeTorchBlockItem newItem = (CrudeTorchBlockItem)newBlock.handler.getStandingTorch(newState).method_8389();
            outputStack = CrudeTorchBlockItem.changedCopy(inputStack, (class_1792)newItem);
            if (newState == TorchFireState.BURNED_OUT) {
                outputStack.method_57381(ModComponentsTypes.TORCH_FUEL);
            }
        }
        return outputStack;
    }

    public static int getFuel(class_1799 stack) {
        return ((TorchFuelComponent)stack.method_57825(ModComponentsTypes.TORCH_FUEL, (Object)new TorchFuelComponent())).getFuel();
    }

    public TorchFireState getTorchState() {
        return this.torchState;
    }

    public static class_1799 changedCopy(class_1799 stack, class_1792 replacementItem) {
        class_1799 itemStack = new class_1799((class_1935)replacementItem, 1);
        if (stack.method_57353().method_57832(ModComponentsTypes.TORCH_FUEL)) {
            TorchFuelComponent fuel = (TorchFuelComponent)stack.method_57825(ModComponentsTypes.TORCH_FUEL, (Object)new TorchFuelComponent());
            itemStack.method_57379(ModComponentsTypes.TORCH_FUEL, (Object)new TorchFuelComponent(fuel.getFuel()));
        }
        return itemStack;
    }

    public static class_1799 addFuel(class_1799 stack, class_1937 world, int amount) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof CrudeTorchBlockItem) {
            CrudeTorchBlockItem torchItem = (CrudeTorchBlockItem)class_17922;
            if (!world.field_9236) {
                int fuel = CrudeTorchBlockItem.getFuel(stack);
                if (torchItem.method_57347().method_57832(ModComponentsTypes.TORCH_FUEL)) {
                    stack.method_57379(ModComponentsTypes.TORCH_FUEL, (Object)new TorchFuelComponent(fuel));
                }
                if ((fuel += amount) <= 0) {
                    stack = CrudeTorchBlockItem.stateStack(stack, TorchFireState.BURNED_OUT);
                } else {
                    if (fuel > 24000) {
                        fuel = 24000;
                    }
                    stack.method_57379(ModComponentsTypes.TORCH_FUEL, (Object)new TorchFuelComponent(fuel));
                }
            }
        }
        return stack;
    }

    public boolean getCanItemStartFireOnUse(class_1799 stack) {
        return this.torchState == TorchFireState.LIT || this.torchState == TorchFireState.SMOULDER;
    }
}

