/*
 * Decompiled with CFR 0.152.
 */
package net.ivangeevo.self_sustainable.mixin.entity;

import com.mojang.authlib.GameProfile;
import java.util.Random;
import net.ivangeevo.self_sustainable.block.utils.TorchFireState;
import net.ivangeevo.self_sustainable.item.ModItems;
import net.ivangeevo.self_sustainable.item.items.CrudeTorchBlockItem;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1827;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    @Unique
    private static Random random = new Random();

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void tick(CallbackInfo info) {
        if (!this.method_37908().field_9236) {
            int i;
            class_3222 player = (class_3222)this;
            class_1661 inventory = player.method_31548();
            for (i = 0; i < inventory.field_7544.size(); ++i) {
                this.tickTorch((class_1799)inventory.field_7544.get(i), i, (class_2371<class_1799>)inventory.field_7544);
            }
            for (i = 0; i < inventory.field_7547.size(); ++i) {
                this.tickTorch((class_1799)inventory.field_7547.get(i), i, (class_2371<class_1799>)inventory.field_7547);
            }
            this.checkWaterBehavior(player, inventory);
        }
    }

    @Unique
    private void checkWaterBehavior(class_3222 player, class_1661 inventory) {
        if (player.method_7337() || player.method_7325()) {
            return;
        }
        class_2338 pos = player.method_24515();
        boolean isRainingOnTorch = player.method_37908().method_8520(pos);
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            class_1792 item = stack.method_7909();
            if (item instanceof CrudeTorchBlockItem) {
                CrudeTorchBlockItem torchItem = (CrudeTorchBlockItem)item;
                if (isRainingOnTorch && random.nextInt(200) == 0) {
                    this.rainTorch(torchItem, stack, player.method_37908(), pos);
                }
                this.destroyInWater(torchItem, stack, player, pos);
            }
            if (!(item instanceof class_1827)) continue;
            this.extinguishInWater(stack, (class_1657)player, pos, i);
        }
    }

    @Unique
    private void destroyInWater(CrudeTorchBlockItem torchItem, class_1799 stack, class_3222 player, class_2338 pos) {
        if (player.method_5869() && this.isBurning(torchItem)) {
            stack.method_7934(1);
            player.method_37908().method_8396(null, pos.method_10084(), class_3417.field_15102, class_3419.field_15248, 0.5f, 1.0f);
        }
    }

    @Unique
    private void extinguishInWater(class_1799 stack, class_1657 player, class_2338 pos, int slot) {
        if (player.method_5869() && stack.method_31574(class_1802.field_8810)) {
            class_1799 unlitTorch = new class_1799((class_1935)ModItems.TORCH_UNLIT, stack.method_7947());
            player.method_31548().method_5447(slot, unlitTorch);
            player.method_37908().method_8396(null, pos.method_10084(), class_3417.field_15102, class_3419.field_15248, 0.5f, 1.0f);
        }
    }

    @Unique
    private void rainTorch(CrudeTorchBlockItem torchItem, class_1799 stack, class_1937 world, class_2338 pos) {
        if (this.isBurning(torchItem)) {
            stack.method_7934(1);
            world.method_8396(null, pos.method_10084(), class_3417.field_15102, class_3419.field_15248, 0.5f, 1.0f);
        }
    }

    @Unique
    private boolean isBurning(CrudeTorchBlockItem torchItem) {
        return torchItem.getTorchState() == TorchFireState.LIT || torchItem.getTorchState() == TorchFireState.SMOULDER;
    }

    @Unique
    private void tickTorch(class_1799 stack, int index, class_2371<class_1799> list) {
        class_1792 item = stack.method_7909();
        if (item instanceof CrudeTorchBlockItem) {
            TorchFireState state = ((CrudeTorchBlockItem)item).getTorchState();
            if (state == TorchFireState.LIT) {
                list.set(index, (Object)CrudeTorchBlockItem.addFuel(stack, this.method_37908(), -1));
            } else if (state == TorchFireState.SMOULDER && random.nextInt(3) == 0) {
                list.set(index, (Object)CrudeTorchBlockItem.addFuel(stack, this.method_37908(), -1));
            }
        }
    }
}

