/*
 * Decompiled with CFR 0.152.
 */
package net.ivangeevo.self_sustainable.util;

import java.util.List;
import java.util.function.Supplier;
import net.ivangeevo.self_sustainable.util.VectorUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import net.minecraft.class_8567;

public class ItemUtils {
    public static void ejectStackWithRandomOffset(class_1937 world, class_2338 pos, class_1799 stack) {
        float xOffset = world.method_8409().method_43057() * 0.7f + 0.15f;
        float yOffset = world.method_8409().method_43057() * 0.2f + 0.1f;
        float zOffset = world.method_8409().method_43057() * 0.7f + 0.15f;
        ItemUtils.ejectStackWithRandomVelocity(world, (float)pos.method_10263() + xOffset, (float)pos.method_10264() + yOffset, (float)pos.method_10260() + zOffset, stack);
    }

    public static void ejectSingleItemWithRandomOffset(class_1937 world, class_2338 pos, int iShiftedItemIndex) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10200(iShiftedItemIndex);
        class_1792 itemConvertible = item.method_8389();
        class_1799 itemStack = new class_1799((class_1935)itemConvertible, 1);
        ItemUtils.ejectStackWithRandomOffset(world, pos, itemStack);
    }

    public static void ejectStackWithRandomVelocity(class_1937 world, double x, double y, double z, class_1799 stack) {
        class_1542 itemEntity = new class_1542(world, x, y, z, stack);
        float velocityFactor = 0.05f;
        itemEntity.method_18800(world.field_9229.method_43059() * (double)velocityFactor, world.field_9229.method_43059() * (double)velocityFactor + (double)0.2f, world.field_9229.method_43059() * (double)velocityFactor);
        itemEntity.method_6982(10);
        world.method_8649((class_1297)itemEntity);
    }

    public static void ejectSingleItemWithRandomVelocity(class_1937 world, float xPos, float yPos, float zPos, int iShiftedItemIndex, int iDamage) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10200(iShiftedItemIndex);
        class_1792 itemConvertible = item.method_8389();
        class_1799 itemStack = new class_1799((class_1935)itemConvertible, 1);
        ItemUtils.ejectStackWithRandomVelocity(world, xPos, yPos, zPos, itemStack);
    }

    public static void dropStackAsIfBlockHarvested(class_1937 world, class_2338 pos, class_1799 stack) {
        if (!world.field_9236 && !stack.method_7960() && world.method_8450().method_8355(class_1928.field_19392)) {
            double d = 0.5;
            double d1 = world.field_9229.method_43057() * 0.8f + 0.1f;
            double d2 = world.field_9229.method_43057() * 0.8f + 0.1f;
            double d3 = world.field_9229.method_43057() * 0.8f + 0.1f;
            class_1542 entityitem = new class_1542(world, (double)pos.method_10263() + d, (double)pos.method_10264() + d1, (double)pos.method_10260() + d2, stack);
            entityitem.method_23327(world.field_9229.method_43059() * 0.05, world.field_9229.method_43059() * 0.05 + 0.2, world.field_9229.method_43059() * 0.05);
            world.method_8649((class_1297)entityitem);
        }
    }

    public static void dropSingleItemAsIfBlockHarvested(class_1937 world, class_2338 pos, int iShiftedItemIndex, int iDamage) {
        class_1792 item = (class_1792)class_7923.field_41178.method_10200(iShiftedItemIndex);
        class_1792 itemConvertible = item.method_8389();
        class_1799 itemStack = new class_1799((class_1935)itemConvertible, 1);
        ItemUtils.dropStackAsIfBlockHarvested(world, pos, itemStack);
    }

    public static void ejectStackFromBlockTowardsFacing(class_1937 world, class_2338 pos, class_2680 blockState, class_1799 stack, class_2350 direction) {
        class_243 ejectPos = new class_243(world.method_8409().method_43058() * 0.7 + 0.15, 1.2 + world.method_8409().method_43058() * 0.1, world.method_8409().method_43058() * 0.7 + 0.15);
        double x = ejectPos.field_1352;
        ejectPos = VectorUtils.tiltVector(ejectPos, direction.method_10146());
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_24424, (Object)pos.method_46558()).method_51874(class_181.field_1229, (Object)stack).method_51877(class_181.field_1228, (Object)world.method_8321(pos));
        List drops = blockState.method_26189(builder);
        for (class_1799 droppedItems : drops) {
            class_1542 entity = new class_1542(world, (double)pos.method_10263() + ejectPos.method_10216(), (double)pos.method_10264() + ejectPos.method_10214(), (double)pos.method_10260() + ejectPos.method_10215(), droppedItems);
            ItemUtils.spawnItemEntity(world, () -> entity, direction);
        }
        blockState.method_26180((class_3218)world, pos, stack, false);
    }

    private static void spawnItemEntity(class_1937 world, Supplier<class_1542> itemEntitySupplier, class_2350 direction) {
        class_1542 entity = itemEntitySupplier.get();
        int iFacing = direction.method_10146();
        if (iFacing < 2) {
            entity.field_6038 = world.method_8409().method_43058() * 0.1 - 0.05;
            entity.field_5989 = world.method_8409().method_43058() * 0.1 - 0.05;
            entity.field_5971 = iFacing == 0 ? 0.0 : 0.2;
        } else {
            class_243 ejectVel = new class_243(world.method_8409().method_43058() * 0.1 - 0.05, 0.2, world.method_8409().method_43058() * -0.05 - 0.05);
            ejectVel.method_1024((float)direction.method_10146());
            entity.field_6038 = ejectVel.field_1352;
            entity.field_5971 = ejectVel.field_1351;
            entity.field_5989 = ejectVel.field_1350;
        }
        entity.method_6988();
        world.method_8649((class_1297)entity);
    }

    public void rotateAsVectorAroundJToFacing(class_243 vector, int iFacing) {
        if (iFacing > 2) {
            if (iFacing == 5) {
                double tempZ = vector.field_1352;
                vector = new class_243(-vector.field_1350, vector.field_1351, tempZ);
            } else if (iFacing == 4) {
                double tempZ = -vector.field_1352;
                vector = new class_243(vector.field_1350, vector.field_1351, tempZ);
            } else {
                vector = new class_243(-vector.field_1352, -vector.field_1351, -vector.field_1350);
            }
        }
    }

    public static void givePlayerStackOrEjectFromTowardsFacing(class_1657 player, class_2680 state, class_1799 stack, class_2338 pos, class_2350 direction) {
        if (player.method_31548().method_7394(stack)) {
            player.method_37908().method_43129(player, null, class_3417.field_15197, class_3419.field_15245, 0.2f, ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f);
        } else if (!player.method_37908().field_9236) {
            ItemUtils.ejectStackFromBlockTowardsFacing(player.method_37908(), pos, state, stack, direction);
        }
    }

    public static void givePlayerStackOrEjectFavorEmptyHand(class_1657 player, class_1799 stack, class_2338 pos) {
        if (player.method_7270(stack)) {
            class_2338 thisPos = player.method_24515();
            float pitchChance = ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f;
            player.method_37908().method_8396(player, thisPos, class_3417.field_14576, class_3419.field_15248, 0.2f, pitchChance);
        } else {
            ItemUtils.givePlayerStackOrEject(player, stack, pos);
        }
    }

    public static void givePlayerStackOrEject(class_1657 player, class_1799 stack, class_2338 pos) {
        if (player.method_31548().method_7394(stack)) {
            float pitchChance = ((player.method_59922().method_43057() - player.method_59922().method_43057()) * 0.7f + 1.0f) * 2.0f;
            player.method_37908().method_43129(player, null, class_3417.field_14576, class_3419.field_15248, 0.2f, pitchChance);
        } else if (!player.method_37908().field_9236) {
            ItemUtils.ejectStackWithRandomOffset(player.method_37908(), pos, stack);
        }
    }

    public static void givePlayerStackOrEject(class_1657 player, class_1799 stack) {
        if (player.method_31548().method_7394(stack)) {
            player.method_37908().method_43129(player, null, class_3417.field_14576, class_3419.field_15245, 0.2f, 1.0f);
        } else if (!player.method_37908().method_8608()) {
            ItemUtils.ejectStackWithRandomVelocity(player.method_37908(), player.method_23317(), player.method_23318(), player.method_23321(), stack);
        }
    }
}

