/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.Blocks;

import cn.adwadg.murasame.Murasame;
import cn.adwadg.murasame.Registry.ModBlocks;
import cn.adwadg.murasame.TileEntity.BlockEntity.EmbeddedBladeStoneEntity;
import cn.adwadg.murasame.advancement.ModAdvancements;
import cn.adwadg.murasame.config.ModConfig;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EmbeddedBladeStoneBlock
extends Block
implements EntityBlock {
    private static final EntityType<?>[] UNDEAD_MOBS = new EntityType[]{EntityType.f_20501_, EntityType.f_20524_, EntityType.f_20497_, EntityType.f_20531_, EntityType.f_20562_, EntityType.f_20509_, EntityType.f_20496_, EntityType.f_20530_, EntityType.f_20525_, EntityType.f_20502_};

    public EmbeddedBladeStoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        Murasame.LOGGER.info("Creating new EmbeddedBladeStoneEntity at {}", (Object)pos);
        return new EmbeddedBladeStoneEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_() && hand == InteractionHand.MAIN_HAND) {
            BlockEntity be = level.m_7702_(pos);
            if (!(be instanceof EmbeddedBladeStoneEntity)) {
                return InteractionResult.FAIL;
            }
            EmbeddedBladeStoneEntity entity = (EmbeddedBladeStoneEntity)be;
            if (player.f_36078_ < (Integer)ModConfig.GAINLEVELNEEDED.get()) {
                player.m_5661_((Component)Component.m_237115_((String)"message.murasame.need_level"), true);
                level.m_5594_(null, pos, SoundEvents.f_12507_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.FAIL;
            }
            if (!this.hasKilledEnoughUndead(player)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.murasame.need_more_undead_kills"), true);
                level.m_5594_(null, pos, SoundEvents.f_12507_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.FAIL;
            }
            if (!this.hasEnoughPositiveBuffs(player)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.murasame.need_more_buffs"), true);
                level.m_5594_(null, pos, SoundEvents.f_12507_, SoundSource.BLOCKS, 0.8f, 1.0f);
                return InteractionResult.FAIL;
            }
            ItemStack blade = entity.getBladeStack();
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 1.2f);
            level.m_5594_(null, pos, SoundEvents.f_12563_, SoundSource.BLOCKS, 0.8f, 1.0f);
            if (!player.m_150109_().m_36054_(blade)) {
                player.m_36176_(blade, false);
            }
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.8f, 1.2f);
            if (!player.m_150109_().m_36054_(blade)) {
                player.m_36176_(blade, false);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancements.grantFromStone(serverPlayer);
            }
            if (((Boolean)ModConfig.GAINCLEANLEVEL.get()).booleanValue()) {
                player.f_36078_ -= ((Integer)ModConfig.GAINLEVELNEEDED.get()).intValue();
            }
            level.m_7731_(pos, ((Block)ModBlocks.EMPTY_STONE.get()).m_49966_(), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private boolean hasKilledEnoughUndead(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int totalUndeadKills = 0;
            for (EntityType<?> undead : UNDEAD_MOBS) {
                totalUndeadKills += serverPlayer.m_8951_().m_13015_(Stats.f_12986_.m_12902_(undead));
            }
            return totalUndeadKills >= (Integer)ModConfig.GAINKILLNEEDED.get();
        }
        return false;
    }

    private boolean hasEnoughPositiveBuffs(Player player) {
        List positiveEffects = player.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL).collect(Collectors.toList());
        return positiveEffects.size() >= (Integer)ModConfig.GAINEFFECTSNEEDED.get();
    }
}

