/*
 * Decompiled with CFR 0.152.
 */
package cn.adwadg.murasame.Entities;

import cn.adwadg.murasame.Murasame;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityMurasameSoul
extends PathfinderMob {
    private int aliveTicks = 0;
    private double lastX = 0.0;
    private double lastY = 0.0;
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(EntityMurasameSoul.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Boolean> VISIBLE = SynchedEntityData.m_135353_(EntityMurasameSoul.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Nullable
    private Player cachedOwner;
    public int hideCooldown = 0;

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public EntityMurasameSoul(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_20331_(true);
        this.m_21557_(true);
        this.m_20225_(true);
        this.m_6842_(false);
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    protected Component m_5677_() {
        return Component.m_237115_((String)"entity.murasame.soul");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
        this.f_19804_.m_135372_(VISIBLE, (Object)true);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).ifPresent(uuid -> tag.m_128362_("OwnerUUID", uuid));
        tag.m_128379_("Visible", ((Boolean)this.f_19804_.m_135370_(VISIBLE)).booleanValue());
        tag.m_128405_("HideCooldown", this.hideCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("OwnerUUID")) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(tag.m_128342_("OwnerUUID")));
        }
        if (tag.m_128441_("Visible")) {
            this.f_19804_.m_135381_(VISIBLE, (Object)tag.m_128471_("Visible"));
        }
        if (tag.m_128441_("HideCooldown")) {
            this.hideCooldown = tag.m_128451_("HideCooldown");
        }
    }

    public void setVisible(boolean visibility) {
        this.m_6842_(!visibility);
        this.f_19804_.m_135381_(VISIBLE, (Object)visibility);
    }

    public boolean isVisible() {
        return (Boolean)this.f_19804_.m_135370_(VISIBLE);
    }

    public boolean m_21532_() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.aliveTicks;
        if (!this.m_9236_().f_46443_) {
            if (this.cachedOwner == null) {
                ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).ifPresent(uuid -> {
                    Entity entity = ((ServerLevel)this.m_9236_()).m_8791_(uuid);
                    if (entity instanceof Player) {
                        Player player;
                        this.cachedOwner = player = (Player)entity;
                        Murasame.LOGGER.debug("\u5f3a\u5236\u7ed1\u5b9aOwner: {}", (Object)player);
                    } else {
                        Murasame.LOGGER.warn("Owner\u5b9e\u4f53\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u79fb\u9664");
                        this.m_146870_();
                    }
                });
            }
            if (this.aliveTicks > 20) {
                if (this.cachedOwner == null || !this.cachedOwner.m_6084_()) {
                    this.m_146870_();
                    return;
                }
                if (this.m_20280_((Entity)this.cachedOwner) > 64.25) {
                    this.m_146870_();
                    return;
                }
            }
            if (this.cachedOwner != null) {
                if (!this.cachedOwner.m_6084_() || this.m_20280_((Entity)this.cachedOwner) > 4096.0) {
                    this.m_146870_();
                    return;
                }
                if ((double)this.cachedOwner.m_146909_() != this.lastX || this.cachedOwner.m_20186_() != this.lastY) {
                    this.updatePosition();
                }
            }
        }
        if (this.cachedOwner != null) {
            this.lastX = this.cachedOwner.m_146909_();
            this.lastY = this.cachedOwner.m_146908_();
        }
    }

    private void updatePosition() {
        float distance = 3.5f;
        float horizontalOffset = -2.3f;
        Vec3 position = null;
        if (this.cachedOwner != null) {
            position = this.calculateLeftFrontPosition(this.cachedOwner, distance, horizontalOffset);
        }
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        if (this.cachedOwner != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.cachedOwner.m_146892_());
        }
        this.f_19812_ = true;
    }

    public Vec3 calculateLeftFrontPosition(Player player, float distance, float horizontalOffset) {
        Vec3 lookVec = player.m_20154_();
        Vec3 leftVec = new Vec3(-lookVec.f_82481_, 0.0, lookVec.f_82479_).m_82541_();
        Vec3 frontOffset = lookVec.m_82490_((double)distance);
        Vec3 leftOffset = leftVec.m_82490_((double)horizontalOffset);
        return player.m_146892_().m_82549_(frontOffset).m_82549_(leftOffset).m_82492_(0.0, (double)(this.m_20206_() / 2.0f), 0.0);
    }

    public void m_146922_(float yRot) {
        if (Float.isFinite(yRot)) {
            super.m_146922_(yRot);
        } else {
            Murasame.LOGGER.error("\u5c1d\u8bd5\u8bbe\u7f6e\u65e0\u6548yRot: {}", (Object)Float.valueOf(yRot));
        }
    }

    public void m_146926_(float xRot) {
        if (Float.isFinite(xRot)) {
            super.m_146926_(xRot);
        } else {
            Murasame.LOGGER.error("\u5c1d\u8bd5\u8bbe\u7f6e\u65e0\u6548xRot: {}", (Object)Float.valueOf(xRot));
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        Murasame.LOGGER.warn("\u5b9e\u4f53\u88ab\u79fb\u9664 | \u539f\u56e0: {} | Tick: {} | \u4f4d\u7f6e: {},{},{}", new Object[]{reason, this.aliveTicks, this.m_20185_(), this.m_20186_(), this.m_20189_()});
        super.m_142687_(reason);
    }

    public void setOwner(Player player) {
        this.cachedOwner = player;
        UUID uuid = player.m_20148_();
        this.f_19804_.m_135381_(OWNER_UUID, Optional.of(uuid));
    }

    public void hideTemporarily(int ticks) {
        this.hideCooldown = ticks;
    }

    public boolean m_7306_(Entity entity) {
        return this == entity;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (OWNER_UUID.equals(key)) {
            this.cachedOwner = null;
        }
        if (VISIBLE.equals(key)) {
            this.m_6842_((Boolean)this.f_19804_.m_135370_(VISIBLE) == false);
        }
        super.m_7350_(key);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        this.m_6842_((Boolean)this.f_19804_.m_135370_(VISIBLE) == false);
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }
}

